<?php
if (!defined('ABSPATH')) {
    exit;
}

// ✅ プラグインがインストール・登録済か  
// ✅ Whether the plugin is installed and registered
if (!function_exists('sbp2_is_plugin_active')) {
    function sbp2_is_plugin_active(): bool {
        return get_option('sbp2_plugin_status') === 'active';
    }
}

// ✅ プロ版（有料）か？  
// ✅ Is it the Pro version (paid)?
if (!function_exists('sbp2_is_pro_user')) {
    function sbp2_is_pro_user(): bool {
        return get_option('sbp2_subscription_status') === 'active';
    }
}

// ✅ エンタープライズ契約か？  
// ✅ Is it an Enterprise contract?
if (!function_exists('sbp2_is_enterprise_user')) {
    function sbp2_is_enterprise_user(): bool {
        return get_option('sbp2_subscription_status') === 'enterprise';
    }
}

// ✅ 無料ユーザーか？  
// ✅ Is it a free user?
if (!function_exists('sbp2_is_free_user')) {
    function sbp2_is_free_user(): bool {
        $status = get_option('sbp2_plugin_status');
        $sub_status = get_option('sbp2_subscription_status');
        return ($status === 'active') && ($sub_status !== 'active' && $sub_status !== 'enterprise');
    }
}


if (!function_exists('sbp2_restricted_feature_page')) {
/**
 * 特定プラン以上限定機能のアクセスブロック表示
 * @param string $required_plan 'pro' または 'enterprise'
 * Display access block for features limited to specific plans or above
 *
 */
    function sbp2_restricted_feature_page(string $required_plan = 'enterprise') {
        echo '<div class="wrap">';

        if ($required_plan === 'enterprise') {
            echo '<h1>' . esc_html__('この機能は Enterprise プラン専用です', 'smart-booking-pro2') . '</h1>';
        } elseif ($required_plan === 'pro') {
            echo '<h1>' . esc_html__('この機能は PRO プラン専用です', 'smart-booking-pro2') . '</h1>';
        } else {
            echo '<h1>' . esc_html__('この機能はアップグレードが必要です', 'smart-booking-pro2') . '</h1>';
        }

        echo '<p>' . esc_html__('アップグレードすることでご利用いただけます。', 'smart-booking-pro2') . '</p>';
        echo '<a href="' . esc_url(admin_url('admin.php?page=smart_booking_status')) . '" class="button button-primary">';
        echo esc_html__('ステータス画面からアップグレード', 'smart-booking-pro2');
        echo '</a>';
        echo '</div>';
    }
}

function sbp2_can_create_new_database() {
    // ✅ PRO/Enterpriseユーザーは無制限  
    // ✅ PRO/Enterprise users have unlimited access
    if (function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user())) {
        return true;
    }

    // ✅ オプションから無料版のリミット件数を取得（デフォルトは 2）  
// ✅ Get free version limit count from options (default is 2)
    $limit = get_option('sbp2_free_db_limit', 3);

    // ✅ 既定の1件目（例: reserved-daytime）
    $default_db_count = 1;

    // ✅ 保存済みのユーザー定義DB  
// ✅ Saved user-defined databases
    $saved_data_acf = get_option('smart_booking_acf_data', []);
    $saved_data_db  = get_option('smart_booking_acf_db', []);

    if (!is_array($saved_data_acf)) $saved_data_acf = [];
    if (!is_array($saved_data_db))  $saved_data_db  = [];

    $merged_data = array_merge($saved_data_acf, $saved_data_db);

    // ✅ 現在の作成数（既定1件を含めてカウント）  
// ✅ Current count including the default 1 entry
    $current_count = $default_db_count + count($merged_data);

    return $current_count < $limit;
}

function sbp2_can_create_new_form() {
    if (function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user())) {
        return true;
    }

    $limit = get_option('sbp2_free_form_limit', 1); // デフォルトは1件
    $count = wp_count_posts('event-reservation');
    $published = isset($count->publish) ? (int) $count->publish : 0;
    $draft     = isset($count->draft)   ? (int) $count->draft   : 0;

    return ($published + $draft) < $limit;
}


// Googleカレンダー表示の制限  
// Google Calendar display restrictions
add_action('acf/input/admin_footer', function () {
    if (!function_exists('sbp2_is_pro_user') || !sbp2_is_pro_user()) {
        $lock_msg = esc_js(__('🔒 PRO版で有効になります', 'smart-booking-pro2'));
        ?>
        <script>
        (function($) {
            $(function() {
                $('input[name="acf[field_calendaradd_enabled]"]').prop('disabled', true);

                const label = $('input[name="acf[field_calendaradd_enabled]"]').closest('label');
                if (label.length && !label.find('.pro-lock-msg').length) {
                    label.append('<span class="pro-lock-msg" style="color:#999; margin-left:8px;"><?php echo $lock_msg; ?></span>');
                }
            });
        })(jQuery);
        </script>
        <?php
    }
});



// ✅ 2. 値の保存を禁止（サブスク制限）  
// ✅ 2. Prohibit saving values (subscription restriction)
add_filter('acf/update_value/key=field_calendaradd_enabled', function ($value, $post_id, $field) {
    if (!function_exists('sbp2_is_pro_user') || !sbp2_is_pro_user()) {
        return get_field('calendaradd_enabled', $post_id); // 上書き防止
    }
    return $value;
}, 10, 3);

