(function($) {
  // ✅ フォールバック辞書を取得  
// ✅ Retrieve fallback dictionary
  const fallback = window['sbp2_i18n_fallback_sbp2_single_script'] || {};

  // ✅ ハイブリッド翻訳関数：__() → fallback の順に参照  
// ✅ Hybrid translation function: refer to __() then fallback
  function T__(text) {
    if (typeof wp !== 'undefined' && typeof wp.i18n?.__ === 'function') {
      const result = wp.i18n.__(text, 'smart-booking-pro2'); // ✅ 正しい呼び出し
      if (result !== text) return result;
    }
    return fallback[text]?.[1] || text;
  }


document.addEventListener("DOMContentLoaded", function () {
  if (typeof jQuery === "undefined") {
    console.error("jQuery がロードされていません");
    return;
  }

  // ✅ ローカライズされた変数を使用  
// ✅ Use localized variables
  const eventStartDate = sbp2Vars.event_start_date || "";
  const eventEndDate = sbp2Vars.event_end_date || "";
  const restDays = Array.isArray(sbp2Vars.event_rest_days) ? sbp2Vars.event_rest_days : [];
  const stopReservationDays = Array.isArray(sbp2Vars.event_stop_reservation_days) ? sbp2Vars.event_stop_reservation_days : [];
  const startTime = sbp2Vars.event_start_time || "";
  const endTime = sbp2Vars.event_end_time || "";
  const interval = parseInt(sbp2Vars.event_interval_time) || 30;

  // ✅ Contact Form 7 の予約フィールド（例: [text id_reserve_daytime]）  
// ✅ Contact Form 7 reservation fields (e.g., [text id_reserve_daytime])
  const reserveDayTimeField = jQuery("#id_reserve_daytime");
  let selectedDate = "";

  // ✅ jQuery UI Datepicker の設定  
// ✅ Settings for jQuery UI Datepicker
  jQuery("#datepicker").datepicker({
    dateFormat: "yy-mm-dd",
    minDate: (function () {
      const today = new Date();
      today.setHours(0, 0, 0, 0);
      const startDate = eventStartDate ? new Date(eventStartDate) : today;
      return startDate > today ? startDate : today;
    })(),
    maxDate: eventEndDate ? new Date(eventEndDate) : null,
    firstDay: 0, // Sunday start
    beforeShowDay: function (date) {
      const day = date.getDay();
      const formattedDate = jQuery.datepicker.formatDate("yy-mm-dd", date);
      const dayNames = ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"];

      if (restDays.includes(dayNames[day])) {
        return [false, "", T__("定休日")];
      }

      if (stopReservationDays.includes(formattedDate)) {
        return [false, "reserved-blocked", T__("予約停止日")];
      }

      return [true, ""];
    },
    onSelect: function (dateText) {
      selectedDate = dateText;
      window.selectedDate = dateText;
      updateReserveDateTime(); // 後で関数化
      loadAvailableTimes(dateText); // 後で関数化
    }
  });

  async function loadAvailableTimes(selectedDate) {
    const reservationTimeSelect = document.getElementById("reservation_time");
    if (!reservationTimeSelect) return;

    reservationTimeSelect.innerHTML = `<option value="">${T__("選択してください")}</option>`;

    if (!sbp2Vars.event_start_time || !sbp2Vars.event_end_time) {
      console.error(T__("開始時間または終了時間が設定されていません。"));
      return;
    }

    const now = new Date();
    const selectedDateObj = new Date(selectedDate);
    const cutoffTime = parseInt(sbp2Vars.event_cutoff_time) || 0;
    const cutoffLimit = new Date(now.getTime() + cutoffTime * 60000);

    const maxDayReserved = parseInt(sbp2Vars.event_max_day_reserved, 10) || 0;
    const maxTimeReserved = parseInt(sbp2Vars.event_max_time_reserved, 10) || 0;
    const interval = parseInt(sbp2Vars.event_interval_time, 10) || 30;
    const startTime = sbp2Vars.event_start_time;
    const endTime = sbp2Vars.event_end_time;

    try {
      const reservationData = await fetchReservations(selectedDate);
      console.log("取得した予約データ:", reservationData);

      const approvedReservations = reservationData.filter(res => res.auto_accept === "1");
      const dailyCount = approvedReservations.length;

      if (dailyCount >= maxDayReserved) {
        reservationTimeSelect.innerHTML = `<option value="">${T__("予約受付を終了")}</option>`;
        return;
      }

      let start = new Date(`1970-01-01T${startTime}`);
      const end = new Date(`1970-01-01T${endTime}`);

      while (start < end) {
        let timeStr = start.toTimeString().substring(0, 5).padStart(5, "0");

        const option = document.createElement("option");
        option.value = timeStr;
        option.textContent = timeStr;

        const optionDateTime = new Date(selectedDateObj);
        optionDateTime.setHours(start.getHours(), start.getMinutes(), 0, 0);

        if (optionDateTime < cutoffLimit) {
          option.disabled = true;
          option.style.textDecoration = "line-through";
          option.style.color = "red";
        }

        const timeCount = approvedReservations.filter(res => res.reserved_time === timeStr).length;

        if (timeCount >= maxTimeReserved) {
          option.disabled = true;
          option.style.textDecoration = "line-through";
          option.style.color = "red";
        }

        reservationTimeSelect.appendChild(option);
        start.setMinutes(start.getMinutes() + interval);
      }
    } catch (error) {
      console.error(T__("予約データ取得エラー:"), error);
    }
  }

    // ✅ 時間選択時に予約日時フィールドへ値をセット
  jQuery("#reservation_time").on("change", function () {
    updateReserveDateTime();
  });

  // ✅ 予約日時フィールドを更新する関数
  function updateReserveDateTime() {
    const selectedTime = jQuery("#reservation_time").val();
    if (window.selectedDate && selectedTime) {
      const formattedDateTime = window.selectedDate + " " + selectedTime;
      reserveDayTimeField.val(formattedDateTime); // 予約日時フィールドにセット
    }
  }


});

// 郵便番号の自動検索  
// Automatic postal code lookup
jQuery(document).ready(function ($) {
    function searchAddress() {
        const zipCode = $("#reservation_zip").val().replace(/-/g, "");

        if (!zipCode || zipCode.length !== 7) {
            console.warn("⚠️ " + T__("正しい7桁の郵便番号を入力してください"));
            return;
        }

        console.log("🔍 " + T__("郵便番号で住所検索を開始:"), zipCode);

        $.ajax({
            url: "https://zipcloud.ibsnet.co.jp/api/search",
            dataType: "jsonp",
            data: { zipcode: zipCode },
            success: function (res) {
                if (res.status === 200 && res.results) {
                    const result = res.results[0];
                    const address = result.address1 + result.address2 + result.address3;

                    console.log("📬 " + T__("取得した住所:"), address);
                    $("#reservation_address").val(address);
                } else {
                    alert(T__("住所が見つかりませんでした"));
                }
            },
            error: function () {
                alert(T__("郵便番号検索に失敗しました"));
            },
        });
    }

    $("#reservation_zip").on("blur", function () {
        searchAddress();
    });
});


function fetchReservations(selectedDate) {
  return new Promise((resolve, reject) => {
    jQuery.ajax({
      url: "/wp-admin/admin-ajax.php",
      type: "POST",
      dataType: "json",
      data: {
        action: "fetch_reservation_data",
        event_id: sbp2Vars.event_management_no || "", // 🔁 ローカライズ変数を使用
        selected_date: selectedDate,
      },
      success: function (response) {
        if (response.success) {
          resolve(response.data);
        } else {
          console.error("❌ " + T__("予約データの取得に失敗しました。"), response.data);
          resolve([]); // 空配列を返すことで後続処理を継続
        }
      },
      error: function (xhr, status, error) {
        console.error("🚨 " + T__("AJAX通信中にエラーが発生しました。"), status, error, xhr.responseText);
        reject(error);
      },
    });
  });
}


jQuery(function($) {
  $("#datepicker").datepicker({
    beforeShow: function(input, inst) {
      setTimeout(assignDatepickerIDs, 0);
    },
    onChangeMonthYear: function(y, m, inst) {
      setTimeout(assignDatepickerIDs, 0);
    },
    onSelect: function(dateText, inst) {
      setTimeout(assignDatepickerIDs, 0);
    }
  });

  setTimeout(assignDatepickerIDs, 100);

  function assignDatepickerIDs() {
    const dp = $("#datepicker .ui-datepicker");

    if (dp.length) {
      dp.attr("id", "datepicker_wrapper");
      dp.find(".ui-datepicker-header").attr("id", "datepicker_header");
      dp.find(".ui-datepicker-title").attr("id", "datepicker_title");

      const $table = dp.find("table.ui-datepicker-calendar");
      $table.attr("id", "datepicker_table");
      $table.find("thead").attr("id", "datepicker_thead");
      $table.find("tbody").attr("id", "datepicker_tbody");
      $table.find("thead tr").attr("id", "weekday_row");

      $table.find("thead th").each(function () {
        const title = $(this).find("span").attr("title") || '';
        const code = title.toLowerCase().slice(0, 2);
        if (code) {
          $(this).attr("id", "weekday_" + code);
        }
      });

      $table.find("tbody tr").each(function(rowIndex) {
        const rowId = "date_row_" + (rowIndex + 1);
        $(this).attr("id", rowId);
        $(this).find("td").each(function(colIndex) {
          $(this).attr("id", rowId + "_col_" + (colIndex + 1));
        });
      });

      dp.find("a.ui-state-highlight").attr("id", "datepicker_today");
      dp.find("a.ui-state-active").attr("id", "datepicker_active");

      $table.find("tbody td a.ui-state-default").each(function () {
        const date = $(this).data("date");
        const year = dp.data("year") || new Date().getFullYear();
        const month = (dp.data("month") || new Date().getMonth()) + 1;
        const day = ("0" + date).slice(-2);
        const dateID = `${year}-${("0" + month).slice(-2)}-${day}`;
        $(this).attr("id", "datepicker_day_" + dateID);
      });

      console.log("✅ " + T__("カレンダーにIDを付与しました"));
    } else {
      console.warn("❗" + T__("カレンダーDOMが見つかりませんでした"));
    }
  }
});


document.addEventListener('DOMContentLoaded', function () {
  const form = document.querySelector('.wpcf7 form');
  if (!form) return;

  const submitButton = form.querySelector('input[type="submit"]');

  submitButton.addEventListener('click', function (e) {
    const reserveDaytime = form.querySelector('#id_reserve_daytime')?.value.trim();
    const userName = form.querySelector('input[name="reservation_name"]')?.value.trim();
    const email = form.querySelector('input[name="reservation_email"]')?.value.trim();
    const phone = form.querySelector('input[name="reservation_phone"]')?.value.trim();
    const zip = form.querySelector('input[name="reservation_zip"]')?.value.trim();
    const address = form.querySelector('input[name="reservation_address"]')?.value.trim();

    if (reserveDaytime === "") {
      alert(T__('予約日時は必須です。'));
      e.preventDefault();
      return false;
    }

    if (userName === "") {
      alert(T__('氏名は必須です。'));
      e.preventDefault();
      return false;
    }

    if (email === "") {
      alert(T__('メールアドレスは必須です。'));
      e.preventDefault();
      return false;
    }
/*
    if (phone === "") {
      alert(T__('電話番号は必須です。'));
      e.preventDefault();
      return false;
    }

    if (zip === "") {
      alert(T__('郵便番号は必須です。'));
      e.preventDefault();
      return false;
    }

    if (address === "") {
      alert(T__('住所は必須です。'));
      e.preventDefault();
      return false;
    }
*/
  }, true);
});

document.addEventListener("DOMContentLoaded", function () {
    document.addEventListener("wpcf7mailsent", function (event) {
        console.log( T__("フォーム送信成功 - 予約データ保存処理開始") );

        var postId = jQuery("#post-id").val() || null;
        if (!postId) {
            console.error( T__("投稿IDが取得できません。ACFデータは送信されません。") );
        } else {
            console.log( T__("対象の投稿ID:"), postId );
        }

        // 🔹 ユーザー情報取得（省略なし）
        var refEventReservation = jQuery("#ref_eventreservation").val() || "";
        var reserveDayTime = jQuery("#id_reserve_daytime").val() || "";
        var userName = jQuery("[name='reservation_name']").val() || "";
        var userEmail = jQuery("[name='reservation_email']").val() || "";
        var userPhone = jQuery("[name='reservation_phone']").val() || "";
        var userZip = jQuery("#reservation_zip").val() || "";
        var userAddress = jQuery("#reservation_address").val() || "";
        var userBuilding = jQuery("[name='reservation_building']").val() || "";
        var userMessage = jQuery("[name='reservation_message']").val() || "";

        var userAge = jQuery("[name='reserved_age']").val() || "0";
        var userGender = jQuery("[name='reserved_gender']").val() || T__("未回答");
        var userMaritalStatus = jQuery("[name='reserved_marital_status']").val() || T__("未回答");
        var userIncome = jQuery("[name='reserved_income']").val() || "0";
        var userResidence = jQuery("[name='reserved_residence']").val() || T__("未選択");
        var userRent = jQuery("[name='reserved_rent']").val() || "0";
        var userPeople = jQuery("[name='reserved_people']").val() || "1";
        var userCourse = jQuery("[name='reserved_course']").val() || T__("未選択");
        var userCarCount = jQuery("[name='reserved_car_count']").val() || "0";
        var userHobby = jQuery("[name='reserved_hobby']").val() || "";
        var reserveDayTime = jQuery("#id_reserve_daytime").val() || "";

        var pageTitle = document.title || (jQuery("h1").length ? jQuery("h1").text().trim() : T__("ページタイトル不明"));
        var autoAccept          = sbp2Vars.event_auto_accept || "0";
        var confirmationEmail   = sbp2Vars.event_confirmation_email_enabled || "0";
        var confirmationTemplate= sbp2Vars.event_confirmation_template || "confirmation-reserve-default.txt";
        var calendarAdd         = sbp2Vars.event_calendaradd_enabled || "0";
        var reminderEnabled     = sbp2Vars.event_reminder_enabled || "0";
        var reminderTime        = sbp2Vars.event_reminder_time || "60";
        var reminderTemplate    = sbp2Vars.event_reminder_template || "remainder-reservation-default.txt";
        var eventManagementNo   = sbp2Vars.event_management_no || "";
        var intervalTime        = sbp2Vars.event_interval_time || "30";
        var nonce               = sbp2Vars.ers_nonce || "";
        var dataBasename        = sbp2Vars.database_db || "";

        if (!dataBasename) {
            console.warn( T__("カスタム投稿タイプが空のため、ACFデータ送信をスキップ") );
            return;
        }

        // 🔹 予約データ送信
        jQuery.ajax({
            url: "/wp-admin/admin-ajax.php",
            type: "POST",
            dataType: "json",
            data: {
                action: "save_reservation_data",
                _ajax_nonce: nonce,
                reservation_post_id: postId,
                reserve_daytime: reserveDayTime,
                reservation_name: userName,
                reservation_email: userEmail,
                reservation_phone: userPhone,
                reservation_zip: userZip,
                reservation_address: userAddress,
                reservation_building: userBuilding,
                reservation_message: userMessage,
                reservation_management: eventManagementNo,
                reservation_page_title: pageTitle,
                reservation_auto_accept: autoAccept,
                reservation_reminder_enabled: reminderEnabled,
                reservation_reminder_time: reminderTime,
                reservation_reminder_template: reminderTemplate,
                reservation_confirmation_email: confirmationEmail,
                reservation_confirmation_template: confirmationTemplate,
                reserved_age: userAge,
                reserved_gender: userGender,
                reserved_marital_status: userMaritalStatus,
                reserved_income: userIncome,
                reserved_residence: userResidence,
                reserved_rent: userRent,
                reserved_people: userPeople,
                reserved_course: userCourse,
                reserved_car_count: userCarCount,
                reserved_hobby: userHobby,
                event_interval_time: intervalTime,
                calendar_add_enabled: calendarAdd,
                reserved_ref_eventreservation: refEventReservation
            },
            success: function (response) {
                if (response.success && response.data?.skipped) {
                    console.log("✅ スキップ対象のため、Thanksページには遷移しません");
                    return;
                }

                // 通常時の遷移
                redirectToThanksPage(reserveDayTime);
            },
            error: function (xhr, status, error) {
                console.error( T__("AJAXエラー:"), status, error, xhr.responseText );
            }
        });

        console.log( T__("ACFデータ取得処理開始") );

        var formValues = {};
        jQuery("input, select, textarea").each(function () {
            var name = jQuery(this).attr("name");
            if (name) {
                formValues[name] = jQuery(this).val() || "";
            }
        });

        var emailCandidates = [];
        jQuery('input[type="email"]').each(function () {
            var name = jQuery(this).attr("name");
            var value = jQuery(this).val();
            if (name && value && value.includes('@')) {
                emailCandidates.push({ name: name, value: value });
            }
        });

        jQuery.ajax({
            url: "/wp-admin/admin-ajax.php",
            type: "POST",
            dataType: "json",
            data: {
                action: "get_acf_fields",
                post_type: dataBasename
            },
            success: function (response) {
                if (response.success) {
                    var acfFields = response.data;
                    var acfData = {};
                    acfFields.forEach(function (fieldName) {
                        if (formValues[fieldName] !== undefined) {
                            acfData[fieldName] = formValues[fieldName];
                        }
                    });

                    jQuery.ajax({
                        url: "/wp-admin/admin-ajax.php",
                        type: "POST",
                        dataType: "json",
                        data: {
                            action: "save_acf_data",
                            _ajax_nonce: nonce,
                            database_db: dataBasename,
                            acf_fields: acfData,
                            reservation_confirmation_email: confirmationEmail,
                            reservation_confirmation_template: confirmationTemplate,
                            email_candidates: emailCandidates
                        },
                        success: function (response) {
                            if (response.success && response.data?.skipped) {
                                console.log("✅ ACFデータ保存スキップ: ", response.data?.message || '');
                                return; // ← 遷移せず終了
                            }

                            if (response.success) {
                                console.log( T__("ACF データ保存成功:"), response );
                                redirectToThanksPage(reserveDayTime);
                            } else {
                                console.error( T__("ACF データ保存エラー:"), response.data );
                                alert(T__('Database Save Faild:Please Call Customer center.'));
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error( T__("ACF データ AJAXエラー:"), status, error, xhr.responseText );
                        }
                    });
                } else {
                    console.error( T__("ACF フィールド取得エラー:"), response.data );
                }
            },
            error: function (xhr, status, error) {
                console.error( T__("ACF フィールド取得 AJAXエラー:"), status, error, xhr.responseText );
            }
        });
    });
});



function redirectToThanksPage(reserveDayTime) {
  if (typeof sbp2Vars === 'undefined') {
    alert("⚠️ グローバル変数が見つかりません");
    return;
  }

  const thanksPageSlug = sbp2Vars.thanks_page_slug || "";
  if (!thanksPageSlug) {
    alert("⚠️ Thanksページのスラッグが未設定");
    return;
  }

  const customHeader = sbp2Vars.custom_header || "";
  const customFooter = sbp2Vars.custom_footer || "";

  const thanksPageUrl = "/" + thanksPageSlug + "/";
  const calendarAddEnabled = sbp2Vars.event_calendaradd_enabled === "1" || sbp2Vars.event_calendaradd_enabled === 1;
  const pageTitle = document.title || T__("予約イベント");
  const interval = parseInt(sbp2Vars.event_interval_time, 10) || 30;

  const trimmedDateTime = reserveDayTime.trim();

  let params = `?header=${encodeURIComponent(customHeader)}&footer=${encodeURIComponent(customFooter)}`;

  if (trimmedDateTime.includes(" ")) {
    const [reservedDay, reservedTime] = trimmedDateTime.split(" ");
    const [hourStr, minuteStr] = reservedTime.split(":");

    let hour = parseInt(hourStr, 10);
    let minute = parseInt(minuteStr, 10);

    minute += interval;
    if (minute >= 60) {
      hour += Math.floor(minute / 60);
      minute %= 60;
    }

    const reservedEndTime = `${String(hour).padStart(2, "0")}:${String(minute).padStart(2, "0")}`;

    if (calendarAddEnabled) {
      params = `?calendar=1`
        + `&title=${encodeURIComponent(pageTitle)}`
        + `&start=${reservedDay}T${reservedTime}`
        + `&end=${reservedDay}T${reservedEndTime}`
        + `&header=${encodeURIComponent(customHeader)}`
        + `&footer=${encodeURIComponent(customFooter)}`;
    }
  }

  window.location.href = thanksPageUrl + params;
}


})(jQuery);