<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// ACF のカスタムフィールド登録  
// Register ACF custom fields
function ers_register_acf_fields() {
    if (function_exists('acf_add_local_field_group')) {
        // イベント予約 (event-reservation)  
        // Event reservation (event-reservation)
        acf_add_local_field_group(array(
            'key' => 'group_event_reservation',
            'title' => esc_html__('イベント予約設定','smart-booking-pro2'),
            'fields' => array(
        
                // -----------------------------
                // タブ1: 予約設定
                array(
                    'key' => 'tab_reservation_settings',
                    'label' => esc_html__('予約設定','smart-booking-pro2'),
                    'type' => 'tab',
                    'placement' => 'top',
                ),
                array(
                    'key' => 'field_event_days_start',
                    'label' => esc_html__('開始日','smart-booking-pro2'),
                    'name' => 'event-days-start',
                    'type' => 'date_picker',
                    'display_format' => 'Y-m-d',
                    'return_format' => 'Y-m-d',
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_event_days_end',
                    'label' => esc_html__('終了日','smart-booking-pro2'),
                    'name' => 'event-days-end',
                    'type' => 'date_picker',
                    'display_format' => 'Y-m-d',
                    'return_format' => 'Y-m-d',
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_start_time',
                    'label' => esc_html__('開始時間','smart-booking-pro2'),
                    'name' => 'start-time',
                    'type' => 'time_picker',
                    'display_format' => 'H:i',
                    'return_format' => 'H:i',
                    'wrapper' => array('width' => '33%'),
                ),
                array(
                    'key' => 'field_end_time',
                    'label' => esc_html__('終了時間','smart-booking-pro2'),
                    'name' => 'end-time',
                    'type' => 'time_picker',
                    'display_format' => 'H:i',
                    'return_format' => 'H:i',
                    'wrapper' => array('width' => '33%'),
                ),
                array(
                    'key' => 'field_interval_time',
                    'label' => esc_html__('時間間隔（分）','smart-booking-pro2'),
                    'name' => 'interval-time',
                    'type' => 'number',
                    'min' => 15,
                    'step' => 15,
                    'wrapper' => array('width' => '33%'),
                ),
                array(
                    'key' => 'field_rest_days',
                    'label' => esc_html__('定休日','smart-booking-pro2'),
                    'name' => 'rest-days',
                    'type' => 'checkbox',
                    'choices' => array(
                        'sunday' => esc_html__('日曜日','smart-booking-pro2'),
                        'monday' => esc_html__('月曜日','smart-booking-pro2'),
                        'tuesday' => esc_html__('火曜日','smart-booking-pro2'),
                        'wednesday' => esc_html__('水曜日','smart-booking-pro2'),
                        'thursday' => esc_html__('木曜日','smart-booking-pro2'),
                        'friday' => esc_html__('金曜日','smart-booking-pro2'),
                        'saturday' => esc_html__('土曜日','smart-booking-pro2'),
                    ),
                ),
                array(
                    'key' => 'field_stop_reservation_days',
                    'label' => esc_html__('予約停止日','smart-booking-pro2'),
                    'name' => 'stop-reservation-days',
                    'type' => 'text',
                    'instructions' => esc_html__('予約を停止する日付をカンマ区切りで入力してください。<br>（例: 2025-03-01,2025-03-10,2025-03-15）','smart-booking-pro2'),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_cutoff_times',
                    'label' => esc_html__('予約締切時間（分）','smart-booking-pro2'),
                    'name' => 'cutoff-times',
                    'type' => 'number',
                    'instructions' => esc_html__('受付時間から逆算して時間リストを締切ます。<br>例:60 → 60分 1440 → 1日（24時間）','smart-booking-pro2'),
                    'min' => 0,
                    'step' => 10,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_max_day_reserved',
                    'label' => esc_html__('一日の最大予約数', 'smart-booking-pro2'),
                    'name' => 'max-day-reserved',
                    'type' => 'number',
                    'min' => 1,
                    'wrapper' => array('width' => '33%'),
                ),
                array(
                    'key' => 'field_max_time_reserved',
                    'label' => esc_html__('時間帯の最大予約数', 'smart-booking-pro2'),
                    'name' => 'max-time-reserved',
                    'type' => 'number',
                    'min' => 1,
                    'wrapper' => array('width' => '33%'),
                ),
        
                // -----------------------------
                // タブ2: 詳細設定
                array(
                    'key' => 'tab_detail_settings',
                    'label' => esc_html__('詳細設定', 'smart-booking-pro2'),
                    'type' => 'tab',
                    'placement' => 'top',
                ),
                array(
                    'key' => 'field_calendar_display',
                    'label' => esc_html__('カレンダー＆時間を表示', 'smart-booking-pro2'),
                    'name' => 'calendar-display',
                    'type' => 'true_false',
                    'instructions' => esc_html__('カレンダーと時間選択を表示する場合はチェックを入れる', 'smart-booking-pro2'),
                    'message' => esc_html__('予約カレンダーと時間リストを表示', 'smart-booking-pro2'),
                    'default_value' => 1,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_designation_slug',
                    'label' => esc_html__('指定スラッグ', 'smart-booking-pro2'),
                    'name' => 'designation-slug',
                    'type' => 'text',
                    'instructions' => esc_html__('（任意入力）URLの末尾を指定可', 'smart-booking-pro2'),
                    'wrapper' => array('width' => '33%'),
                ),
                array(
                    'key' => 'field_auto_accept',
                    'label' => esc_html__('自動承認', 'smart-booking-pro2'),
                    'name' => 'auto-accept',
                    'type' => 'true_false',
                    'instructions' => esc_html__('（＊予約機能）', 'smart-booking-pro2'),
                    'message' => esc_html__('予約を自動承認する', 'smart-booking-pro2'),
                    'default_value' => 0,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_send_confirmation_email',
                    'label' => esc_html__('確認メールの送信', 'smart-booking-pro2'),
                    'name' => 'send-confirmation-email',
                    'type' => 'true_false',
                    'instructions' => esc_html__('（＊フォームのメールアドレス全てに1度配信）', 'smart-booking-pro2'),
                    'message' => esc_html__('このイベントの予約時に確認メールを送信する', 'smart-booking-pro2'),
                    'default_value' => 0,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_reminder_enabled',
                    'label' => esc_html__('リマインダーを送信する', 'smart-booking-pro2'),
                    'name' => 'reminder_enabled',
                    'type' => 'true_false',
                    'instructions' => esc_html__('（＊予約機能）', 'smart-booking-pro2'),
                    'message' => esc_html__('このイベントのリマインダーを有効にする', 'smart-booking-pro2'),
                    'default_value' => 0,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_reminder_time',
                    'label' => esc_html__('リマインダー送信時間（予約時間の何分前）', 'smart-booking-pro2'),
                    'name' => 'reminder_time',
                    'type' => 'number',
                    'instructions' => esc_html__('予約時間の何分前にリマインダーを送信するかを指定してください。<br>（＊予約機能）', 'smart-booking-pro2'),
                    'min' => 1,
                    'step' => 1,
                    'default_value' => 60,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_calendaradd_enabled',
                    'label' => esc_html__('カレンダー追加ボタンを表示する', 'smart-booking-pro2'),
                    'name' => 'calendaradd_enabled',
                    'type' => 'true_false',
                    'instructions' => esc_html__('（＊予約機能）', 'smart-booking-pro2'),
                    'message' => esc_html__('Googleカレンダーなどへの追加ボタンを有効にする', 'smart-booking-pro2'),
                    'default_value' => 0,
                    'wrapper' => array('width' => '50%'),
                ),
                // -----------------------------
                // タブ3: フォーマット設定
                array(
                    'key' => 'tab_format_settings',
                    'label' => esc_html__('フォーマット設定', 'smart-booking-pro2'),
                    'type' => 'tab',
                    'placement' => 'top',
                ),
                array(
                    'key' => 'field_reserved_confirmation_template',
                    'label' => esc_html__('確認メールのテンプレート', 'smart-booking-pro2'),
                    'name' => 'confirmation_template',
                    'type' => 'select',
                    'choices' => ers_get_confirmation_templates(),
                    'allow_null' => 1,
                    'instructions' => esc_html__('確認メールで使用するテンプレートを選択してください。<br>（＊予約機能）', 'smart-booking-pro2'),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_reminder_template',
                    'label' => esc_html__('リマインダーのメールテンプレート', 'smart-booking-pro2'),
                    'name' => 'reminder_template',
                    'type' => 'select',
                    'choices' => ers_get_reminder_templates(),
                    'allow_null' => 1,
                    'instructions' => esc_html__('リマインダーで送信するメールテンプレートを選択してください。<br>（＊予約機能）', 'smart-booking-pro2'),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_designation_contactform7',
                    'label' => esc_html__('指定フォーム（Contact Form 7）', 'smart-booking-pro2'),
                    'name' => 'designation-contactform7',
                    'type' => 'post_object',
                    'post_type' => array('wpcf7_contact_form'),
                    'return_format' => 'id',
                    'instructions' => esc_html__('使用する Contact Form 7 のフォームを選択 <br>（＊保存先データベースと要連動・予約機能は初期フォーム利用必須）', 'smart-booking-pro2'),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_datasase_db',
                    'label' => esc_html__('保存先データベース', 'smart-booking-pro2'),
                    'name' => 'datasase-db',
                    'type' => 'select',
                    'instructions' => esc_html__('受信データを保存するデータベースを選択してください。<br>（＊指定フォームと要連動・予約機能はreserved_daytime利用必須）', 'smart-booking-pro2'),
                    'choices' => get_custom_post_types_for_select(),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_select_single_template',
                    'label' => esc_html__('ページテンプレートを選択', 'smart-booking-pro2'),
                    'name' => 'select-single-template',
                    'type' => 'select',
                    'instructions' => esc_html__('使用する single-xx.php のファイルを選択', 'smart-booking-pro2'),
                    'choices' => ers_get_template_files(),
                    'allow_null' => 1,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_form_template',
                    'label' => esc_html__('フォームテンプレートを選択', 'smart-booking-pro2'),
                    'name' => 'form-template-file',
                    'type' => 'select',
                    'instructions' => esc_html__('使用するフォームテンプレート（form-template*.txt）を選択してください。', 'smart-booking-pro2'),
                    'choices' => ers_get_form_templates(),
                    'allow_null' => 1,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_formdesign_css',
                    'label' => esc_html__('フォームデザインを選択', 'smart-booking-pro2'),
                    'name' => 'formdesign-css-file',
                    'type' => 'select',
                    'instructions' => esc_html__('使用するフォームデザインCSS（style-formdesign-xxx.css）を選択してください。', 'smart-booking-pro2'),
                    'choices' => ers_get_formdesign_styles(),
                    'allow_null' => 1,
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_designation_header_name',
                    'label' => esc_html__('ヘッダー指定', 'smart-booking-pro2'),
                    'name' => 'designation-header-name',
                    'type' => 'text',
                    'instructions' => esc_html__('カスタムヘッダーを指定（例: event → header-event.php）', 'smart-booking-pro2'),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_designation_footer_name',
                    'label' => esc_html__('フッター指定', 'smart-booking-pro2'),
                    'name' => 'designation-footer-name',
                    'type' => 'text',
                    'instructions' => esc_html__('カスタムフッターを指定（例: event → footer-event.php）', 'smart-booking-pro2'),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_designation_thanks_page',
                    'label' => esc_html__('サンクスページスラッグ', 'smart-booking-pro2'),
                    'name' => 'designation-thanks-page',
                    'type' => 'text',
                    'instructions' => esc_html__('例: thanks-event → /thanks-event/ にリダイレクト', 'smart-booking-pro2'),
                    'wrapper' => array('width' => '50%'),
                ),
                array(
                    'key' => 'field_management_no',
                    'label' => esc_html__('管理番号', 'smart-booking-pro2'),
                    'name' => 'management-no',
                    'type' => 'number',
                    'instructions' => esc_html__('Auto ＊編集不可', 'smart-booking-pro2'),
                    'default_value' => 10001,
                    'readonly' => 1,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'event-reservation',
                    ),
                ),
            ),
        ));
        

      // 予約データ (reserved-daytime)  
    // Reservation data (reserved-daytime)
    acf_add_local_field_group(array(
        'key' => 'group_reserved_daytime',
        'title' => esc_html__('予約データ','smart-booking-pro2'),
        'fields' => array(
            array(
                'key' => 'field_reserved_event_id',
                'label' => esc_html__('イベントID', 'smart-booking-pro2'),
                'name' => 'event-id',
                'type' => 'number',
            ),
            array(
                'key' => 'field_reserved_event_name',
                'label' => esc_html__('イベント名', 'smart-booking-pro2'),
                'name' => 'event-name',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_ref_eventreservation',
                'label' => esc_html__('リファラー情報', 'smart-booking-pro2'),
                'name' => 'reserved_ref_eventreservation',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_user_name',
                'label' => esc_html__('氏名', 'smart-booking-pro2'),
                'name' => 'reserved-user-name',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_user_email',
                'label' => esc_html__('メールアドレス', 'smart-booking-pro2'),
                'name' => 'reserved-user-email',
                'type' => 'email',
            ),
            array(
                'key' => 'field_reserved_day',
                'label' => esc_html__('予約日', 'smart-booking-pro2'),
                'name' => 'reserved-day',
                'type' => 'date_picker',
                'display_format' => 'Y-m-d',
                'return_format' => 'Y-m-d',
            ),
            array(
                'key' => 'field_reserved_time',
                'label' => esc_html__('予約時間', 'smart-booking-pro2'),
                'name' => 'reserved-time',
                'type' => 'time_picker',
                'display_format' => 'H:i',
                'return_format' => 'H:i',
            ),
            array(
                'key' => 'field_reserved_phone',
                'label' => esc_html__('電話番号', 'smart-booking-pro2'),
                'name' => 'reserved-phone',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_zip',
                'label' => esc_html__('郵便番号', 'smart-booking-pro2'),
                'name' => 'reserved-zip',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_address',
                'label' => esc_html__('住所', 'smart-booking-pro2'),
                'name' => 'reserved-address',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_building',
                'label' => esc_html__('建物名・号室', 'smart-booking-pro2'),
                'name' => 'reserved-building',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_message',
                'label' => esc_html__('お問い合わせ内容', 'smart-booking-pro2'),
                'name' => 'reserved-message',
                'type' => 'textarea',
            ),
            array(
                'key' => 'field_reserved_auto_accept',
                'label' => esc_html__('自動承認', 'smart-booking-pro2'),
                'name' => 'reserved-auto-accept',
                'type' => 'true_false',
                'message' => esc_html__('この予約は自動承認されました', 'smart-booking-pro2'),
                'default_value' => 0,
            ),
            array(
                'key' => 'field_reserved_confirmation_email_enabled',
                'label' => esc_html__('確認メールを送る', 'smart-booking-pro2'),
                'name' => 'confirmation-email-enabled',
                'type' => 'true_false',
                'message' => esc_html__('この予約に対して確認メールを送信する', 'smart-booking-pro2'),
                'default_value' => 1,
            ),
            array(
                'key' => 'field_reserved_confirmation_template',
                'label' => esc_html__('確認メールのテンプレート', 'smart-booking-pro2'),
                'name' => 'confirmation_template',
                'type' => 'select',
                'choices' => ers_get_confirmation_templates(),
                'allow_null' => 1,
                'instructions' => esc_html__('予約確認メールで使用するテンプレートを選択してください。', 'smart-booking-pro2'),
            ),
            //リマインダー送信の有無
            array(
                'key' => 'field_reserved_reminder_enabled',
                'label' => esc_html__('リマインダーを送信する', 'smart-booking-pro2'),
                'name' => 'reminder_enabled',
                'type' => 'true_false',
                'message' => esc_html__('この予約のリマインダーを有効にする', 'smart-booking-pro2'),
                'default_value' => 0,
            ),
            //リマインダー送信時間
            array(
                'key' => 'field_reserved_reminder_time',
                'label' => esc_html__('リマインダー送信時間（予約時間の何分前）', 'smart-booking-pro2'),
                'name' => 'reminder_time',
                'type' => 'number',
                'instructions' => esc_html__('予約時間の何分前にリマインダーを送信するかを指定してください。', 'smart-booking-pro2'),
                'min' => 1,
                'step' => 1,
                'default_value' => 60,
            ),
            //リマインダーのメールテンプレート選択
            array(
                'key' => 'field_reserved_reminder_template',
                'label' => esc_html__('リマインダーのメールテンプレート', 'smart-booking-pro2'),
                'name' => 'reminder_template',
                'type' => 'select',
                'choices' => ers_get_reminder_templates(),
                'allow_null' => 1,
                'instructions' => esc_html__('リマインダーで送信するメールテンプレートを選択してください。', 'smart-booking-pro2'),
            ),
            array(
                'key' => 'field_reserved_age',
                'label' => esc_html__('年齢', 'smart-booking-pro2'),
                'name' => 'reserved-age',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_gender',
                'label' => esc_html__('性別', 'smart-booking-pro2'),
                'name' => 'reserved-gender',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_marital_status',
                'label' => esc_html__('婚姻', 'smart-booking-pro2'),
                'name' => 'reserved-marital-status',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_income',
                'label' => esc_html__('年収', 'smart-booking-pro2'),
                'name' => 'reserved-income',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_residence',
                'label' => esc_html__('住まい', 'smart-booking-pro2'),
                'name' => 'reserved-residence',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_rent',
                'label' => esc_html__('賃料', 'smart-booking-pro2'),
                'name' => 'reserved-rent',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_people',
                'label' => esc_html__('人数', 'smart-booking-pro2'),
                'name' => 'reserved-people',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_course',
                'label' => esc_html__('コース', 'smart-booking-pro2'),
                'name' => 'reserved-course',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_car_count',
                'label' => esc_html__('車台数', 'smart-booking-pro2'),
                'name' => 'reserved-car-count',
                'type' => 'text',
            ),
            array(
                'key' => 'field_reserved_hobby',
                'label' => esc_html__('趣味', 'smart-booking-pro2'),
                'name' => 'reserved-hobby',
                'type' => 'text',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'reserved-daytime',
                ),
            ),
        ),
    ));
    }
}
add_action('acf/init', 'ers_register_acf_fields');

// 予約停止日（stop-reservation-days）のバリデーション  
// Validation of stop reservation days (stop-reservation-days)
add_filter('acf/validate_value/name=stop-reservation-days', function ($valid, $value, $field, $input) {
    if ($valid !== true) {
        return $valid;
    }

    // 空欄または null の場合はOK  
    // OK if blank or null
    if (empty($value)) {
        return true;
    }

    // null 対策：文字列以外は空文字に変換  
    // Null handling: convert non-string to empty string
    $value = is_string($value) ? $value : '';
    $dates = explode(',', $value);

    foreach ($dates as $date) {
        $date = trim($date);

        // 日付フォーマット（YYYY-MM-DD）が正しいかチェック  
        // Check if date format (YYYY-MM-DD) is correct
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $date)) {
            return esc_html__('日付の形式が正しくありません（YYYY-MM-DD で入力してください）。', 'smart-booking-pro2');
        }

        // 実際に有効な日付かチェック  
        // Check if the date is actually valid
        [$year, $month, $day] = explode('-', $date);
        if (!checkdate((int)$month, (int)$day, (int)$year)) {
            return sprintf(
                esc_html__('無効な日付が含まれています（%s）。', 'smart-booking-pro2'),
                esc_html($date)
            );
        }
    }

    return true;
}, 10, 4);
