<?php
if (!defined('ABSPATH')) {
    exit;
}


// 管理画面のUI  
// Admin screen UI
function smart_booking_db_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Smart Booking PRO2 - Create Data Storage', 'smart-booking-pro2'); ?></h1>


        <?php
        // ✅ 成功メッセージを表示（リダイレクト後に表示）  
        // ✅ Display success message (shown after redirect)
        if (isset($_GET['created'])) {
            echo '<div class="updated"><p>' . esc_html__('✅ データベースが正常に作成されました！', 'smart-booking-pro2') . '</p></div>';
        }
        ?>

        <div id="sbp2-tab-menu" style="display: flex; gap: 10px; margin-bottom: 20px;">
            <?php
            $is_allowed = sbp2_can_create_new_database();
            ?>

            <!-- ✅ 制限チェック済みボタン -->  
            <!-- ✅ Button with restriction check -->
            <button
                type="button"
                id="sbp2-db-create-btn"
                class="sbp2-tab-btn active"
                data-tab="manual"
                style="background: <?php echo $is_allowed ? '#0073aa' : '#ccc'; ?>;
                    color: #fff;
                    border: 1px solid <?php echo $is_allowed ? '#0073aa' : '#aaa'; ?>;
                    padding: 10px 20px;
                    border-radius: 6px;
                    cursor: <?php echo $is_allowed ? 'pointer' : 'not-allowed'; ?>;"
                <?php echo $is_allowed ? '' : 'disabled'; ?>>
                <?php
                    echo $is_allowed
                        ? '🔓 ' . esc_html__('手動入力', 'smart-booking-pro2')
                        : '🔒PRO ' . esc_html__('手動入力', 'smart-booking-pro2');
                ?>
            </button>


            <!-- ✅ JSでも参照できるよう hidden input を設置 -->  
            <!-- ✅ Add hidden input for JS reference -->
            <input type="hidden" id="sbp2-db-create-allowed" value="<?php echo $is_allowed ? '1' : '0'; ?>">

            <?php
            $can_create = sbp2_can_create_new_database();
            $cf7_label = $can_create
            ? '🔓 ' . esc_html__('CF7変換', 'smart-booking-pro2')
            : '🔒PRO ' . esc_html__('CF7変換', 'smart-booking-pro2');

            $cf7_style = $can_create
                ? 'background: #0073aa; color: #fff;'
                : 'background: #ccc; color: #666;';
            ?>

            <button type="button" class="sbp2-tab-btn" data-tab="cf7"
                style="<?php echo esc_attr($cf7_style); ?> border: 1px solid #ccc; padding: 10px 20px; border-radius: 6px; cursor: pointer;">
                <?php echo esc_html($cf7_label); ?>
            </button>


            <?php if (function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user())): ?>
                <button type="button" class="sbp2-tab-btn" data-tab="csv"
                    style="background: #eee; color: #000; border: 1px solid #ccc; padding: 10px 20px; border-radius: 6px; cursor: pointer;">
                    📥 <?php echo esc_html__('CSV取り込み', 'smart-booking-pro2'); ?> <span style="font-size: 0.9em; color: green;">🔓</span>
                </button>
            <?php else: ?>
                <button type="button" class="sbp2-tab-btn-disabled"
                    style="background: #f9f9f9; color: #aaa; border: 1px solid #ddd; padding: 10px 20px; border-radius: 6px; cursor: not-allowed;"
                    title="<?php echo esc_attr__('PROプラン以上でご利用いただけます', 'smart-booking-pro2'); ?>">
                    📥 <?php echo esc_html__('CSV取り込み', 'smart-booking-pro2'); ?> <span style="font-size: 0.9em; color: red;">🔒PRO</span>
                </button>
            <?php endif; ?>


        </div>


        <?php $can_create = sbp2_can_create_new_database(); ?>

        <div class="sbp2-tab-content" data-tab="manual" style="display: block;">

        <?php if ($can_create): ?>

            <!-- ✅ 制限内：通常フォーム -->  
            <!-- ✅ Within limit: normal form -->
            <form method="post" id="acf-form" style="background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); max-width: 800px;">
                <div style="display: flex; gap: 20px; align-items: center; flex-wrap: wrap;">
                    <div style="flex: 1; min-width: 300px;">
                        <label><?php echo esc_html__('データベース内部名 (半角英数字10文字以内):', 'smart-booking-pro2'); ?></label>
                        <input type="text" name="post_type_name" maxlength="10" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                    </div>
                    <div style="flex: 1; min-width: 300px;">
                        <label><?php echo esc_html__('データベース表示名 (日本語可):', 'smart-booking-pro2'); ?></label>
                        <input type="text" name="post_type_label" maxlength="50" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                    </div>
                    <div style="flex: 1; min-width: 300px;">
                        <label><?php echo esc_html__('グループ内部名 (半角英数字10文字以内):', 'smart-booking-pro2'); ?></label>
                        <input type="text" name="acf_group_name" maxlength="10" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                    </div>
                    <div style="flex: 1; min-width: 300px;">
                        <label><?php echo esc_html__('グループ表示名 (日本語可):', 'smart-booking-pro2'); ?></label>
                        <input type="text" name="acf_group_label" maxlength="50" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                    </div>
                </div>


                <h2 style="margin-top: 20px;"><?php echo esc_html__('保存項目（半角英数字10文字以内）', 'smart-booking-pro2'); ?></h2>
                <div id="acf-fields">
                    <div class="acf-field" style="display: flex; gap: 10px; align-items: center; margin-bottom: 10px;">
                        <input type="text" name="acf_field_name[]" required
                            placeholder="<?php echo esc_attr__('フィールド名', 'smart-booking-pro2'); ?>"
                            style="flex: 2; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                        <select name="acf_field_type[]" style="flex: 1; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                            <option value="text"><?php echo esc_html__('文字（text）', 'smart-booking-pro2'); ?></option>
                            <option value="number"><?php echo esc_html__('数字（number）', 'smart-booking-pro2'); ?></option>
                            <option value="textarea"><?php echo esc_html__('文章（textarea）', 'smart-booking-pro2'); ?></option>
                            <option value="email"><?php echo esc_html__('メール（email）', 'smart-booking-pro2'); ?></option>
                            <option value="date_picker"><?php echo esc_html__('日付（date_picker, y-m-d）', 'smart-booking-pro2'); ?></option>
                            <option value="time_picker"><?php echo esc_html__('時間（time_picker, H:i）', 'smart-booking-pro2'); ?></option>
                            <option value="true_false"><?php echo esc_html__('真偽（true_false）', 'smart-booking-pro2'); ?></option>
                        </select>
                        <button type="button" class="remove-field"
                                style="background: #d9534f; color: #fff; border: none; padding: 8px 12px; border-radius: 4px; cursor: pointer;">
                            <?php echo esc_html__('削除', 'smart-booking-pro2'); ?>
                        </button>
                    </div>
                </div>

                <button type="button" id="add-field"
                        style="display: block; width: fit-content; margin: 20px 0; background: #5bc0de; color: #fff; border: none; padding: 10px 15px; border-radius: 4px; cursor: pointer;">
                    <?php echo esc_html__('＋ フィールド追加', 'smart-booking-pro2'); ?>
                </button>

                <input type="submit" name="generate_post_acf"
                    value="<?php echo esc_attr__('作成', 'smart-booking-pro2'); ?>"
                    style="background: #5cb85c; color: #fff; border: none; padding: 10px 15px; border-radius: 4px; cursor: pointer;">

            </form>

        <?php else: ?>

        <!-- 🔒 制限中の案内 -->  
        <!-- 🔒 Notification during restriction -->
        <div style="background: #fff3f3; padding: 30px; border-radius: 8px; text-align: center; border: 1px solid #f5c2c2;">
            <p style="color: #cc0000; font-size: 16px; font-weight: bold;">
                <?php echo esc_html__('🔒 PROプランで無制限利用可能です', 'smart-booking-pro2'); ?>
            </p>
            <p style="font-size: 14px;">
                <?php echo esc_html__('無料プランではデータベースの作成数が上限に達しています。', 'smart-booking-pro2'); ?>
            </p>
        </div>


        <?php endif; ?>

        </div>



        <div class="sbp2-tab-content" data-tab="cf7" style="display: none;">
            <?php if (sbp2_can_create_new_database()) : ?>
                <!-- ✅ CF7フォーム → DB変換機能 -->
                <h2 style="margin-top: 40px;"><?php echo esc_html__('CF7フォームからデータベース変換', 'smart-booking-pro2'); ?></h2>

                <form method="post" id="cf7-form-select-container" style="background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); max-width: 800px;">
                    <label><?php echo esc_html__('CF7フォームを選択:', 'smart-booking-pro2'); ?></label>

                    <div style="display: flex; gap: 10px; align-items: center;">
                        <select name="cf7_form_id" id="cf7-form-select" style="flex: 1; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                            <option value=""><?php echo esc_html__('-- フォームを選択 --', 'smart-booking-pro2'); ?></option>
                            <?php
                            $cf7_forms = get_posts([
                                'post_type' => 'wpcf7_contact_form',
                                'posts_per_page' => -1
                            ]);
                            foreach ($cf7_forms as $form) {
                                echo '<option value="' . esc_attr($form->ID) . '">' . esc_html($form->post_title) . '</option>';
                            }
                            ?>
                        </select>
                        <button type="submit" name="convert_cf7_to_db" style="background: #5bc0de; color: #fff; border: none; padding: 10px 15px; border-radius: 4px; cursor: pointer;">
                            <?php echo esc_html__('表示', 'smart-booking-pro2'); ?>
                        </button>
                    </div>

                    <div style="display: flex; gap: 20px; align-items: center;">
                        <div style="flex: 1;">
                            <label><?php echo esc_html__('データベース内部名', 'smart-booking-pro2'); ?><br><?php echo esc_html__('(半角英数字10文字以内):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="post_type_name" maxlength="10" required value="<?php echo isset($post_type_name) ? esc_attr($post_type_name) : ''; ?>" style="...">
                        </div>
                        <div style="flex: 1;">
                            <label><?php echo esc_html__('データベース表示名', 'smart-booking-pro2'); ?><br><?php echo esc_html__('(日本語可):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="post_type_label" maxlength="50" required value="<?php echo isset($post_type_label) ? esc_attr($post_type_label) : ''; ?>" style="...">
                        </div>
                        <div style="flex: 1;">
                            <label><?php echo esc_html__('グループ内部名', 'smart-booking-pro2'); ?><br><?php echo esc_html__('(半角英数字10文字以内):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="acf_group_name" maxlength="10" required value="<?php echo isset($acf_group_name) ? esc_attr($acf_group_name) : ''; ?>" style="...">
                        </div>
                        <div style="flex: 1;">
                            <label><?php echo esc_html__('グループ表示名', 'smart-booking-pro2'); ?><br><?php echo esc_html__('(日本語可):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="acf_group_label" maxlength="50" required value="<?php echo isset($acf_group_label) ? esc_attr($acf_group_label) : ''; ?>" style="...">
                        </div>
                    </div>

                    <div id="cf7-acf-fields" style="margin-top: 20px;"></div>
                </form>

            <?php else : ?>
                <!-- 🔒 制限中の案内 -->  
                <!-- 🔒 Notification while restricted -->
                <div style="background: #fff3f3; padding: 30px; border-radius: 8px; text-align: center; border: 1px solid #f5c2c2;">
                    <p style="color: #cc0000; font-size: 16px; font-weight: bold;">
                        🔒 <?php echo esc_html__('PROプランで無制限利用可能です', 'smart-booking-pro2'); ?>
                    </p>
                    <p style="font-size: 14px;">
                        <?php echo esc_html__('無料プランではデータベースの作成数が上限に達しています。', 'smart-booking-pro2'); ?>
                    </p>
                </div>

            <?php endif; ?>
        </div>


        <?php if (
            !function_exists('sbp2_is_pro_user') || 
            (!sbp2_is_pro_user() && !sbp2_is_enterprise_user())
        ): ?>
            <div class="notice notice-error">
                <h2><?php esc_html_e('CSVからDB生成は PRO プラン専用です', 'smart-booking-pro2'); ?></h2>
                <p><?php esc_html_e('アップグレードすることでご利用いただけます。', 'smart-booking-pro2'); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=smart_booking_status')); ?>" class="button button-primary">
                    <?php esc_html_e('ステータス画面からアップグレード', 'smart-booking-pro2'); ?>
                </a>
            </div>
        <?php else: ?>

        <div class="sbp2-tab-content" data-tab="csv" style="display: none;">
            <!-- ✅ CSVからデータベース作成機能 -->  
            <!-- ✅ Database creation function from CSV -->
            <h2 style="margin-top: 40px;"><?php esc_html_e('CSVファイルからデータベース作成', 'smart-booking-pro2'); ?></h2>

            <form method="post" enctype="multipart/form-data" id="csv-import-form" style="...">
                <label><?php esc_html_e('CSVファイルを選択:', 'smart-booking-pro2'); ?></label>
                <input type="file" name="csv_file" accept=".csv" required>
                <input type="submit" name="upload_csv" value="<?php esc_attr_e('取り込み', 'smart-booking-pro2'); ?>">
            </form>

            <?php if (isset($_FILES['csv_file'])): ?>
                <?php
                $csv_file = $_FILES['csv_file']['tmp_name'];
                $file_name = pathinfo($_FILES['csv_file']['name'], PATHINFO_FILENAME);
                $acf_group_name = $file_name . '_acfg';

                if (($handle = fopen($csv_file, "r")) !== FALSE) {
                    $headers = fgetcsv($handle);
                    fclose($handle);
                }
                ?>

                <h2><?php esc_html_e('カスタム投稿タイプ & ACF 設定', 'smart-booking-pro2'); ?></h2>
                <form method="post">
                    <input type="hidden" name="csv_file_path" value="<?php echo esc_attr($csv_file); ?>">

                    <div style="display: flex; gap: 20px; align-items: center; width:60%;">
                        <div style="flex: 1;">
                            <label><?php esc_html_e('データベース内部名 (半角英数字10文字以内):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="post_type_name" value="<?php echo esc_attr($file_name); ?>" maxlength="10" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                        </div>
                        <div style="flex: 1;">
                            <label><?php esc_html_e('データベース表示名 (日本語可):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="post_type_label" placeholder="<?php esc_attr_e('例: 顧客データ', 'smart-booking-pro2'); ?>" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                        </div>
                    </div>

                    <div style="display: flex; gap: 20px; align-items: center; width:60%; margin-top: 10px;">
                        <div style="flex: 1;">
                            <label><?php esc_html_e('グループ内部名 (半角英数字10文字以内):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="acf_group_name" value="<?php echo esc_attr($acf_group_name); ?>" maxlength="10" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                        </div>
                        <div style="flex: 1;">
                            <label><?php esc_html_e('グループ表示名 (日本語可):', 'smart-booking-pro2'); ?></label>
                            <input type="text" name="acf_group_label" placeholder="<?php esc_attr_e('例: 顧客情報フィールド', 'smart-booking-pro2'); ?>" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                        </div>
                    </div>

                    <h3><?php esc_html_e('フィールド設定', 'smart-booking-pro2'); ?></h3>
                    <div id="csv-acf-fields" style="width:60%;">
                        <?php foreach ($headers as $header): ?>
                            <div class="csv-acf-field" style="display: flex; gap: 10px; align-items: center; margin-bottom: 10px;">
                                <input type="text" name="acf_field_name[]" value="<?php echo esc_attr($header); ?>" placeholder="<?php esc_attr_e('フィールド内部名', 'smart-booking-pro2'); ?>" required style="flex: 1; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                                <input type="text" name="acf_field_label[]" value="<?php echo esc_attr($header); ?>" placeholder="<?php esc_attr_e('日本語ラベル', 'smart-booking-pro2'); ?>" required style="flex: 1; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                                <select name="acf_field_type[]" style="flex: 1; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                                    <option value="text"><?php esc_html_e('文字', 'smart-booking-pro2'); ?></option>
                                    <option value="number"><?php esc_html_e('数字', 'smart-booking-pro2'); ?></option>
                                    <option value="textarea"><?php esc_html_e('文章', 'smart-booking-pro2'); ?></option>
                                    <option value="email"><?php esc_html_e('メール', 'smart-booking-pro2'); ?></option>
                                    <option value="date_picker"><?php esc_html_e('日付', 'smart-booking-pro2'); ?></option>
                                    <option value="time_picker"><?php esc_html_e('時間', 'smart-booking-pro2'); ?></option>
                                    <option value="true_false"><?php esc_html_e('真偽', 'smart-booking-pro2'); ?></option>
                                </select>
                                <button type="button" class="remove-csv-field" style="..." >
                                    <?php esc_html_e('削除', 'smart-booking-pro2'); ?>
                                </button>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <input type="hidden" name="import_csv_data" value="0">
                    <br>
                    <input type="submit" name="create_db" value="<?php esc_attr_e('作成', 'smart-booking-pro2'); ?>" onclick="saveScrollPosition()" style="...">
                </form>

            <?php endif; ?>

            <!-- CSVデータ取込処理 -->  
            <!-- CSV data import process -->
            <h2 style="margin-top: 40px;"><?php esc_html_e('CSVデータを既存DBに取り込み', 'smart-booking-pro2'); ?></h2>

            <form method="post" enctype="multipart/form-data" style="background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); max-width: 800px;">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="csv_file"><?php esc_html_e('CSVファイルの選択', 'smart-booking-pro2'); ?></label>
                        </th>
                        <td>
                            <input type="file" name="csv_file" id="csv_file" accept=".csv" required>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="target_post_type"><?php esc_html_e('保存先データベース', 'smart-booking-pro2'); ?></label>
                        </th>
                        <td>
                            <select name="target_post_type" id="target_post_type" required>
                                <?php
                                $post_types = get_custom_post_types_for_select();
                                foreach ($post_types as $key => $label) {
                                    echo '<option value="' . esc_attr($key) . '">' . esc_html($label) . '</option>';
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr id="title_column_row" style="display:none;">
                        <th scope="row">
                            <label for="title_column_select"><?php esc_html_e('データタイトルに使う列（複数選択可）', 'smart-booking-pro2'); ?></label>
                        </th>
                        <td>
                            <select name="title_column[]" id="title_column_select" multiple size="5" style="min-width: 250px;"></select>
                            <p class="description">
                                <?php esc_html_e('Ctrl (Windows) または ⌘ (Mac) を押しながら複数選択できます。', 'smart-booking-pro2'); ?>
                            </p>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <input type="submit" name="submit_csv_upload" class="button button-primary" value="<?php esc_attr_e('アップロード実行', 'smart-booking-pro2'); ?>">
                </p>
            </form>

        </div>

        <?php endif; // PROユーザー以外は終了 ?>




    </div>


    <!-- ✅ 最初にページ全体を覆うオーバーレイ（リロード直後に真っ白にする） -->  
    <!-- ✅ Initial overlay covering the entire page (make it completely white immediately after reload) -->
    <div id="loading-overlay" style="
        position: fixed; top: 0; left: 0; width: 100%; height: 100%;
        background: white; z-index: 9999; opacity: 1; transition: opacity 0.3s ease;">
    </div>

    <script>
        // ✅ スクロール位置を保存する関数  
        // ✅ Function to save scroll position
        function saveScrollPosition() {
            sessionStorage.setItem('scrollPosition', window.scrollY);
        }

        // ✅ スクロール位置を復元する関数  
        // ✅ Function to restore scroll position
        function restoreScrollPosition() {
            let scrollPos = sessionStorage.getItem('scrollPosition');
            if (scrollPos !== null) {
                setTimeout(() => {
                    window.scrollTo({
                        top: parseInt(scrollPos),
                        behavior: 'instant'
                    });
                    sessionStorage.removeItem('scrollPosition');

                    // ✅ スクロール後にオーバーレイをフェードアウト  
                    // ✅ Fade out the overlay after scrolling
                    setTimeout(() => {
                        let overlay = document.getElementById('loading-overlay');
                        overlay.style.opacity = '0';
                        setTimeout(() => {
                            overlay.style.display = 'none';
                        }, 300);
                    }, 100);
                }, 10);
            } else {
                // スクロール位置が保存されていない場合もオーバーレイをフェードアウト  
                // Fade out the overlay even if scroll position is not saved
                setTimeout(() => {
                    let overlay = document.getElementById('loading-overlay');
                    overlay.style.opacity = '0';
                    setTimeout(() => {
                        overlay.style.display = 'none';
                    }, 300);
                }, 500);
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            const csvFieldContainer = document.getElementById('csv-acf-fields');
            if (csvFieldContainer) {
                csvFieldContainer.addEventListener('click', function (event) {
                    if (event.target.classList.contains('remove-csv-field')) {
                        event.target.parentElement.remove();
                    }
                });
            }

            // ✅ 取り込みボタンのクリック時にもスクロール位置を保存  
            // ✅ Save scroll position also when the import button is clicked
            const uploadButton = document.querySelector('input[name="upload_csv"]');
            if (uploadButton) {
                uploadButton.addEventListener('click', saveScrollPosition);
            }

            // ✅ フォーム送信時にスクロール位置を保存  
            // ✅ Save scroll position on form submission
            const importForm = document.getElementById('csv-import-form');
            if (importForm) {
                importForm.addEventListener('submit', saveScrollPosition);
            }

            // ✅ スクロール位置の復元（遅延で確実に適用）  
            // ✅ Restore scroll position (apply reliably with delay)
            setTimeout(restoreScrollPosition, 50);
        });

    </script>
    

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const fieldContainer = document.getElementById('acf-fields');
            const addButton = document.getElementById('add-field');

            addButton.addEventListener('click', function () {
                const fieldDiv = document.createElement('div');
                fieldDiv.classList.add('acf-field');
                fieldDiv.style.display = "flex";
                fieldDiv.style.gap = "10px";
                fieldDiv.style.alignItems = "center";
                fieldDiv.style.marginBottom = "10px";

                fieldDiv.innerHTML = `
                    <input type="text" name="acf_field_name[]" required
                        placeholder="<?php echo esc_attr__('フィールド名', 'smart-booking-pro2'); ?>"
                        style="flex: 2; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">

                    <select name="acf_field_type[]"
                        style="flex: 1; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                        <option value="text"><?php echo esc_html__('文字（text）', 'smart-booking-pro2'); ?></option>
                        <option value="number"><?php echo esc_html__('数字（number）', 'smart-booking-pro2'); ?></option>
                        <option value="textarea"><?php echo esc_html__('文章（textarea）', 'smart-booking-pro2'); ?></option>
                        <option value="email"><?php echo esc_html__('メール（email）', 'smart-booking-pro2'); ?></option>
                        <option value="date_picker"><?php echo esc_html__('日付（date_picker, y-m-d）', 'smart-booking-pro2'); ?></option>
                        <option value="time_picker"><?php echo esc_html__('時間（time_picker, H:i）', 'smart-booking-pro2'); ?></option>
                        <option value="true_false"><?php echo esc_html__('真偽（true_false）', 'smart-booking-pro2'); ?></option>
                    </select>

                    <button type="button" class="remove-field"
                        style="background: #d9534f; color: #fff; border: none; padding: 8px 12px; border-radius: 4px; cursor: pointer;">
                        <?php echo esc_html__('削除', 'smart-booking-pro2'); ?>
                    </button>
                `;
                fieldContainer.appendChild(fieldDiv);
            });

            fieldContainer.addEventListener('click', function (event) {
                if (event.target.classList.contains('remove-field')) {
                    event.target.parentElement.remove();
                }
            });
        });
    </script>



    <script>
        document.getElementById('csv_file').addEventListener('change', function (e) {
            const file = e.target.files[0];
            if (!file) return;

            const reader = new FileReader();
            reader.onload = function (e) {
                const lines = e.target.result.split(/\r?\n/);
                if (lines.length === 0) return;

                const headers = lines[0].split(',');

                const select = document.getElementById('title_column_select');
                select.innerHTML = '';
                headers.forEach((header, i) => {
                    const option = document.createElement('option');
                    option.value = i;
                    option.textContent = header;
                    select.appendChild(option);
                });

                document.getElementById('title_column_row').style.display = 'table-row';
            };
            reader.readAsText(file);
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // ✅ 他の管理画面に遷移した場合、保存タブ情報を削除  
            // ✅ Delete saved tab information when navigating to other admin pages
            if (!location.href.includes('page=smart_booking_db')) {
                localStorage.removeItem('sbp2-selected-tab');
            }

            const tabButtons = document.querySelectorAll('.sbp2-tab-btn');
            const tabContents = document.querySelectorAll('.sbp2-tab-content');

            // 保存されたタブを取得（なければ最初のタブを使用）  
            // Retrieve saved tab (use first tab if none saved)
            const savedTab = localStorage.getItem('sbp2-selected-tab') || tabButtons[0]?.getAttribute('data-tab');

            function activateTab(target) {
                tabButtons.forEach(btn => {
                    const isActive = btn.getAttribute('data-tab') === target;
                    btn.style.background = isActive ? '#0073aa' : '#eee';
                    btn.style.color = isActive ? '#fff' : '#000';
                    btn.style.borderColor = isActive ? '#0073aa' : '#ccc';
                });

                tabContents.forEach(content => {
                    content.style.display = content.getAttribute('data-tab') === target ? 'block' : 'none';
                });
            }

            // 初期表示で復元  
            // Restore on initial display
            if (savedTab) {
                activateTab(savedTab);
            }

            // ボタンクリック時  
            // On button click
            tabButtons.forEach(button => {
                button.addEventListener('click', function () {
                    const target = this.getAttribute('data-tab');
                    localStorage.setItem('sbp2-selected-tab', target);
                    activateTab(target);
                });
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
        const createForm = document.querySelector('form input[name="create_db"]')?.form;
        if (!createForm) return;

        createForm.addEventListener('submit', function (e) {
            const postTypeInput = createForm.querySelector('input[name="post_type_name"]');
            const groupNameInput = createForm.querySelector('input[name="acf_group_name"]');

            const postType = postTypeInput?.value.trim() || '';
            const groupName = groupNameInput?.value.trim() || '';

            // 10文字超過チェック（ACF登録制限対策）
            const maxLen = 10;
            const overLimit = [];

            if (postType.length > maxLen) overLimit.push(`・データベース内部名（${postType.length}文字）`);
            if (groupName.length > maxLen) overLimit.push(`・グループ内部名（${groupName.length}文字）`);

            if (overLimit.length > 0) {
            alert("⚠️ 入力内容が長すぎます。\n\n" + overLimit.join("\n") + "\n\n※ 各項目は10文字以内にしてください。");
            e.preventDefault();
            return;
            }
        });
        });
    </script>


    <?php
}


// ✅ 「投稿作成一覧」ページの内容  
// ✅ Contents of the "Post Creation List" page
function smart_booking_post_list_page() {
    $saved_data_acf = get_option('smart_booking_acf_data', array());
    $saved_data_db = get_option('smart_booking_acf_db', array());

    if (!is_array($saved_data_acf)) $saved_data_acf = array();
    if (!is_array($saved_data_db)) $saved_data_db = array();

    $merged_data = array_merge($saved_data_acf, $saved_data_db);

    echo '<div class="wrap">';
    echo '<h1>' . esc_html__('投稿作成一覧', 'smart-booking-pro2') . '</h1>';

    if (!empty($merged_data)) {
        echo '<table class="widefat">';
        echo '<thead><tr><th>' . esc_html__('投稿タイプ', 'smart-booking-pro2') . '</th><th>' . esc_html__('アクション', 'smart-booking-pro2') . '</th></tr></thead>';
        echo '<tbody>';
        foreach ($merged_data as $data) {
            $post_type_url = admin_url('edit.php?post_type=' . esc_attr($data['post_type']));
            $post_type_label = !empty($data['post_type_label']) ? $data['post_type_label'] : $data['post_type'];

            echo '<tr>';
            echo '<td>' . esc_html($post_type_label) . '</td>';
            echo '<td>';
            echo '<a href="' . esc_url($post_type_url) . '" class="button button-primary">' . esc_html__('投稿管理画面へ', 'smart-booking-pro2') . '</a>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</tbody></table>';
    } else {
        echo '<p>' . esc_html__('まだ作成された投稿タイプはありません。', 'smart-booking-pro2') . '</p>';
    }

    echo '</div>';
}


// 保存済みデータリストメニュー関数  
// Saved data list menu function
function smart_booking_saved_list_page() {
    // ✅ 予約済み日時の投稿タイプも選択リストに追加  
    // ✅ Add the reserved date and time post type to the selection list
    $custom_post_types = ['reserved-daytime']; 

    // ✅ `smart_booking_acf_data` と `smart_booking_acf_db` の両方を取得  
    // ✅ Retrieve both `smart_booking_acf_data` and `smart_booking_acf_db`
    $saved_acf_data = get_option('smart_booking_acf_data', array());
    $saved_acf_db = get_option('smart_booking_acf_db', array());

    // ✅ データが空の場合、配列を確保  
    // ✅ Ensure array is initialized if data is empty
    if (!is_array($saved_acf_data)) $saved_acf_data = array();
    if (!is_array($saved_acf_db)) $saved_acf_db = array();

    // ✅ 両方のデータを統合  
    // ✅ Merge both datasets
    $merged_data = array_merge($saved_acf_data, $saved_acf_db);
    ?>

    <div class="wrap">
        <h1><?php echo esc_html__('保存一覧', 'smart-booking-pro2'); ?></h1>

        <!-- ✅ 投稿タイプ選択フォーム -->  
        <!-- ✅ Post type selection form -->
        <label for="post-type-select"><?php echo esc_html__('データベースを選択:', 'smart-booking-pro2'); ?></label>
        <select id="post-type-select">
            <option value=""><?php echo esc_html__('-- データベースを選択 --', 'smart-booking-pro2'); ?></option>
            <?php
            // 予約済み日時の投稿タイプも選択肢に追加  
            // Add reserved date and time post type to the options
            echo '<option value="reserved-daytime">' . esc_html__('予約済み日時', 'smart-booking-pro2') . '</option>';
            
            foreach ($merged_data as $data) {
                if (!empty($data['post_type'])) {
                    $label = isset($data['post_type_label']) ? $data['post_type_label'] : $data['post_type'];
                    echo '<option value="' . esc_attr($data['post_type']) . '">' . esc_html($label) . '</option>';
                }
            }
            ?>
        </select>

        <!-- ✅ 日付フィルタ -->  
        <!-- ✅ Date filter -->
        <label for="start-date"><?php echo esc_html__('開始日:', 'smart-booking-pro2'); ?></label>
        <input type="date" id="start-date">
        
        <label for="end-date"><?php echo esc_html__('終了日:', 'smart-booking-pro2'); ?></label>
        <input type="date" id="end-date">

        <button id="fetch-posts" class="button button-primary">
            <?php echo esc_html__('表示', 'smart-booking-pro2'); ?>
        </button>

        <!-- ✅ 投稿データ一覧 -->  
        <!-- ✅ Post data list -->
        <div id="post-data-container" style="margin-top: 20px;"></div>

        <?php
        $is_pro_or_higher = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());
        $base_style = 'display: none; margin-top: 20px;';
        $restricted_style = 'pointer-events: none; opacity: 0.5;';
        $style = $base_style . ($is_pro_or_higher ? '' : ' ' . $restricted_style);
        ?>

        <!-- ✅ CSV出力ボタン -->  
        <!-- ✅ CSV export button -->
        <button 
            id="export-csv" 
            class="button button-secondary"
            style="<?php echo esc_attr($style); ?>"
            <?php echo $is_pro_or_higher ? '' : 'disabled'; ?>
        >
            <?php
            echo esc_html__($is_pro_or_higher ? 'CSV出力 🔓' : 'CSV出力 🔒PRO', 'smart-booking-pro2');
            ?>
        </button>
    </div>

        <script>
        document.addEventListener("DOMContentLoaded", function() {
            const fetchButton = document.getElementById("fetch-posts");
            const postTypeSelect = document.getElementById("post-type-select");
            const postContainer = document.getElementById("post-data-container");
            const exportButton = document.getElementById("export-csv");
            const startDateInput = document.getElementById("start-date");
            const endDateInput = document.getElementById("end-date");

            // ✅ 翻訳関数の読み込み（エイリアス）  
            // ✅ Load translation functions (alias)
            const __ = wp.i18n.__;

            fetchButton.addEventListener("click", function() {
                const postType = postTypeSelect.value;
                const startDate = startDateInput.value;
                const endDate = endDateInput.value;

                if (!postType) {
                    alert(__('投稿タイプを選択してください。', 'smart-booking-pro2'));
                    return;
                }

                jQuery.ajax({
                    url: ajaxurl,
                    type: "POST",
                    data: {
                        action: "smart_booking_get_post_data",
                        post_type: postType,
                        start_date: startDate,
                        end_date: endDate
                    },
                    beforeSend: function() {
                        postContainer.innerHTML = "<p>" + __('データ取得中...', 'smart-booking-pro2') + "</p>";
                    },
                    success: function(response) {
                        if (response.success) {
                            postContainer.innerHTML = response.data.html;
                            exportButton.style.display = "block"; // ✅ CSV出力ボタンを表示
                        } else {
                            postContainer.innerHTML = "<p>" + __('データが見つかりません。', 'smart-booking-pro2') + "</p>";
                            exportButton.style.display = "none";
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAXエラー:", error);
                        postContainer.innerHTML = "<p>" + __('エラーが発生しました。', 'smart-booking-pro2') + "</p>";
                    }
                });
            });

            exportButton.addEventListener("click", function() {
                const postType = postTypeSelect.value;
                const startDate = startDateInput.value;
                const endDate = endDateInput.value;

                if (!postType) {
                    alert(__('投稿タイプを選択してください。', 'smart-booking-pro2'));
                    return;
                }

                window.location.href = ajaxurl + "?action=smart_booking_export_csv&post_type=" + postType + "&start_date=" + startDate + "&end_date=" + endDate;
            });
        });
        </script>


    <?php
}


// Create CF7：CF7フォームの自動作成  
// Create CF7: Automatic creation of CF7 forms
function smart_booking_create_cf7_page() {
    // ✅ `smart_booking_acf_data` & `smart_booking_acf_db` を取得  
    // ✅ Retrieve `smart_booking_acf_data` & `smart_booking_acf_db`
    $saved_acf_data = get_option('smart_booking_acf_data', array());
    $saved_acf_db = get_option('smart_booking_acf_db', array());

    // ✅ 両方のデータを統合  
    // ✅ Merge both datasets
    $merged_data = array_merge($saved_acf_data, $saved_acf_db);
    ?>

        <div class="wrap">
            <h1><?php _e('Create CF7 - フォーム作成', 'smart-booking-pro2'); ?></h1>

            <!-- ✅ 投稿タイプ選択 -->  
            <!-- ✅ Post type selection -->
            <label for="post-type-select"><?php _e('データベースを選択:', 'smart-booking-pro2'); ?></label>
            <select id="post-type-select">
                <option value=""><?php _e('-- データベースを選択 --', 'smart-booking-pro2'); ?></option>
                <?php
                    foreach ($merged_data as $data) {
                        $slug  = $data['post_type'];
                        $label = !empty($data['post_type_label']) ? $data['post_type_label'] : $slug;

                        echo '<option value="' . esc_attr($slug) . '">' . esc_html($label) . '</option>';
                    }
                ?>
            </select>

            <button id="fetch-acf-fields" class="button button-primary"><?php _e('表示', 'smart-booking-pro2'); ?></button>

            <!-- ✅ フォーム設定 UI（非表示） -->  
            <!-- ✅ Form settings UI (hidden) -->
            <div id="cf7-form-container" style="display: none; margin-top: 20px;">
                <h2><?php _e('フォーム基本設定', 'smart-booking-pro2'); ?></h2>

                <label><?php _e('フォーム名：', 'smart-booking-pro2'); ?></label>
                <input type="text" id="cf7-form-name" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">

                <label><?php _e('送信先メールアドレス：', 'smart-booking-pro2'); ?></label>
                <input type="text" id="cf7-admin-email" value="[_site_admin_email]" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">

                <label><?php _e('送信元メールアドレス：', 'smart-booking-pro2'); ?></label>
                <input type="text" id="cf7-from-email" value="<wordpress@fukuokashi-higashiku.sumaizero.com>" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">

                <label><?php _e('メール件名：', 'smart-booking-pro2'); ?></label>
                <input type="text" id="cf7-email-subject" value="[_site_title] '[your-subject]'" required style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">

                <label><?php _e('追加ヘッダー：', 'smart-booking-pro2'); ?></label>
                <textarea id="cf7-additional-headers" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;"></textarea>

                <label><?php _e('管理者用メールの冒頭文：', 'smart-booking-pro2'); ?></label>
                <textarea id="cf7-admin-mail-intro" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;"></textarea>

                <label><?php _e('管理者用メールの締めの文章：', 'smart-booking-pro2'); ?></label>
                <textarea id="cf7-admin-mail-closing" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;"></textarea>

                <h2><?php _e('フィールド設定', 'smart-booking-pro2'); ?></h2>
                <div id="cf7-fields-container"></div>

                <button id="add-cf7-field" class="button button-secondary" style="margin-top: 20px;">
                    <?php _e('＋ フィールド追加', 'smart-booking-pro2'); ?>
                </button>
                <button id="cf7-create-button" class="button button-primary" style="margin-top: 20px;">
                    <?php _e('CF7 フォーム作成', 'smart-booking-pro2'); ?>
                </button>
            </div>
        </div>


    <?php
}


// CF7 フォーム編集の実行関数  
// Function to execute CF7 form editing
function smart_booking_cf7_management_page() {
    global $selected_form_id;

    // 🔁 保存処理を最初に実行（保存後に再表示させるため）  
    // 🔁 Execute save process first (to redisplay after saving)
    if (isset($_POST['save_form_pro2']) && !empty($_POST['selected_form'])) {

        // 🔐 nonce チェック追加  
        // 🔐 Add nonce check
        if (!isset($_POST['cf7_form_nonce']) || !wp_verify_nonce($_POST['cf7_form_nonce'], 'save_cf7_form_action')) {
            wp_die(__('不正なリクエストです。', 'smart-booking-pro2'));
        }

        $selected_form_id = intval($_POST['selected_form']);

        update_post_meta($selected_form_id, '_form', wp_kses_post($_POST['form_html']));
        update_post_meta($selected_form_id, '_mail', [
            'recipient' => sanitize_text_field($_POST['mail_recipient']),
            'sender' => sanitize_text_field($_POST['mail_sender']),
            'subject' => sanitize_text_field($_POST['mail_subject']),
            'additional_headers' => sanitize_textarea_field($_POST['mail_headers']),
            'body' => sanitize_textarea_field($_POST['mail_body']),
        ]);

        echo '<div class="updated"><p>' . esc_html__('フォーム設定が保存されました。', 'smart-booking-pro2') . '</p></div>';


        // 🔁 フォーム再表示用にフラグを立てる  
        // 🔁 Set flag for form redisplay
        $_POST['load_form'] = true;
    }

    // 🔁 選択フォームIDのセット  
    // 🔁 Set the selected form ID
    if (isset($_POST['selected_form'])) {
        $selected_form_id = intval($_POST['selected_form']);
    }

    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('CF7 フォーム編集', 'smart-booking-pro2'); ?></h1>
        <form method="post">
            <?php wp_nonce_field('save_cf7_form_action', 'cf7_form_nonce'); ?>

            <label for="selected_form"><?php echo esc_html__('管理するフォームを選択:', 'smart-booking-pro2'); ?></label>
            <select name="selected_form" id="selected_form">
                <?php
                if (!class_exists('WPCF7_ContactForm')) {
                    echo '<option disabled>' . esc_html__('Contact Form 7 がインストールされていません', 'smart-booking-pro2') . '</option>';
                } else {
                    $forms = get_posts([
                        'post_type' => 'wpcf7_contact_form',
                        'post_status' => 'any',
                        'posts_per_page' => -1,
                    ]);
                    foreach ($forms as $form) {
                        $selected = ($form->ID == $selected_form_id) ? 'selected' : '';
                        echo '<option value="' . esc_attr($form->ID) . '" ' . $selected . '>' . esc_html($form->post_title) . '</option>';
                    }
                }
                ?>
            </select>
            <button type="submit" name="load_form" class="button button-primary"><?php echo esc_html__('表示', 'smart-booking-pro2'); ?></button>
        </form>


        <?php
        // 🔁 選択されたフォームの内容を表示  
        // 🔁 Display the contents of the selected form
        if (isset($_POST['load_form']) && !empty($_POST['selected_form'])) {
            $selected_form_id = intval($_POST['selected_form']);
            $form = get_post($selected_form_id);

            if (!$form) {
                echo '<p class="error">' . esc_html__('フォームが見つかりません。', 'smart-booking-pro2') . '</p>';
                return;
            }

            $form_html = get_post_meta($selected_form_id, '_form', true);
            $mail_meta = get_post_meta($selected_form_id, '_mail', true);

            if (!is_array($mail_meta)) {
                $mail_meta = [];
            }
            ?>
            
            <form method="post">
                <?php wp_nonce_field('save_cf7_form_action', 'cf7_form_nonce'); ?>
                <input type="hidden" name="selected_form" value="<?php echo esc_attr($selected_form_id); ?>">

                <h2><?php echo esc_html__('フォームHTMLの編集', 'smart-booking-pro2'); ?></h2>
                <textarea name="form_html" rows="10" style="width:100%;"><?php echo esc_textarea($form_html); ?></textarea>
                
                <h3><?php echo esc_html__('管理者用メール設定', 'smart-booking-pro2'); ?></h3>

                <label><?php echo esc_html__('送信先メールアドレス:', 'smart-booking-pro2'); ?></label>
                <input type="text" name="mail_recipient" value="<?php echo esc_attr($mail_meta['recipient'] ?? ''); ?>" style="width:100%;"><br><br>

                <label><?php echo esc_html__('送信元メールアドレス:', 'smart-booking-pro2'); ?></label>
                <input type="text" name="mail_sender" value="<?php echo esc_attr($mail_meta['sender'] ?? ''); ?>" style="width:100%;"><br><br>

                <label><?php echo esc_html__('メール件名:', 'smart-booking-pro2'); ?></label>
                <input type="text" name="mail_subject" value="<?php echo esc_attr($mail_meta['subject'] ?? ''); ?>" style="width:100%;"><br><br>

                <label><?php echo esc_html__('追加ヘッダー:', 'smart-booking-pro2'); ?></label>
                <textarea name="mail_headers" rows="3" style="width:100%;"><?php echo esc_textarea($mail_meta['additional_headers'] ?? ''); ?></textarea><br><br>

                <label><?php echo esc_html__('メール本文:', 'smart-booking-pro2'); ?></label>
                <textarea name="mail_body" rows="5" style="width:100%;"><?php echo esc_textarea($mail_meta['body'] ?? ''); ?></textarea><br><br>
                
                <button type="submit" name="save_form_pro2" class="button button-primary">
                    <?php echo esc_html__('保存', 'smart-booking-pro2'); ?>
                </button>
            </form>

                        <?php
                    }
                echo '</div>';
            }



// CF7確認メール作成メニューの実行関数  
// Function to execute CF7 confirmation email creation menu
function render_cf7_to_confirm_page() {
    $selected_form_id = isset($_POST['selected_form']) ? intval($_POST['selected_form']) : 0;
    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('CF7 to Confirm テンプレート生成', 'smart-booking-pro2'); ?></h1>

        <form method="post">
            <label for="selected_form"><?php echo esc_html__('フォームを選択:', 'smart-booking-pro2'); ?></label>
            <select name="selected_form" id="selected_form">
                <?php
                $forms = get_posts([
                    'post_type' => 'wpcf7_contact_form',
                    'post_status' => 'any',
                    'posts_per_page' => -1,
                ]);
                foreach ($forms as $form) {
                    $selected = ($form->ID == $selected_form_id) ? 'selected' : '';
                    echo '<option value="' . esc_attr($form->ID) . '" ' . $selected . '>' . esc_html($form->post_title) . '</option>';
                }
                ?>
            </select>
            <button type="submit" class="button"><?php echo esc_html__('読み込み', 'smart-booking-pro2'); ?></button>
        </form>


    <?php if ($selected_form_id): ?>
        <hr>
        <form method="post">
            <?php wp_nonce_field('save_cf7_confirm_template', 'cf7_confirm_nonce'); ?>
            <input type="hidden" name="selected_form" value="<?php echo esc_attr($selected_form_id); ?>">

            <h2><?php echo esc_html__('件名', 'smart-booking-pro2'); ?></h2>
            <input type="text" name="template_subject" style="width:100%;" value="<?php echo esc_attr__('【ご予約確認】：自動送信', 'smart-booking-pro2'); ?>">

            <h2><?php echo esc_html__('ヘッダー', 'smart-booking-pro2'); ?></h2>
            <textarea name="template_header" rows="5" style="width:100%;"><?php echo esc_textarea(__('{お客様名のフィールド} 様

    この度はご予約ありがとうございます。
    以下の内容でご予約を受け付けました。', 'smart-booking-pro2')); ?></textarea>

            <h2><?php echo esc_html__('本体（自動生成）', 'smart-booking-pro2'); ?></h2>
            <textarea readonly rows="10" style="width:100%; background:#f9f9f9;">
    <?php
    $form = WPCF7_ContactForm::get_instance($selected_form_id);
    $tags = $form ? $form->scan_form_tags() : [];
    $form_html = $form->prop('form');
    $label_map = get_cf7_label_map($form_html);
    foreach ($tags as $tag) {
        if ($tag['type'] === 'hidden' || $tag['type'] === 'submit') continue;
        $name = $tag['name'];
        $label = $label_map[$name] ?? $name;
        echo "■ {$label}：{{$name}}\n";
    }
    ?>
            </textarea>

            <h2><?php echo esc_html__('フッター', 'smart-booking-pro2'); ?></h2>
            <textarea name="template_footer" rows="6" style="width:100%;"><?php echo esc_textarea(__('━━━━━━━━━━━━━━━━━━━
    ◆ ご案内
    ━━━━━━━━━━━━━━━━━━━
    当日はお気をつけてお越しください。
    変更・キャンセルをご希望の場合は、事前にご連絡ください。

    ご不明点がございましたら、お気軽にお問い合わせください。

    ------------------------------------------------------------
    default 事務局
    info@yourdomain.com
    000-000-0000', 'smart-booking-pro2')); ?></textarea>

                <h2><?php echo esc_html__('ファイル名（.txt）', 'smart-booking-pro2'); ?></h2>
                <input type="text" name="output_filename" value="sample" style="width:300px;">.txt
                <br><br>
                <button type="submit" name="generate_template" class="button button-primary">
                    <?php echo esc_html__('テンプレート生成', 'smart-booking-pro2'); ?>
                </button>
            </form>
        <?php endif; ?>
    </div>


    <?php
        if (isset($_POST['generate_template']) && check_admin_referer('save_cf7_confirm_template', 'cf7_confirm_nonce')) {
            $subject_line = 'Subject: ' . sanitize_text_field($_POST['template_subject']);
            $header = sanitize_textarea_field($_POST['template_header']);
            $footer = sanitize_textarea_field($_POST['template_footer']);
            $form = WPCF7_ContactForm::get_instance($selected_form_id);
            $form_html = $form->prop('form');
            $label_map = get_cf7_label_map($form_html);

            $main = "━━━━━━━━━━━━━━━━━━━\n" . __('◆ 予約内容', 'smart-booking-pro2') . "\n━━━━━━━━━━━━━━━━━━━\n";
            foreach ($form->scan_form_tags() as $tag) {
                if ($tag['type'] === 'hidden' || $tag['type'] === 'submit') continue;
                $name = $tag['name'];
                $label = $label_map[$name] ?? $name;
                $main .= "■ {$label}：{{$name}}\n";
            }

            $template = $subject_line . "\n\n" . $header . "\n\n" . $main . "\n\n" . $footer;

            $plugin_main_file = WP_PLUGIN_DIR . '/smart-booking-pro2/smart-booking-pro2.php';
            $plugin_dir = plugin_dir_path($plugin_main_file);
            $dir = trailingslashit($plugin_dir . 'templates/confirms');
            if (!file_exists($dir)) {
                mkdir($dir, 0755, true);
            }

            $filename = 'confirmation-email-' . sanitize_file_name($_POST['output_filename']) . '.txt';
            file_put_contents($dir . $filename, $template);

            echo '<div class="notice notice-success is-dismissible"><p>' .
                sprintf(
                    esc_html__('テンプレートファイルが生成されました：%s', 'smart-booking-pro2'),
                    esc_html($filename)
                ) .
                '</p></div>';
        }

}
// CF7確認メール作成の実行関数で使用するlabel map  
// Label map used in CF7 confirmation email creation execution function
function get_cf7_label_map($form_html) {
    $label_map = [];

    // HTMLエラーを抑制し、マルチバイトにも対応  
    // Suppress HTML errors and support multibyte characters
    libxml_use_internal_errors(true);
    $doc = new DOMDocument();

    // HTML5でも問題なく動くようにラップ（特に UTF-8 指定は有効）  
    // Wrap to work properly in HTML5 (UTF-8 specification is especially effective)
    $doc->loadHTML('<?xml encoding="UTF-8"><!DOCTYPE html><html><body>' . $form_html . '</body></html>');

    $xpath = new DOMXPath($doc);
    $labels = $xpath->query('//label');

    foreach ($labels as $label) {
        $label_text = trim($label->textContent);
        $input = null;

        // 入力要素を探す（input, textarea, selectすべて対応）  
        // Search for input elements (supports input, textarea, and select)
        foreach ($label->getElementsByTagName('*') as $child) {
            if ($child->hasAttribute('name')) {
                $input = $child;
                break;
            }
        }

        if ($input) {
            $name = $input->getAttribute('name');
            $label_map[$name] = $label_text;
        }
    }

    return $label_map;
}


// 予約管理ページの実行関数  
// Function to execute reservation management page
function smart_booking_reservation_page() {
    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('予約管理', 'smart-booking-pro2'); ?></h1>
        <p><?php echo esc_html__('このページでは、イベント予約のカスタム投稿タイプと予約済み日時を管理できます。', 'smart-booking-pro2'); ?></p>
    </div>
    <?php
}



// フォームデザイン編集ページの内容  
// Content of the form design editing page
function ers_formdesign_editor_page() {

    $template_dir = plugin_dir_path(__DIR__) . 'css/';

    // templates/ フォルダ内の "page-thanks" で始まり、拡張子が txt または html のファイルを取得  
    // Retrieve files starting with "page-thanks" and having txt or html extension within the templates/ folder
    $email_files_php = glob($template_dir . 'style-formdesign*.css');
    $email_files_html = glob($template_dir . 'style-formdesign*.html');

    // 両方の配列をマージ（どちらかが null の場合を考慮）  
    // Merge both arrays (considering the case where either is null)
    $email_files = array_merge(
        is_array($email_files_php) ? $email_files_php : array(),
        is_array($email_files_html) ? $email_files_html : array()
    );

    $default_file = 'style-formdesign-default.css';
    $selected_file = isset($_POST['ers_formdesign_file']) ? basename($_POST['ers_formdesign_file']) : $default_file;
    $file_path = $template_dir . $selected_file;

    // フォーム送信処理（ファイルの保存）  
    // Form submission processing (save file)
    if (isset($_POST['ers_save_formdesign'])) {

        check_admin_referer('ers_save_formdesign_action');

        $new_content = stripslashes($_POST['ers_custom_formdesign']);
        file_put_contents($file_path, $new_content);

        echo '<div class="updated"><p>' . esc_html__('formdesignテンプレートが保存されました！', 'smart-booking-pro2') . '</p></div>';
    }


    // 選択されたファイルの内容を取得  
    // Retrieve the contents of the selected file
    $file_content = file_exists($file_path) ? file_get_contents($file_path) : '';

    ?>
    <div class="wrap">
        <h1>フォームデザインCSSテンプレートの編集</h1>

        <?php
        $is_pro = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());
        ?>

        <!-- アップロードフォーム -->
        <h2><?php echo esc_html__('テンプレートをアップロード', 'smart-booking-pro2'); ?></h2>

        <form id="ers-formdesign-upload-form" enctype="multipart/form-data">
            <?php wp_nonce_field('ers_upload_formdesign_action', 'ers_formdesign_upload_nonce'); ?>

            <input
                type="file"
                name="formdesign_file"
                id="ers-formdesign-file"
                accept=".css,.html"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >

            <button
                type="button"
                id="ers-formdesign-upload-btn"
                class="button button-secondary"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >
                <?php echo esc_html__('アップロード', 'smart-booking-pro2'); ?>
            </button>

            <p id="ers-formdesign-upload-result">
                <?php if (!$is_pro): ?>
                    <span style="color: red;">
                        <?php echo esc_html__('アップロード機能は PRO プラン以上でご利用いただけます。', 'smart-booking-pro2'); ?>
                    </span>
                <?php endif; ?>
            </p>
        </form>


        <p>
            <?php echo esc_html__('ファイル名ルール：style-formdesign で始まるファイル（拡張子 .css .html）', 'smart-booking-pro2'); ?>
        </p>

        <hr>

        <form method="post">
            <?php wp_nonce_field('ers_save_formdesign_action'); ?>

            <label for="ers_formdesign_file">
                <strong><?php echo esc_html__('編集するファイルを選択:', 'smart-booking-pro2'); ?></strong>
            </label>

            <select name="ers_formdesign_file" id="ers_formdesign_file" onchange="this.form.submit();">
                <?php foreach ($email_files as $file): ?>
                    <?php $filename = basename($file); ?>
                    <option value="<?php echo esc_attr($filename); ?>" <?php selected($selected_file, $filename); ?>>
                        <?php echo esc_html($filename); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <noscript>
                <input type="submit" value="<?php echo esc_attr__('選択', 'smart-booking-pro2'); ?>">
            </noscript>

            <br><br>
            <textarea name="ers_custom_formdesign" rows="20" style="width:100%; font-family: monospace;"><?php echo esc_textarea($file_content); ?></textarea>
            <br><br>
            <input type="submit" name="ers_save_formdesign" class="button button-primary" value="<?php echo esc_attr__('テンプレートを保存', 'smart-booking-pro2'); ?>">
        </form>

        <hr>

    </div>

    <?php
    $is_pro_or_higher = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());
    ?>
    <script>
        const SBP2_IS_PRO_OR_HIGHER = <?php echo $is_pro_or_higher ? 'true' : 'false'; ?>;
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const { __ } = wp.i18n;

            const uploadBtn   = document.getElementById("ers-formdesign-upload-btn");
            const uploadInput = document.getElementById("ers-formdesign-file");
            const resultBox   = document.getElementById("ers-formdesign-upload-result");

            if (!SBP2_IS_PRO_OR_HIGHER) {
                if (uploadBtn) {
                    uploadBtn.disabled = true;
                    uploadBtn.style.opacity = "0.6";
                    uploadBtn.title = __("PRO プラン以上で有効になります", "smart-booking-pro2");
                }

                if (uploadInput) {
                    uploadInput.disabled = true;
                    uploadInput.style.opacity = "0.6";
                    uploadInput.title = __("PRO プラン以上でファイル選択が可能です", "smart-booking-pro2");
                }

                if (resultBox) {
                    resultBox.innerHTML = '<span style="color: red;">' +
                        __("アップロード機能は PRO プラン以上でご利用いただけます。", "smart-booking-pro2") +
                        '</span>';
                }

                return;
            }

            uploadBtn?.addEventListener("click", function () {
                const fileInput = uploadInput?.files[0];
                if (!fileInput) {
                    alert(__("ファイルを選択してください", "smart-booking-pro2"));
                    return;
                }

                const ext = fileInput.name.split('.').pop().toLowerCase();
                if (ext !== "css" && ext !== "html") {
                    alert(__("アップロードできるのは css または HTML ファイルのみです", "smart-booking-pro2"));
                    return;
                }

                const formData = new FormData();
                formData.append("formdesign_file", fileInput);
                formData.append("action", "ers_upload_formdesign");
                const nonce = document.querySelector('input[name="ers_formdesign_upload_nonce"]').value;
                formData.append("ers_formdesign_upload_nonce", nonce);

                const xhr = new XMLHttpRequest();
                xhr.open("POST", ajaxurl, true);

                xhr.onload = function () {
                    if (xhr.status === 200) {
                        const response = JSON.parse(xhr.responseText);
                        if (response.success) {
                            resultBox.innerHTML = '<span style="color: green;">' +
                                __("アップロード成功:", "smart-booking-pro2") + ' ' + response.data +
                                '</span>';
                            location.reload();
                        } else {
                            resultBox.innerHTML = '<span style="color: red;">' +
                                __("エラー:", "smart-booking-pro2") + ' ' + response.data +
                                '</span>';
                        }
                    }
                };

                xhr.send(formData);
            });
        });


    </script>

    <?php

}

// AjaxでCSSファイルをアップロード  
// Upload CSS file via Ajax
function ers_ajax_upload_formdesign() {
    // ✅ PRO／Enterprise 以外は利用制限ページに遷移  
    // ✅ Redirect to restriction page for non-PRO/Enterprise users
    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    check_ajax_referer('ers_upload_formdesign_action', 'ers_formdesign_upload_nonce');


    if (!isset($_FILES['formdesign_file'])) {
        wp_send_json_error(__('ファイルが選択されていません。', 'smart-booking-pro2'));
    }

    $file = $_FILES['formdesign_file'];
    $upload_dir = plugin_dir_path(__DIR__) . 'css/';

    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $file_name = sanitize_file_name($file['name']);
    $target_file = $upload_dir . $file_name;
    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

    // アップロード可能な拡張子を制限  
    // Restrict allowed upload file extensions
    if (!in_array($ext, array('css', 'html'))) {
        wp_send_json_error(__('アップロードできるのは css または HTML ファイルのみです。', 'smart-booking-pro2'));
    }

    if (!isset($file['tmp_name']) || !is_uploaded_file($file['tmp_name'])) {
        wp_send_json_error(__('一時ファイルが見つかりません。', 'smart-booking-pro2'));
    }

    // ファイルを移動してアップロード  
    // Move and upload the file
    if (move_uploaded_file($file['tmp_name'], $target_file)) {
        wp_send_json_success($file_name);
    } else {
        wp_send_json_error(__('アップロードに失敗しました。', 'smart-booking-pro2'));
    }
}

add_action('wp_ajax_ers_upload_formdesign', 'ers_ajax_upload_formdesign');


// イベント投稿ごとのCSS適用  
// Apply CSS per event post
function ers_enqueue_event_styles() {
    if (is_singular('event-reservation')) {
        // プラグインのルートディレクトリとURLを取得  
        // Get plugin root directory and URL
        $plugin_dir = dirname(plugin_dir_path(__FILE__)); 
        $plugin_url = plugin_dir_url(dirname(__FILE__)); 

        // CSSフォルダのパスとURL
        $css_path = $plugin_dir . '/css/';
        $css_url = $plugin_url . 'css/';
        $reset_css_url = $plugin_url . 'assets/css/';

        //リセットCSSの読み込み
        wp_enqueue_style('ers-reset-css', $reset_css_url . 'reset.min.css', [], '1.0.0', 'all');
        wp_enqueue_style('ers-normalize-css', $reset_css_url . 'normalize.css', ['ers-reset-css'], '8.0.1', 'all');
        wp_enqueue_style('ers-bootstrap-css', $reset_css_url . 'bootstrap.min.css', ['ers-normalize-css'], '5.3.3', 'all');

        // 基本のCSSを適用  
        // Apply base CSS
        wp_enqueue_style('event-reservation-style', $css_url . 'event-reservation-style.css', array(), '1.0.0', 'all');

        // 投稿ごとに指定されたCSSファイルを取得  
        // Get the CSS file specified for each post
        $post_id = get_queried_object_id();
        $custom_css_file = get_post_meta($post_id, 'formdesign-css-file', true);

        // カスタムCSSファイルが指定されている場合のみ適用  
        // Apply only if a custom CSS file is specified
        if (!empty($custom_css_file) && preg_match('/^style-formdesign[a-zA-Z0-9_-]+\.css$/', $custom_css_file)) {
            $full_css_path = $css_path . $custom_css_file;
            $full_css_url = $css_url . $custom_css_file;

            if (file_exists($full_css_path)) {
                wp_enqueue_style('custom-formdesign-style', $full_css_url, array('event-reservation-style'), '1.0.0', 'all');
            }
        }
    }
}
add_action('wp_enqueue_scripts', 'ers_enqueue_event_styles');




// Singleテンプレート編集ページの処理（ページ全体）  
// Processing for Single template edit page (entire page)
function ers_template_editor_page() {

    // ✅ PRO／Enterprise 以外は利用制限ページに遷移  
    // ✅ Redirect to restriction page for non-PRO/Enterprise users
    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    // **プラグインフォルダ直下の `templates/singles/` を取得**  
    // **Get `templates/singles/` directly under the plugin folder**
    $template_dir = trailingslashit(dirname(__DIR__)) . 'templates/singles/'; // ✅ 修正

    // `templates/singles/` フォルダ内の `single-xxxxxxx.php` を取得  
    // Retrieve `single-xxxxxxx.php` files within the `templates/singles/` folder
    $template_files = glob($template_dir . 'single-*.php');
    $selected_template = isset($_POST['ers_template_file']) ? basename($_POST['ers_template_file']) : 'single-event-reservation.php';
    $template_file = $template_dir . $selected_template;

    // **ファイルが存在しない場合は作成**
    if (!file_exists($template_file)) {
        file_put_contents($template_file, "<?php\n// ここにテンプレートコードを記述\n?>");
    }

    // **フォーム送信処理（テンプレートの保存）**  
    // **Form submission processing (save template)**
    if (isset($_POST['ers_save_template'])) {

        check_admin_referer('ers_save_template_action');

        $new_template_code = isset($_POST['ers_custom_template']) ? stripslashes($_POST['ers_custom_template']) : '';

        if (empty($template_file) || !is_writable(dirname($template_file))) {
            echo '<div class="notice notice-error"><p>' . esc_html__('テンプレートの保存先が正しくありません。', 'smart-booking-pro2') . '</p></div>';
        } else {
            file_put_contents($template_file, $new_template_code);
            echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('テンプレートが保存されました！', 'smart-booking-pro2') . '</p></div>';
        }
    }


    // **選択されたファイルの内容を取得**  
    // **Retrieve the contents of the selected file**
    $template_content = file_get_contents($template_file);
    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('予約テンプレートの編集', 'smart-booking-pro2'); ?></h1>

        <!-- 🔹 アップロードフォーム -->  
        <!-- 🔹 Upload form -->
        <h2><?php echo esc_html__('テンプレートをアップロード', 'smart-booking-pro2'); ?></h2>
        <form id="ers-upload-form" enctype="multipart/form-data">
            <?php wp_nonce_field('ers_upload_template_action', 'ers_upload_nonce'); ?>
            <input type="file" name="template_file" id="ers-template-file" accept=".php">
            <button type="button" id="ers-upload-btn" class="button button-secondary">
                <?php echo esc_html__('アップロード', 'smart-booking-pro2'); ?>
            </button>
            <p id="ers-upload-result"></p>
        </form>
        <p><?php echo esc_html__('ファイル名ルール：single- で始まるファイルのみ表示（拡張子 .php）', 'smart-booking-pro2'); ?></p>

        <hr>

        <!-- 🔹 テンプレート選択＆編集 -->  
        <!-- 🔹 Template selection & editing -->
        <form method="post">
            <?php wp_nonce_field('ers_save_template_action'); ?>

            <label for="ers_template_file"><strong><?php echo esc_html__('編集するテンプレートを選択:', 'smart-booking-pro2'); ?></strong></label>
            <select name="ers_template_file" id="ers_template_file" onchange="this.form.submit();">
                <?php foreach ($template_files as $file): ?>
                    <?php $filename = basename($file); ?>
                    <option value="<?php echo esc_attr($filename); ?>" <?php selected($selected_template, $filename); ?>>
                        <?php echo esc_html($filename); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <noscript><input type="submit" value="<?php echo esc_attr__('選択', 'smart-booking-pro2'); ?>"></noscript>

            <br><br>
            <textarea name="ers_custom_template" rows="20" style="width:100%; font-family: monospace;"><?php echo esc_textarea($template_content); ?></textarea>
            <br><br>
            <input type="submit" name="ers_save_template" class="button button-primary" value="<?php echo esc_attr__('テンプレートを保存', 'smart-booking-pro2'); ?>">
        </form>
    </div>


        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const __ = wp.i18n.__;

                document.getElementById("ers-upload-btn").addEventListener("click", function() {
                    var fileInput = document.getElementById("ers-template-file").files[0];

                    if (!fileInput) {
                        alert(__('ファイルを選択してください', 'smart-booking-pro2'));
                        return;
                    }

                    if (fileInput.name.split('.').pop() !== "php") {
                        alert(__('アップロードできるのは PHP ファイルのみです', 'smart-booking-pro2'));
                        return;
                    }

                    var formData = new FormData();
                    formData.append("template_file", fileInput);
                    formData.append("action", "ers_upload_template");

                    var nonce = document.querySelector('input[name="ers_upload_nonce"]').value;
                    formData.append("ers_upload_nonce", nonce);

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", ajaxurl, true);

                    xhr.onload = function() {
                        const resultElem = document.getElementById("ers-upload-result");

                        if (xhr.status === 200) {
                            var response = JSON.parse(xhr.responseText);
                            if (response.success) {
                                resultElem.innerHTML = '<span style="color: green;">' + __('アップロード成功: ', 'smart-booking-pro2') + response.data + '</span>';
                                location.reload();
                            } else {
                                resultElem.innerHTML = '<span style="color: red;">' + __('エラー: ', 'smart-booking-pro2') + response.data + '</span>';
                            }
                        } else {
                            resultElem.innerHTML = '<span style="color: red;">' + __('サーバーエラー: ', 'smart-booking-pro2') + xhr.status + '</span>';
                        }
                    };

                    xhr.send(formData);
                });
            });
        </script>

    <?php
}

// AjaxでPHPファイルをアップロード  
// Upload PHP files via Ajax
function ers_ajax_upload_template() {

    // ✅ PRO／Enterprise 以外は利用制限ページに遷移  
    // ✅ Redirect to restriction page for non-PRO/Enterprise users
    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    check_ajax_referer('ers_upload_template_action', 'ers_upload_nonce');

    if (!isset($_FILES['template_file'])) {
        wp_send_json_error(__('ファイルが選択されていません。', 'smart-booking-pro2'));
    }

    $file = $_FILES['template_file'];
    $upload_dir = plugin_dir_path(__DIR__) . 'templates/singles/';

    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $file_name = sanitize_file_name($file['name']);
    $target_file = $upload_dir . $file_name;

    if (pathinfo($file_name, PATHINFO_EXTENSION) !== 'php') {
        wp_send_json_error(__('アップロードできるのは PHP ファイルのみです。', 'smart-booking-pro2'));
    }

    if (move_uploaded_file($file['tmp_name'], $target_file)) {
        wp_send_json_success($file_name);
    } else {
        wp_send_json_error(__('アップロードに失敗しました。', 'smart-booking-pro2'));
    }
}

add_action('wp_ajax_ers_upload_template', 'ers_ajax_upload_template');



// フォームテンプレート編集ページの内容  
// Content of the form template editing page
function ers_form_template_editor_page() {

    // ✅ PRO／Enterprise 以外は利用制限ページに遷移  
    // ✅ Redirect to restriction page for non-PRO/Enterprise users
    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    $template_dir = plugin_dir_path(__DIR__) . 'templates/forms/';

    // `templates/` フォルダ内の `form-template-xxxx.txt` を取得  
    // Retrieve `form-template-xxxx.txt` files within the `templates/` folder
    $template_files = glob($template_dir . 'form-template-*.txt');
    $selected_template = isset($_POST['ers_form_template_file']) ? basename($_POST['ers_form_template_file']) : 'form-template-default.txt';
    $template_file = $template_dir . $selected_template;

    // ファイルが存在しない場合は作成  
    // Create the file if it does not exist
    if (!file_exists($template_file)) {
        file_put_contents($template_file, "<!-- 新しいフォームテンプレート -->\n");
    }

    // フォーム送信処理（テンプレートの保存）  
    // Form submission processing (save template)
    if (isset($_POST['ers_save_form_template'])) {

        check_admin_referer('ers_save_form_template_action');

        $new_template_code = stripslashes($_POST['ers_custom_form_template']);
        file_put_contents($template_file, $new_template_code);

        echo '<div class="updated"><p>' . esc_html__('フォームテンプレートが保存されました！', 'smart-booking-pro2') . '</p></div>';
    }


    // 選択されたファイルの内容を取得  
    // Retrieve the contents of the selected file
    $template_content = file_get_contents($template_file);
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('フォームテンプレートの編集', 'smart-booking-pro2'); ?></h1>

        <!-- 🔹 アップロードフォーム -->  
        <!-- 🔹 Upload form -->
        <h2><?php esc_html_e('テンプレートをアップロード', 'smart-booking-pro2'); ?></h2>
        <form id="ers-form-upload-form" method="post" enctype="multipart/form-data">
            <?php wp_nonce_field('ers_upload_form_template_action', 'ers_upload_form_nonce'); ?>
            <input type="file" name="form_template_file" id="ers-form-template-file" accept=".txt">
            <button type="button" id="ers-form-upload-btn" class="button button-secondary">
                <?php esc_html_e('アップロード', 'smart-booking-pro2'); ?>
            </button>
            <p id="ers-form-upload-result"></p>
        </form>
        <p>
            <?php esc_html_e('ファイル名ルール：', 'smart-booking-pro2'); ?>
            <strong>form-template-xxxx.txt</strong>
            <?php esc_html_e(' のみ許可', 'smart-booking-pro2'); ?>
        </p>

        <hr>

        <!-- 🔹 テンプレート選択＆編集 -->  
        <!-- 🔹 Template selection & editing -->
        <form method="post">
            <?php wp_nonce_field('ers_save_form_template_action'); ?>

            <label for="ers_form_template_file">
                <strong><?php esc_html_e('編集するテンプレートを選択:', 'smart-booking-pro2'); ?></strong>
            </label>
            <select name="ers_form_template_file" id="ers_form_template_file" onchange="this.form.submit();">
                <?php foreach ($template_files as $file): ?>
                    <?php $filename = basename($file); ?>
                    <option value="<?php echo esc_attr($filename); ?>" <?php selected($selected_template, $filename); ?>>
                        <?php echo esc_html($filename); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <noscript><input type="submit" value="<?php esc_attr_e('選択', 'smart-booking-pro2'); ?>"></noscript>

            <br><br>
            <textarea name="ers_custom_form_template" rows="20" style="width:100%; font-family: monospace;"><?php echo esc_textarea($template_content); ?></textarea>
            <br><br>
            <input type="submit" name="ers_save_form_template" class="button button-primary"
                value="<?php esc_attr_e('テンプレートを保存', 'smart-booking-pro2'); ?>">
        </form>
    </div>


        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const __ = wp.i18n.__;

                document.getElementById("ers-form-upload-btn").addEventListener("click", function() {
                    var fileInput = document.getElementById("ers-form-template-file").files[0];

                    if (!fileInput) {
                        alert(__('ファイルを選択してください', 'smart-booking-pro2'));
                        return;
                    }

                    if (!fileInput.name.startsWith("form-template-") || fileInput.name.split('.').pop() !== "txt") {
                        alert(__('アップロードできるのは \'form-template-xxxx.txt\' のみです', 'smart-booking-pro2'));
                        return;
                    }

                    var formData = new FormData();
                    formData.append("form_template_file", fileInput);
                    formData.append("action", "ers_upload_form_template");

                    var nonce = document.querySelector('input[name="ers_upload_form_nonce"]').value;
                    formData.append("ers_upload_form_nonce", nonce);

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", ajaxurl, true);

                    xhr.onload = function() {
                        const resultElem = document.getElementById("ers-form-upload-result");

                        if (xhr.status === 200) {
                            var response = JSON.parse(xhr.responseText);
                            if (response.success) {
                                resultElem.innerHTML = '<span style="color: green;">' + __('アップロード成功: ', 'smart-booking-pro2') + response.data + '</span>';
                                location.reload();
                            } else {
                                resultElem.innerHTML = '<span style="color: red;">' + __('エラー: ', 'smart-booking-pro2') + response.data + '</span>';
                            }
                        } else {
                            resultElem.innerHTML = '<span style="color: red;">' + __('サーバーエラー: ', 'smart-booking-pro2') + xhr.status + '</span>';
                        }
                    };

                    xhr.send(formData);
                });
            });
        </script>

    <?php
}

// Ajaxでフォームテンプレートをアップロード  
// Upload form template via Ajax
function ers_ajax_upload_form_template() {

    // ✅ PRO／Enterprise 以外は利用制限ページに遷移  
    // ✅ Redirect to restriction page for non-PRO/Enterprise users
    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    check_ajax_referer('ers_upload_form_template_action', 'ers_upload_form_nonce');

    if (!isset($_FILES['form_template_file'])) {
        wp_send_json_error(__('ファイルが選択されていません。', 'smart-booking-pro2'));
    }

    $file = $_FILES['form_template_file'];
    $upload_dir = plugin_dir_path(__DIR__) . 'templates/forms/';

    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $file_name = sanitize_file_name($file['name']);
    $target_file = $upload_dir . $file_name;

    // アップロードできるファイル形式を制限  
    // Restrict allowed file upload types
    if (!preg_match('/^form-template-.*\.txt$/', $file_name)) {
        wp_send_json_error(__('アップロードできるのは form-template-xxxx.txt のみです。', 'smart-booking-pro2'));
    }

    // ファイルを移動してアップロード  
    // Move file and upload
    if (move_uploaded_file($file['tmp_name'], $target_file)) {
        wp_send_json_success($file_name);
    } else {
        wp_send_json_error(__('アップロードに失敗しました。', 'smart-booking-pro2'));
    }
}

add_action('wp_ajax_ers_upload_form_template', 'ers_ajax_upload_form_template');



// 送信確認メール編集ページの内容  
// Content of the confirmation email editing page
function ers_confirmation_email_editor_page() {

    $template_dir = plugin_dir_path(__DIR__) . 'templates/confirms/';

    // templates/ フォルダ内の "confirmation-email-" で始まり、拡張子が txt または html のファイルを取得  
    // Retrieve files starting with "confirmation-email-" and having txt or html extension within the templates/ folder
    $email_files_txt = glob($template_dir . 'confirmation-email*.txt');
    $email_files_html = glob($template_dir . 'confirmation-email*.html');

    // 両方の配列をマージ（どちらかが null の場合を考慮）  
    // Merge both arrays (considering the case where either is null)
    $email_files = array_merge(
        is_array($email_files_txt) ? $email_files_txt : array(),
        is_array($email_files_html) ? $email_files_html : array()
    );

    // デフォルトファイル名（存在しない場合は後で作成）  
    // Default file name (will be created later if it doesn't exist)
    $default_file = 'confirmation-email-txtdefault.txt';
    $selected_file = isset($_POST['ers_confirmation_email_file']) ? basename($_POST['ers_confirmation_email_file']) : $default_file;
    $file_path = $template_dir . $selected_file;

    if (!file_exists($file_path)) {
        $ext = pathinfo($selected_file, PATHINFO_EXTENSION);
        $default_content = ($ext === 'html') ? "<!-- ここにHTMLテンプレートコードを記述 -->" : "ここにテキストテンプレートを記述";
        file_put_contents($file_path, $default_content);
    }

    // フォーム送信処理（ファイルの保存）  
    // Form submission processing (save file)
    if (isset($_POST['ers_save_confirmation_email'])) {

        check_admin_referer('ers_save_confirmation_email_action');

        $new_content = stripslashes($_POST['ers_custom_confirmation_email']);
        file_put_contents($file_path, $new_content);

        echo '<div class="updated"><p>' . esc_html__('送信確認メールテンプレートが保存されました！', 'smart-booking-pro2') . '</p></div>';
    }


    // 選択されたファイルの内容を取得  
    // Retrieve the contents of the selected file
    $file_content = file_get_contents($file_path);
    ?>
    <div class="wrap">
        <h1>送信確認メールテンプレートの編集</h1>

        <?php
        $is_pro = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());
        ?>

        <h2><?php echo esc_html__('テンプレートをアップロード', 'smart-booking-pro2'); ?></h2>

        <form id="ers-confirmation-email-upload-form" enctype="multipart/form-data">
            <?php wp_nonce_field('ers_upload_confirmation_email_action', 'ers_confirmation_email_upload_nonce'); ?>

            <input
                type="file"
                name="confirmation_email_file"
                id="ers-confirmation-email-file"
                accept=".txt,.html"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >

            <button
                type="button"
                id="ers-confirmation-email-upload-btn"
                class="button button-secondary"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >
                <?php echo esc_html__('アップロード', 'smart-booking-pro2'); ?>
            </button>

            <p id="ers-confirmation-email-upload-result">
                <?php if (!$is_pro): ?>
                    <span style="color: red;">
                        <?php echo esc_html__('アップロード機能は PRO プラン以上でご利用いただけます。', 'smart-booking-pro2'); ?>
                    </span>
                <?php endif; ?>
            </p>
        </form>


        <p>
            <?php echo esc_html__('ファイル名ルール：confirmation-email で始まるファイル（拡張子 .txt .html）', 'smart-booking-pro2'); ?>
        </p>

        <hr>

        <!-- テンプレート選択＆編集 -->  
        <!-- Template selection & editing -->
        <form method="post">
            <?php wp_nonce_field('ers_save_confirmation_email_action'); ?>

            <label for="ers_confirmation_email_file">
                <strong><?php echo esc_html__('編集するファイルを選択:', 'smart-booking-pro2'); ?></strong>
            </label>

            <select name="ers_confirmation_email_file" id="ers_confirmation_email_file" onchange="this.form.submit();">
                <?php foreach ($email_files as $file): ?>
                    <?php $filename = basename($file); ?>
                    <option value="<?php echo esc_attr($filename); ?>" <?php selected($selected_file, $filename); ?>>
                        <?php echo esc_html($filename); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <noscript>
                <input type="submit" value="<?php echo esc_attr__('選択', 'smart-booking-pro2'); ?>">
            </noscript>

            <br><br>
                    <strong><?php echo esc_html__('テンプレートの1行目： Subject: で件名を指定できます。', 'smart-booking-pro2'); ?></strong>
            <br><br>
            <textarea name="ers_custom_confirmation_email" rows="20" style="width:100%; font-family: monospace;"><?php echo esc_textarea($file_content); ?></textarea>
            <br><br>
            <input type="submit" name="ers_save_confirmation_email" class="button button-primary" value="<?php echo esc_attr__('テンプレートを保存', 'smart-booking-pro2'); ?>">
        </form>

        <hr>

        <h2><?php echo esc_html__('使用可能なプレースホルダー', 'smart-booking-pro2'); ?></h2>

        <p><?php echo esc_html__('以下からデータベースを選択すると、そのデータに紐づくフィールドのプレースホルダーが表示されます。', 'smart-booking-pro2'); ?></p>

        <label for="acf_post_type_select">
            <strong><?php echo esc_html__('対象のデータベースを選択:', 'smart-booking-pro2'); ?></strong>
        </label>

        <?php
        $custom_post_types = ['reserved-daytime'];
        $saved_acf_data = get_option('smart_booking_acf_data', array());
        $saved_acf_db   = get_option('smart_booking_acf_db', array());

        if (!is_array($saved_acf_data)) $saved_acf_data = array();
        if (!is_array($saved_acf_db))   $saved_acf_db   = array();

        $merged_data = array_merge($saved_acf_data, $saved_acf_db);
        ?>

        <select id="acf_post_type_select" name="acf_post_type_select">
            <option value=""><?php echo esc_html__('-- データベースを選択 --', 'smart-booking-pro2'); ?></option>
            <option value="reserved-daytime"><?php echo esc_html__('予約済み日時', 'smart-booking-pro2'); ?></option>

            <?php foreach ($merged_data as $data): ?>
                <?php if (!empty($data['post_type'])):
                    $value = esc_attr($data['post_type']);
                    $label = isset($data['post_type_label']) ? esc_html($data['post_type_label']) : $value;
                ?>
                    <option value="<?php echo $value; ?>"><?php echo $label; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>

        <div id="acf-placeholder-preview" style="margin-top: 16px;">
            <p style="color:#666;"><?php echo esc_html__('データベースを選択すると、使用可能なプレースホルダーがここに表示されます。', 'smart-booking-pro2'); ?></p>
        </div>

    </div>

    <?php
    $is_pro_or_higher = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());
    ?>
    <script>
        const SBP2_IS_PRO_OR_HIGHER = <?php echo $is_pro_or_higher ? 'true' : 'false'; ?>;
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const { __ } = wp.i18n;

            const uploadBtn   = document.getElementById("ers-confirmation-email-upload-btn");
            const uploadInput = document.getElementById("ers-confirmation-email-file");
            const resultBox   = document.getElementById("ers-confirmation-email-upload-result");

            if (!SBP2_IS_PRO_OR_HIGHER) {
                if (uploadBtn) {
                    uploadBtn.disabled = true;
                    uploadBtn.style.opacity = "0.6";
                    uploadBtn.title = __("PRO プラン以上で有効になります", "smart-booking-pro2");
                }

                if (uploadInput) {
                    uploadInput.disabled = true;
                    uploadInput.style.opacity = "0.6";
                    uploadInput.title = __("PRO プラン以上でファイル選択が可能です", "smart-booking-pro2");
                }

                if (resultBox) {
                    resultBox.innerHTML = '<span style="color: red;">' +
                        __("アップロード機能は PRO プラン以上でご利用いただけます。", "smart-booking-pro2") +
                        '</span>';
                }

                return;
            }

            uploadBtn?.addEventListener("click", function () {
                const fileInput = uploadInput?.files[0];
                if (!fileInput) {
                    alert(__("ファイルを選択してください", "smart-booking-pro2"));
                    return;
                }

                const ext = fileInput.name.split('.').pop().toLowerCase();
                if (ext !== "txt" && ext !== "html") {
                    alert(__("アップロードできるのは TXT または HTML ファイルのみです", "smart-booking-pro2"));
                    return;
                }

                const formData = new FormData();
                formData.append("confirmation_email_file", fileInput);
                formData.append("action", "ers_upload_confirmation_email");
                const nonce = document.querySelector('input[name="ers_confirmation_email_upload_nonce"]').value;
                formData.append("ers_confirmation_email_upload_nonce", nonce);

                const xhr = new XMLHttpRequest();
                xhr.open("POST", ajaxurl, true);

                xhr.onload = function () {
                    if (xhr.status === 200) {
                        const response = JSON.parse(xhr.responseText);
                        if (response.success) {
                            resultBox.innerHTML = '<span style="color: green;">' +
                                __("アップロード成功:", "smart-booking-pro2") + ' ' + response.data +
                                '</span>';
                            location.reload();
                        } else {
                            resultBox.innerHTML = '<span style="color: red;">' +
                                __("エラー:", "smart-booking-pro2") + ' ' + response.data +
                                '</span>';
                        }
                    }
                };

                xhr.send(formData);
            });
        });


    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const select = document.getElementById("acf_post_type_select");
            const preview = document.getElementById("acf-placeholder-preview");

            function updatePlaceholders(postType) {
                preview.innerHTML = '<p style="color:#999;"><?php echo esc_js(__('読み込み中...', 'smart-booking-pro2')); ?></p>';

                const formData = new FormData();
                formData.append('action', 'get_acf_placeholders');
                formData.append('post_type', postType);

                fetch(ajaxurl, {
                    method: 'POST',
                    body: formData
                })
                .then(res => res.json())
                .then(json => {
                    if (!json.success || !Array.isArray(json.data)) {
                        preview.innerHTML = '<p style="color:red;">' + (json.data || '<?php echo esc_js(__('データが取得できませんでした。', 'smart-booking-pro2')); ?>') + '</p>';
                        return;
                    }

                    const rows = [];
                    const items = json.data;
                    for (let i = 0; i < items.length; i += 2) {
                        const col1 = items[i];
                        const col2 = items[i + 1] || null;

                        rows.push(
                            `<tr>
                                <td><strong>${col1.label}</strong></td><td><code>${col1.placeholder}</code></td>` +
                                (col2 ? `<td><strong>${col2.label}</strong></td><td><code>${col2.placeholder}</code></td>` : '<td colspan="2"></td>') +
                            `</tr>`
                        );
                    }

                    preview.innerHTML = `
                        <table class="widefat striped">
                            <thead>
                                <tr>
                                    <th><?php echo esc_js(__('項目名', 'smart-booking-pro2')); ?></th>
                                    <th><?php echo esc_js(__('プレースホルダー', 'smart-booking-pro2')); ?></th>
                                    <th><?php echo esc_js(__('項目名', 'smart-booking-pro2')); ?></th>
                                    <th><?php echo esc_js(__('プレースホルダー', 'smart-booking-pro2')); ?></th>
                                </tr>
                            </thead>
                            <tbody>${rows.join('')}</tbody>
                        </table>
                    `;
                })
                .catch(() => {
                    preview.innerHTML = '<p style="color:red;"><?php echo esc_js(__('エラーが発生しました。', 'smart-booking-pro2')); ?></p>';
                });
            }

            select?.addEventListener("change", function () {
                const val = this.value;
                if (val) updatePlaceholders(val);
                else preview.innerHTML = '<p style="color:#666;"><?php echo esc_js(__('データベースを選択すると、使用可能なプレースホルダーがここに表示されます。', 'smart-booking-pro2')); ?></p>';
            });

            // 初期表示用（初期選択がある場合）  
            // For initial display (when there is an initial selection)
            if (select?.value) {
                updatePlaceholders(select.value);
            }
        });
    </script>


    <?php
}


// AjaxでTXT/HTMLファイルをアップロード  
// Upload TXT/HTML files via Ajax
function ers_ajax_upload_email() {
    // ✅ PRO／Enterprise 以外は利用制限ページに遷移  
    // ✅ Redirect to restriction page for non-PRO/Enterprise users
    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    check_ajax_referer('ers_upload_confirmation_email_action', 'ers_confirmation_email_upload_nonce');


    if (!isset($_FILES['confirmation_email_file'])) {
        wp_send_json_error(__('ファイルが選択されていません。', 'smart-booking-pro2'));
    }

    $file = $_FILES['confirmation_email_file'];
    $upload_dir = plugin_dir_path(__DIR__) . 'templates/confirms/';

    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $file_name = sanitize_file_name($file['name']);
    $target_file = $upload_dir . $file_name;
    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

    // アップロード可能な拡張子を制限  
    // Restrict allowed upload file extensions
    if (!in_array($ext, array('txt', 'html'))) {
        wp_send_json_error(__('アップロードできるのは TXT または HTML ファイルのみです。', 'smart-booking-pro2'));
    }

    // ファイルを移動してアップロード  
    // Move and upload the file
    if (move_uploaded_file($file['tmp_name'], $target_file)) {
        wp_send_json_success($file_name);
    } else {
        wp_send_json_error(__('アップロードに失敗しました。', 'smart-booking-pro2'));
    }
}

add_action('wp_ajax_ers_upload_confirmation_email', 'ers_ajax_upload_email');


// リマインダー編集ページの内容  
// Content of the reminder editing page
function ers_remainder_editor_page() {


    $template_dir = plugin_dir_path(__DIR__) . 'templates/reminders/';

    // templates/フォルダ内の "reminder-reservation" で始まり、拡張子が txt のファイルを取得  
    // Retrieve files starting with "reminder-reservation" and with a txt extension in the templates/ folder
    $remainder_files_txt = glob($template_dir . 'remainder-reservation*.txt');
    $remainder_files_html = glob($template_dir . 'remainder-reservation*.html');

    // 両方の配列をマージ  
    // Merge both arrays
    $remainder_files = array_merge(
        is_array($remainder_files_txt) ? $remainder_files_txt : array(),
        is_array($remainder_files_html) ? $remainder_files_html : array()
    );

    $default_file = 'remainder-reservation.txt';
    $selected_file = isset($_POST['ers_remainder_file']) ? basename($_POST['ers_remainder_file']) : $default_file;
    $file_path = $template_dir . $selected_file;

    // ファイルが存在しない場合は作成  
    // Create the file if it does not exist
    if (!file_exists($file_path)) {
        $ext = pathinfo($selected_file, PATHINFO_EXTENSION);
        $default_content = ($ext === 'html') ? "<!-- ここにHTMLテンプレートコードを記述 -->" : "ここにテキストテンプレートを記述";
        file_put_contents($file_path, $default_content);
    }

    // フォーム送信処理（ファイルの保存）  
    // Form submission processing (save file)
    if (isset($_POST['ers_save_remainder'])) {
        check_admin_referer('ers_save_remainder_action');

        $new_content = stripslashes($_POST['ers_custom_remainder']);
        file_put_contents($file_path, $new_content);

        echo '<div class="updated"><p>' . esc_html__('リマインダーが保存されました！', 'smart-booking-pro2') . '</p></div>';
    }


    // 選択されたファイルの内容を取得  
    // Retrieve the contents of the selected file
    $file_content = file_get_contents($file_path);
    ?>
    <div class="wrap">
        <h1><?php echo esc_html__('リマインダーテンプレートの編集', 'smart-booking-pro2'); ?></h1>

        <?php
        $is_pro = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());

        // ✅ JavaScriptに渡す変数をここで出力  
        // ✅ Output variables to pass to JavaScript here
        echo '<script>const SBP2_IS_PRO_OR_HIGHER = ' . ($is_pro ? 'true' : 'false') . ';</script>';
        ?>

        <!-- ファイルアップロード機能 -->  
        <!-- File upload feature -->
        <h2><?php echo esc_html__('テンプレートをアップロード', 'smart-booking-pro2'); ?></h2>

        <form id="ers-remainder-upload-form" enctype="multipart/form-data">
            <?php wp_nonce_field('ers_upload_remainder_action', 'ers_remainder_upload_nonce'); ?>

            <input
                type="file"
                name="remainder_file"
                id="ers-remainder-file"
                accept=".txt,.html"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >

            <button
                type="button"
                id="ers-remainder-upload-btn"
                class="button button-secondary"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >
                <?php echo esc_html__('アップロード', 'smart-booking-pro2'); ?>
            </button>

            <p id="ers-remainder-upload-result">
                <?php if (!$is_pro): ?>
                    <span style="color: red;"><?php echo esc_html__('アップロード機能は PRO プラン以上でご利用いただけます。', 'smart-booking-pro2'); ?></span>
                <?php endif; ?>
            </p>
        </form>

        <p><?php echo esc_html__('ファイル名ルール：remainder-reservation で始まるファイル（拡張子 .txt .html）', 'smart-booking-pro2'); ?></p>


        <hr>

        <!-- テスト送信用フォーム -->  
        <!-- Test submission form -->
        <h2><?php echo esc_html__('リマインダーのテスト送信', 'smart-booking-pro2'); ?></h2>

        <form id="ers-remainder-test-form">
            <?php wp_nonce_field('ers_send_test_reminder_action', 'ers_test_reminder_nonce'); ?>

            <input
                type="email"
                name="test_email"
                id="ers-test-email"
                placeholder="<?php echo esc_attr__('送信先メールアドレスを入力', 'smart-booking-pro2'); ?>"
                required
            >

            <input
                type="hidden"
                name="test_template"
                value="<?php echo esc_attr($selected_file); ?>"
            >

            <button
                type="button"
                id="ers-remainder-test-btn"
                class="button button-secondary"
            >
                <?php echo esc_html__('テスト送信', 'smart-booking-pro2'); ?>
            </button>

            <p id="ers-remainder-test-result"></p>
        </form>

        <hr>

        <!-- テンプレート選択＆編集 -->
        <form method="post">
            <?php wp_nonce_field('ers_save_remainder_action'); ?>

            <label for="ers_remainder_file">
                <strong><?php echo esc_html__('編集するファイルを選択:', 'smart-booking-pro2'); ?></strong>
            </label>

            <select name="ers_remainder_file" id="ers_remainder_file" onchange="this.form.submit();">
                <?php foreach ($remainder_files as $file): ?>
                    <?php $filename = basename($file); ?>
                    <option value="<?php echo esc_attr($filename); ?>" <?php selected($selected_file, $filename); ?>>
                        <?php echo esc_html($filename); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <noscript>
                <input type="submit" value="<?php echo esc_attr__('選択', 'smart-booking-pro2'); ?>">
            </noscript>

            <br><br>
                    <strong><?php echo esc_html__('テンプレートの1行目： Subject: で件名を指定できます。', 'smart-booking-pro2'); ?></strong>
            <br><br>

            <textarea
                name="ers_custom_remainder"
                rows="20"
                style="width:100%; font-family: monospace;"
            ><?php echo esc_textarea($file_content); ?></textarea>

            <br><br>

            <input
                type="submit"
                name="ers_save_remainder"
                class="button button-primary"
                value="<?php echo esc_attr__('テンプレートを保存', 'smart-booking-pro2'); ?>"
            >
        </form>


        <hr>

        <?php

        // 予約データの最新IDを取得（1つだけ取得して、そこからACFフィールドを取得）
        // Get the latest reservation data ID (retrieve only one and then get the ACF field from it)
        $latest_reservation = get_posts([
            'post_type'      => 'reserved-daytime',
            'post_status'    => 'any',
            'posts_per_page' => 1,
            'orderby'        => 'date',
            'order'          => 'DESC'
        ]);

        $placeholder_list = [];

        if (!empty($latest_reservation)) {
            $post_id = $latest_reservation[0]->ID;
            $custom_fields = get_fields($post_id);
            
            if ($custom_fields) {
                foreach ($custom_fields as $key => $value) {
                    // ハイフンをアンダースコアに変換  
                    // Convert hyphens to underscores
                    $formatted_key = str_replace('-', '_', $key ?? '');

                    // ACFのフィールドオブジェクトを取得（フィールドラベルを得るため）  
                    // Get ACF field object (to obtain field label)
                    $field_object = get_field_object($key, $post_id);
                    if (is_array($field_object) && isset($field_object['label'])) {
                        $field_label = esc_html($field_object['label']);
                    } else {
                        $field_label = esc_html($key);
                    }

                    $placeholder_list[] = "<td><strong>{$field_label}</strong></td><td><code>{".esc_html($formatted_key)."}</code></td>";
                }
            }
        }

        ?>

        <h2><?php echo esc_html__('使用可能なプレースホルダー', 'smart-booking-pro2'); ?></h2>

        <p><?php echo esc_html__('以下からデータベースを選択すると、そのデータに紐づくフィールドのプレースホルダーが表示されます。', 'smart-booking-pro2'); ?></p>

        <label for="acf_post_type_select">
            <strong><?php echo esc_html__('対象のデータベースを選択:', 'smart-booking-pro2'); ?></strong>
        </label>

        <?php
        $custom_post_types = ['reserved-daytime'];
        $saved_acf_data = get_option('smart_booking_acf_data', array());
        $saved_acf_db   = get_option('smart_booking_acf_db', array());

        if (!is_array($saved_acf_data)) $saved_acf_data = array();
        if (!is_array($saved_acf_db))   $saved_acf_db   = array();

        $merged_data = array_merge($saved_acf_data, $saved_acf_db);
        ?>

        <select id="acf_post_type_select" name="acf_post_type_select">
            <option value=""><?php echo esc_html__('-- データベースを選択 --', 'smart-booking-pro2'); ?></option>
            <option value="reserved-daytime"><?php echo esc_html__('予約済み日時', 'smart-booking-pro2'); ?></option>

            <?php foreach ($merged_data as $data): ?>
                <?php if (!empty($data['post_type']) && $data['post_type'] !== 'reserved-daytime'):
                    $value = esc_attr($data['post_type']);
                    $label = isset($data['post_type_label']) ? esc_html($data['post_type_label']) : $value;
                ?>
                    <option value="<?php echo $value; ?>"><?php echo $label; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>

        <div id="acf-placeholder-preview" style="margin-top: 16px;">
            <p style="color:#666;"><?php echo esc_html__('データベースを選択すると、使用可能なプレースホルダーがここに表示されます。', 'smart-booking-pro2'); ?></p>
        </div>


        
    </div>

        <?php if (sbp2_is_pro_user() || sbp2_is_enterprise_user()) : ?>
        <script>
            document.addEventListener("DOMContentLoaded", function () {

                // ✅ リマインダーのテスト送信  
                // ✅ Test sending reminder
                const testBtn = document.getElementById("ers-remainder-test-btn");
                if (testBtn) {
                    testBtn.addEventListener("click", function () {
                        const email = document.getElementById("ers-test-email").value;
                        const template = document.querySelector('input[name="test_template"]').value;
                        const nonce = document.querySelector('input[name="ers_test_reminder_nonce"]').value;

                        if (!email) {
                            alert(<?php echo json_encode(__('送信先メールアドレスを入力してください', 'smart-booking-pro2')); ?>);
                            return;
                        }

                        const formData = new FormData();
                        formData.append("action", "ers_send_test_reminder");
                        formData.append("test_email", email);
                        formData.append("test_template", template);
                        formData.append("ers_test_reminder_nonce", nonce);

                        fetch(ajaxurl, {
                            method: "POST",
                            body: formData
                        })
                        .then(response => response.json())
                        .then(data => {
                            const result = document.getElementById("ers-remainder-test-result");
                            if (data.success) {
                                result.innerHTML = '<span style="color: green;"><?php echo esc_js(__('送信成功！', 'smart-booking-pro2')); ?></span>';
                            } else {
                                result.innerHTML = '<span style="color: red;"><?php echo esc_js(__('エラー:', 'smart-booking-pro2')); ?> ' + data.data + '</span>';
                            }
                        });
                    });
                }

                // ✅ アップロード処理
                const uploadBtn = document.getElementById("ers-remainder-upload-btn");
                const fileInput = document.getElementById("ers-remainder-file");
                const resultBox = document.getElementById("ers-remainder-upload-result");

                if (typeof SBP2_IS_PRO_OR_HIGHER !== "undefined" && !SBP2_IS_PRO_OR_HIGHER) {
                    uploadBtn.disabled = true;
                    fileInput.disabled = true;

                    uploadBtn.style.opacity = "0.5";
                    uploadBtn.style.pointerEvents = "none";
                    fileInput.style.opacity = "0.5";

                    if (resultBox) {
                        resultBox.innerHTML = '<span style="color: red;"><?php echo esc_js(__('アップロード機能は PRO プラン以上でご利用いただけます。', 'smart-booking-pro2')); ?></span>';
                    }
                    return;
                }

                uploadBtn.addEventListener("click", function () {
                    const file = fileInput.files[0];

                    if (!file) {
                        alert(<?php echo json_encode(__('ファイルを選択してください', 'smart-booking-pro2')); ?>);
                        return;
                    }

                    const ext = file.name.split('.').pop().toLowerCase();
                    if (ext !== "txt" && ext !== "html") {
                        alert(<?php echo json_encode(__('アップロードできるのは TXT または HTML ファイルのみです', 'smart-booking-pro2')); ?>);
                        return;
                    }

                    const formData = new FormData();
                    formData.append("remainder_file", file);
                    formData.append("action", "ers_upload_remainder");

                    const nonce = document.querySelector('input[name="ers_remainder_upload_nonce"]').value;
                    formData.append("ers_remainder_upload_nonce", nonce);

                    fetch(ajaxurl, {
                        method: "POST",
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            resultBox.innerHTML = '<span style="color: green;"><?php echo esc_js(__('アップロード成功:', 'smart-booking-pro2')); ?> ' + data.data + '</span>';
                            location.reload();
                        } else {
                            resultBox.innerHTML = '<span style="color: red;"><?php echo esc_js(__('エラー:', 'smart-booking-pro2')); ?> ' + data.data + '</span>';
                        }
                    });
                });
            });
        </script>

        <?php endif; ?>


         <script>
            document.addEventListener('DOMContentLoaded', function () {
                const select = document.getElementById('acf_post_type_select');
                const container = document.getElementById('acf-placeholder-preview');

                if (!select || !container) return;

                select.addEventListener('change', function () {
                    const postType = select.value;
                    if (!postType) {
                        container.innerHTML = `<p style="color:#666;"><?php echo esc_js(__('データベースを選択すると、使用可能なプレースホルダーがここに表示されます。', 'smart-booking-pro2')); ?></p>`;
                        return;
                    }

                    container.innerHTML = `<p><?php echo esc_js(__('読み込み中...', 'smart-booking-pro2')); ?></p>`;

                    fetch(ajaxurl, {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: new URLSearchParams({
                            action: 'get_acf_placeholders',
                            post_type: postType
                        })
                    })
                    .then(res => res.json())
                    .then(json => {
                        if (!json.success || !Array.isArray(json.data) || json.data.length === 0) {
                            container.innerHTML = `<p style="color:#c00;"><?php echo esc_js(__('プレースホルダーが見つかりませんでした。', 'smart-booking-pro2')); ?></p>`;
                            return;
                        }

                        const placeholders = json.data;
                        let html = `
                            <div class="postbox" style="margin-top: 20px;">
                                <h2 class="hndle">
                                    <span><?php echo esc_js(__('使用できるプレースホルダー一覧', 'smart-booking-pro2')); ?></span>
                                </h2>
                                <div class="inside">
                                    <table class="widefat">
                                        <thead>
                                            <tr>
                                                <th><?php echo esc_js(__('項目名', 'smart-booking-pro2')); ?></th>
                                                <th><?php echo esc_js(__('プレースホルダー', 'smart-booking-pro2')); ?></th>
                                                <th><?php echo esc_js(__('項目名', 'smart-booking-pro2')); ?></th>
                                                <th><?php echo esc_js(__('プレースホルダー', 'smart-booking-pro2')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                        `;

                        for (let i = 0; i < placeholders.length; i += 2) {
                            html += '<tr>';
                            for (let j = 0; j < 2; j++) {
                                const item = placeholders[i + j];
                                if (item) {
                                    html += `<td>${item.label}</td><td><code>${item.placeholder}</code></td>`;
                                } else {
                                    html += '<td></td><td></td>';
                                }
                            }
                            html += '</tr>';
                        }

                        html += `
                                        </tbody>
                                    </table>
                                    <p style="margin-top: 10px;">
                                        <strong><?php echo esc_js(__('例：', 'smart-booking-pro2')); ?></strong>
                                        <code>{event_name}</code> →
                                        <?php echo esc_js(__('「イベント名」に変換', 'smart-booking-pro2')); ?>
                                    </p>
                                </div>
                            </div>
                        `;

                        container.innerHTML = html;
                    })
                    .catch(err => {
                        console.error('AJAX Error:', err);
                        container.innerHTML = `<p style="color:#c00;"><?php echo esc_js(__('エラーが発生しました。', 'smart-booking-pro2')); ?></p>`;
                    });
                });
            });

         </script>
    <?php

}

// AJAXでリマインダーをテスト送信する処理  
// Process to test send reminder via AJAX
function ers_send_test_reminder() {

    if (
        !isset($_POST['ers_test_reminder_nonce']) ||
        !wp_verify_nonce($_POST['ers_test_reminder_nonce'], 'ers_send_test_reminder_action')
    ) {
        wp_send_json_error(esc_html__('不正なリクエストです。', 'smart-booking-pro2'));
    }


    $test_email = sanitize_email($_POST['test_email']);
    $template_name = sanitize_text_field($_POST['test_template']);
    $template_dir = plugin_dir_path(__DIR__) . 'templates/reminders/';
    $template_path = $template_dir . $template_name;

    if (!file_exists($template_path)) {
        wp_send_json_error(esc_html__('テンプレートが見つかりません。', 'smart-booking-pro2'));
    }

    // Content-Type の判定  
    // Content-Type determination
    $extension = pathinfo($template_path, PATHINFO_EXTENSION);
    $content_type = ($extension === 'html') ? 'text/html' : 'text/plain';
    $headers = ['Content-Type: ' . $content_type . '; charset=UTF-8'];

    // メール本文の読み込み  
    // Load email body content
    $message = file_get_contents($template_path);
    $message = mb_convert_encoding($message, 'UTF-8', mb_detect_encoding($message, 'UTF-8, SJIS, EUC-JP, JIS, ASCII', true));

    // 件名の抽出  
    // Extract subject
    $subject = esc_html__('【テスト送信】リマインダー', 'smart-booking-pro2');
    if (preg_match('/^Subject:\s*(.+)/m', $message, $matches)) {
        $subject = trim($matches[1]);
        $message = preg_replace('/^Subject:\s*(.+)\n/m', '', $message);
    }


    // プレースホルダーの置換  
    // Placeholder replacement
    $placeholders = [
        '{event_name}'           => esc_html__('テストイベント', 'smart-booking-pro2'),
        '{reserved_user_name}'  => esc_html__('テストユーザー', 'smart-booking-pro2'),
        '{reserved_day}'        => date('Y-m-d'),
        '{reserved_time}'       => date('H:i'),
        '{reserved_user_email}' => 'test@example.com',
        '{reserved_phone}'      => '000-0000-0000',
        '{reserved_message}'    => esc_html__('テストメッセージ', 'smart-booking-pro2')
    ];


    $formatted_placeholders = [];
    foreach ($placeholders as $key => $value) {
        $formatted_key = str_replace('-', '_', $key ?? '');

        $formatted_placeholders[$formatted_key] = $value;
    }

    $message = str_replace(array_keys($formatted_placeholders), array_values($formatted_placeholders), $message ?? '');
    $subject = str_replace(array_keys($formatted_placeholders), array_values($formatted_placeholders), $subject ?? '');


    // メール送信
    if (wp_mail($test_email, $subject, $message, $headers)) {
        wp_send_json_success(esc_html__('送信成功', 'smart-booking-pro2'));
    } else {
        wp_send_json_error(esc_html__('送信に失敗しました', 'smart-booking-pro2'));
    }

}
add_action('wp_ajax_ers_send_test_reminder', 'ers_send_test_reminder');


// AjaxでTXT/HTMLファイルをアップロード  
// Upload TXT/HTML files via Ajax
function ers_ajax_upload_remainder() {

    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    check_ajax_referer('ers_upload_remainder_action', 'ers_remainder_upload_nonce');

    if (!isset($_FILES['remainder_file'])) {
        wp_send_json_error(esc_html__('ファイルが選択されていません。', 'smart-booking-pro2'));
    }

    $file = $_FILES['remainder_file'];
    $upload_dir = plugin_dir_path(__DIR__) . 'templates/reminders/';

    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $file_name = sanitize_file_name($file['name']);
    $target_file = $upload_dir . $file_name;
    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

    if (!in_array($ext, array('txt', 'html'))) {
        wp_send_json_error(esc_html__('アップロードできるのは TXT または HTML ファイルのみです。', 'smart-booking-pro2'));
    }

    if (move_uploaded_file($file['tmp_name'], $target_file)) {
        wp_send_json_success($file_name);
    } else {
        wp_send_json_error(esc_html__('アップロードに失敗しました。', 'smart-booking-pro2'));
    }
}

add_action('wp_ajax_ers_upload_remainder', 'ers_ajax_upload_remainder');


// 削除メッセージ  
// Delete message
add_action('admin_notices', function () {
    if (!isset($_GET['page']) || $_GET['page'] !== 'smart_booking_db') {
        return;
    }

        echo '<div class="notice notice-warning is-dismissible">';
        echo '<p><strong>' . esc_html__('【ご注意】', 'smart-booking-pro2') . '</strong> ';
        echo esc_html__('作成されたデータベースは、ステータス画面で削除設定ができます。', 'smart-booking-pro2') . '<br>';
        echo esc_html__('再インストール時に利用する場合は、チェックを外してからご利用ください。', 'smart-booking-pro2') . '</p>';
        echo '</div>';
});


// thanksページの編集  
// Edit thanks page
function ers_thanks_page_editor_page() {

    $template_dir = plugin_dir_path(__DIR__) . 'templates/thanks/';

    // templates/ フォルダ内の "page-thanks" で始まり、拡張子が txt または html のファイルを取得  
    // Retrieve files starting with "page-thanks" and having txt or html extension within the templates/ folder
    $email_files_php = glob($template_dir . 'page-thanks*.php');
    $email_files_html = glob($template_dir . 'page-thanks*.html');

    // 両方の配列をマージ（どちらかが null の場合を考慮）  
    // Merge both arrays (considering the case where either is null)
    $email_files = array_merge(
        is_array($email_files_php) ? $email_files_php : array(),
        is_array($email_files_html) ? $email_files_html : array()
    );

    $default_file = 'page-thanks.php';
    $selected_file = isset($_POST['ers_thanks_page_file']) ? basename($_POST['ers_thanks_page_file']) : $default_file;
    $file_path = $template_dir . $selected_file;

    // フォーム送信処理（ファイルの保存）  
    // Form submission processing (save file)
    if (isset($_POST['ers_save_thanks_page'])) {

        check_admin_referer('ers_save_thanks_page_action');

        $new_content = stripslashes($_POST['ers_custom_thanks_page']);
        file_put_contents($file_path, $new_content);

        echo '<div class="updated"><p>' . esc_html__('thanks pageテンプレートが保存されました！', 'smart-booking-pro2') . '</p></div>';
    }


    // 選択されたファイルの内容を取得  
    // Retrieve the contents of the selected file
    $file_content = file_exists($file_path) ? file_get_contents($file_path) : '';

    ?>
    <div class="wrap">
        <h1>サンクスページテンプレートの編集</h1>

        <?php
        $is_pro = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());
        ?>

        <!-- アップロードフォーム -->
        <h2><?php echo esc_html__('テンプレートをアップロード', 'smart-booking-pro2'); ?></h2>

        <form id="ers-thanks_page-upload-form" enctype="multipart/form-data">
            <?php wp_nonce_field('ers_upload_thanks_page_action', 'ers_thanks_page_upload_nonce'); ?>

            <input
                type="file"
                name="thanks_page_file"
                id="ers-thanks_page-file"
                accept=".php,.html"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >

            <button
                type="button"
                id="ers-thanks_page-upload-btn"
                class="button button-secondary"
                <?php echo $is_pro ? '' : 'disabled'; ?>
            >
                <?php echo esc_html__('アップロード', 'smart-booking-pro2'); ?>
            </button>

            <p id="ers-thanks_page-upload-result">
                <?php if (!$is_pro): ?>
                    <span style="color: red;">
                        <?php echo esc_html__('アップロード機能は PRO プラン以上でご利用いただけます。', 'smart-booking-pro2'); ?>
                    </span>
                <?php endif; ?>
            </p>
        </form>


        <p>
            <?php echo esc_html__('ファイル名ルール：page-thanks で始まるファイル（拡張子 .php .html）', 'smart-booking-pro2'); ?>
        </p>

        <hr>

        <form method="post">
            <?php wp_nonce_field('ers_save_thanks_page_action'); ?>

            <label for="ers_thanks_page_file">
                <strong><?php echo esc_html__('編集するファイルを選択:', 'smart-booking-pro2'); ?></strong>
            </label>

            <select name="ers_thanks_page_file" id="ers_thanks_page_file" onchange="this.form.submit();">
                <?php foreach ($email_files as $file): ?>
                    <?php $filename = basename($file); ?>
                    <option value="<?php echo esc_attr($filename); ?>" <?php selected($selected_file, $filename); ?>>
                        <?php echo esc_html($filename); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <noscript>
                <input type="submit" value="<?php echo esc_attr__('選択', 'smart-booking-pro2'); ?>">
            </noscript>

            <br><br>
            <textarea name="ers_custom_thanks_page" rows="20" style="width:100%; font-family: monospace;"><?php echo esc_textarea($file_content); ?></textarea>
            <br><br>
            <input type="submit" name="ers_save_thanks_page" class="button button-primary" value="<?php echo esc_attr__('テンプレートを保存', 'smart-booking-pro2'); ?>">
        </form>

        <hr>

    </div>

    <?php
    $is_pro_or_higher = function_exists('sbp2_is_pro_user') && (sbp2_is_pro_user() || sbp2_is_enterprise_user());
    ?>
    <script>
        const SBP2_IS_PRO_OR_HIGHER = <?php echo $is_pro_or_higher ? 'true' : 'false'; ?>;
    </script>


    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const { __ } = wp.i18n;

            const uploadBtn   = document.getElementById("ers-thanks_page-upload-btn");
            const uploadInput = document.getElementById("ers-thanks_page-file");
            const resultBox   = document.getElementById("ers-thanks_page-upload-result");

            if (!SBP2_IS_PRO_OR_HIGHER) {
                if (uploadBtn) {
                    uploadBtn.disabled = true;
                    uploadBtn.style.opacity = "0.6";
                    uploadBtn.title = __("PRO プラン以上で有効になります", "smart-booking-pro2");
                }

                if (uploadInput) {
                    uploadInput.disabled = true;
                    uploadInput.style.opacity = "0.6";
                    uploadInput.title = __("PRO プラン以上でファイル選択が可能です", "smart-booking-pro2");
                }

                if (resultBox) {
                    resultBox.innerHTML = '<span style="color: red;">' +
                        __("アップロード機能は PRO プラン以上でご利用いただけます。", "smart-booking-pro2") +
                        '</span>';
                }

                return;
            }

            uploadBtn?.addEventListener("click", function () {
                const fileInput = uploadInput?.files[0];
                if (!fileInput) {
                    alert(__("ファイルを選択してください", "smart-booking-pro2"));
                    return;
                }

                const ext = fileInput.name.split('.').pop().toLowerCase();
                if (ext !== "php" && ext !== "html") {
                    alert(__("アップロードできるのは php または HTML ファイルのみです", "smart-booking-pro2"));
                    return;
                }

                const formData = new FormData();
                formData.append("thanks_page_file", fileInput);
                formData.append("action", "ers_upload_thanks_page");
                const nonce = document.querySelector('input[name="ers_thanks_page_upload_nonce"]').value;
                formData.append("ers_thanks_page_upload_nonce", nonce);

                const xhr = new XMLHttpRequest();
                xhr.open("POST", ajaxurl, true);

                xhr.onload = function () {
                    if (xhr.status === 200) {
                        const response = JSON.parse(xhr.responseText);
                        if (response.success) {
                            resultBox.innerHTML = '<span style="color: green;">' +
                                __("アップロード成功:", "smart-booking-pro2") + ' ' + response.data +
                                '</span>';
                            location.reload();
                        } else {
                            resultBox.innerHTML = '<span style="color: red;">' +
                                __("エラー:", "smart-booking-pro2") + ' ' + response.data +
                                '</span>';
                        }
                    }
                };

                xhr.send(formData);
            });
        });


    </script>

    <?php
}


// AjaxでTXT/HTMLファイルをアップロード  
// Upload TXT/HTML files via Ajax
function ers_ajax_upload_thanks_page() {
    // ✅ PRO／Enterprise 以外は利用制限ページに遷移  
    // ✅ Redirect to restriction page for non-PRO/Enterprise users
    if (!sbp2_is_pro_user() && !sbp2_is_enterprise_user()) {
        sbp2_restricted_feature_page();
        return;
    }

    check_ajax_referer('ers_upload_thanks_page_action', 'ers_thanks_page_upload_nonce');


    if (!isset($_FILES['thanks_page_file'])) {
        wp_send_json_error(__('ファイルが選択されていません。', 'smart-booking-pro2'));
    }

    $file = $_FILES['thanks_page_file'];
    $upload_dir = plugin_dir_path(__DIR__) . 'templates/thanks/';

    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $file_name = sanitize_file_name($file['name']);
    $target_file = $upload_dir . $file_name;
    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

    // アップロード可能な拡張子を制限  
    // Restrict allowed upload file extensions
    if (!in_array($ext, array('php', 'html'))) {
        wp_send_json_error(__('アップロードできるのは php または HTML ファイルのみです。', 'smart-booking-pro2'));
    }

    if (!isset($file['tmp_name']) || !is_uploaded_file($file['tmp_name'])) {
        wp_send_json_error(__('一時ファイルが見つかりません。', 'smart-booking-pro2'));
    }

    // ファイルを移動してアップロード  
    // Move and upload the file
    if (move_uploaded_file($file['tmp_name'], $target_file)) {
        wp_send_json_success($file_name);
    } else {
        wp_send_json_error(__('アップロードに失敗しました。', 'smart-booking-pro2'));
    }
}

add_action('wp_ajax_ers_upload_thanks_page', 'ers_ajax_upload_thanks_page');