<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// 予約編集ページを追加  
// Add reservation edit page
function ers_add_edit_reservation_page() {
    add_submenu_page(
        null, // メニューに表示しない
        __('予約編集', 'smart-booking-pro2'),
        __('予約編集', 'smart-booking-pro2'),
        'manage_options',
        'ers-edit-reservation',
        'ers_edit_reservation_page'
    );
}
add_action('admin_menu', 'ers_add_edit_reservation_page');


function ers_edit_reservation_page() {
    if (
        !isset($_GET['reservation_id'], $_GET['_wpnonce']) ||
        !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'edit_reservation_' . intval($_GET['reservation_id']))
    ) {
        echo '<div class="wrap"><h1>' . esc_html__('エラー', 'smart-booking-pro2') . '</h1><p>' . esc_html__('不正なアクセスです。', 'smart-booking-pro2') . '</p></div>';
        return;
    }

    $reservation_id = intval(wp_unslash($_GET['reservation_id']));
    $reservation = get_post($reservation_id);

    if (!$reservation || $reservation->post_type !== 'reserved-daytime') {
        echo '<div class="wrap"><h1>' . esc_html__('エラー', 'smart-booking-pro2') . '</h1><p>' . esc_html__('指定された予約が見つかりません。', 'smart-booking-pro2') . '</p></div>';
        return;
    }

    // 予約データ取得
    $event_id = get_field('event-id', $reservation_id);
    $event_name = get_field('event-name', $reservation_id);
    $user_name = get_field('reserved-user-name', $reservation_id);
    $user_email = get_field('reserved-user-email', $reservation_id);
    $user_phone = get_field('reserved-user-phoneno', $reservation_id);
    $reservation_date = get_field('reserved-day', $reservation_id);
    $reservation_time = get_field('reserved-time', $reservation_id);
    ?>

    <div class="wrap">
        <h1><?php esc_html_e('予約編集', 'smart-booking-pro2'); ?></h1>
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <input type="hidden" name="action" value="ers_update_reservation">
            <input type="hidden" name="reservation_id" value="<?php echo esc_attr($reservation_id); ?>">
            <?php wp_nonce_field('edit_reservation_' . esc_attr($reservation_id)); ?>

            <table class="form-table">
                <tr>
                    <th><label for="event_name"><?php esc_html_e('イベント名', 'smart-booking-pro2'); ?></label></th>
                    <td><input type="text" name="event_name" id="event_name" value="<?php echo esc_attr($event_name); ?>" class="regular-text" readonly></td>
                </tr>
                <tr>
                    <th><label for="user_name"><?php esc_html_e('氏名', 'smart-booking-pro2'); ?></label></th>
                    <td><input type="text" name="user_name" id="user_name" value="<?php echo esc_attr($user_name); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th><label for="user_email"><?php esc_html_e('メールアドレス', 'smart-booking-pro2'); ?></label></th>
                    <td><input type="email" name="user_email" id="user_email" value="<?php echo esc_attr($user_email); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th><label for="user_phone"><?php esc_html_e('電話番号', 'smart-booking-pro2'); ?></label></th>
                    <td><input type="text" name="user_phone" id="user_phone" value="<?php echo esc_attr($user_phone); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th><label for="reservation_date"><?php esc_html_e('予約日', 'smart-booking-pro2'); ?></label></th>
                    <td><input type="date" name="reservation_date" id="reservation_date" value="<?php echo esc_attr($reservation_date); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th><label for="reservation_time"><?php esc_html_e('予約時間', 'smart-booking-pro2'); ?></label></th>
                    <td><input type="time" name="reservation_time" id="reservation_time" value="<?php echo esc_attr($reservation_time); ?>" class="regular-text"></td>
                </tr>
            </table>

            <p class="submit">
                <button type="submit" class="button button-primary"><?php esc_html_e('更新', 'smart-booking-pro2'); ?></button>
                <a href="<?php echo esc_url(admin_url('admin.php?page=ers-reservation-list')); ?>" class="button"><?php esc_html_e('戻る', 'smart-booking-pro2'); ?></a>
            </p>
        </form>
    </div>

    <?php
}

?>