<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// 予約一覧ページの表示  
// Display reservation list page
if (!function_exists('ers_reservation_list_page')) {
    function ers_reservation_list_page() {

    $filter_date = isset($_GET['filter_date']) ? sanitize_text_field(wp_unslash($_GET['filter_date'])) : '';
    $filter_event_id = isset($_GET['filter_event_id']) ? sanitize_text_field(wp_unslash($_GET['filter_event_id'])) : '';

    ?>
        <div class="wrap">
            <h1><?php esc_html_e('予約一覧', 'smart-booking-pro2'); ?></h1>

            <form method="get">
                <input type="hidden" name="page" value="ers-reservation-list">
                <label><?php esc_html_e('日付:', 'smart-booking-pro2'); ?></label>
                <input type="date" name="filter_date" value="<?php echo esc_attr($filter_date); ?>">
                <label><?php esc_html_e('イベントID:', 'smart-booking-pro2'); ?></label>
                <input type="text" name="filter_event_id" value="<?php echo esc_attr($filter_event_id); ?>">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e('フィルタ', 'smart-booking-pro2'); ?>
                </button>
            </form>

            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('予約ID', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('予約日', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('予約時間', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('氏名', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('メールアドレス', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('電話番号', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('イベントID', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('イベント名', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('郵便番号', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('住所', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('建物名・号室', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('お問い合わせ内容', 'smart-booking-pro2'); ?></th>
                        <th><?php esc_html_e('自動承認', 'smart-booking-pro2'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $args = ['post_type' => 'reserved-daytime', 'posts_per_page' => -1];

                if (!empty($filter_date)) {
                    $args['meta_query'][] = [
                        'key' => 'reserved-day',
                        'value' => $filter_date, // ✅ 安全な変数に置換
                        'compare' => '='
                    ];
                }
                if (!empty($filter_event_id)) {
                    $args['meta_query'][] = [
                        'key' => 'event-id',
                        'value' => $filter_event_id, // ✅ 安全な変数に置換
                        'compare' => '='
                    ];
                }

                    $reservations = get_posts($args);
                    if (empty($reservations)) {
                        echo '<tr><td colspan="13">' . esc_html__('予約データがありません。', 'smart-booking-pro2') . '</td></tr>';
                    } else {
                        foreach ($reservations as $reservation) {
                            $fields = get_fields($reservation->ID);
                            ?>
                            <tr>
                                <td><?php echo esc_html($reservation->ID); ?></td>
                                <td><?php echo esc_html($fields['reserved-day'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-time'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-user-name'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-user-email'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-phone'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['event-id'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['event-name'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-zip'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-address'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-building'] ?? ''); ?></td>
                                <td><?php echo esc_html($fields['reserved-message'] ?? ''); ?></td>
                                <td>
                                    <?php
                                    echo !empty($fields['reserved-auto-accept'])
                                        ? esc_html__('承認済', 'smart-booking-pro2')
                                        : esc_html__('未承認', 'smart-booking-pro2');
                                    ?>
                                </td>
                            </tr>
                            <?php
                        }
                    }
                    ?>
                </tbody>
            </table>

            <form method="get" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                <input type="hidden" name="action" value="export_reservation_csv">
                <button type="submit" class="button button-secondary">
                    <?php esc_html_e('CSVダウンロード', 'smart-booking-pro2'); ?>
                </button>
            </form>
        </div>
        <?php
    }
}
