<?php
if (!defined('ABSPATH')) exit;

if (!function_exists('sbp2_render_status_page')) {
    function sbp2_render_status_page() {
        $is_cf7_active = class_exists('WPCF7_ContactForm');
        $is_acf_active = function_exists('get_field');
        $is_pro        = function_exists('sbp2_is_pro_user') ? sbp2_is_pro_user() : false;
        $is_enterprise = function_exists('sbp2_is_enterprise_user') ? sbp2_is_enterprise_user() : false;

        $subscription_type = 'free';
        if ($is_enterprise) {
            $subscription_type = 'enterprise';
        } elseif ($is_pro) {
            $subscription_type = 'pro';
        }

        // フォーム作成済みチェック（タイトルは翻訳関数で比較しない）
        $cf7_created = get_posts([
            'post_type'      => 'wpcf7_contact_form',
            'post_status'    => 'any',
            'title'          => __('Plugin initial registration event reservation form', 'smart-booking-pro2'),
            'posts_per_page' => 1,
            'fields'         => 'ids',
        ]);

        $sample_created = get_posts([
            'post_type'      => 'event-reservation',
            'post_status'    => 'any',
            'title'          => __('Sample Reservation Page', 'smart-booking-pro2'),
            'posts_per_page' => 1,
            'fields'         => 'ids',
        ]);


        $uuid = get_option('sbp2_install_id');
        $pro_expiry = get_option('sbp2_subscription_limit_day');
        $next_payment = get_option('sbp2_next_payment_date');
        $coupon_code = get_option('sbp2_used_coupon');
        $form_counts = wp_count_posts('event-reservation');
        $form_count = ($form_counts->publish ?? 0) + ($form_counts->draft ?? 0);

        $reservation_count = wp_count_posts('reserved-daytime')->draft;

        $pro_users = get_option('sbp2_active_pro_count', 0);

        function sbp2_get_donation_rate_and_next($count) {
            if ($count < 100) return [0, 100];
            if ($count < 500) return [1, 500];
            if ($count < 1000) return [2, 1000];
            if ($count < 2000) return [3, 2000];
            if ($count < 5000) return [4, 5000];
            $extra = floor(($count - 5000) / 1000);
            $rate = min(10, 5 + $extra);
            $next = ($rate < 10) ? 5000 + ($extra + 1) * 1000 : null;
            return [$rate, $next];
        }

        // ✅ プランの判定（事前に $is_pro / $is_enterprise を定義済み前提）
        $is_free = !$is_pro && !$is_enterprise;

        $form_count_obj = wp_count_posts('event-reservation');
        $form_count = ($form_count_obj->publish ?? 0) + ($form_count_obj->draft ?? 0);

        $form_limit = (int) get_option('sbp2_free_form_limit', 2);

        $max_text = $is_free
            ? sprintf(esc_html__('最大 %d 件', 'smart-booking-pro2'), $form_limit)
            : esc_html__('無制限', 'smart-booking-pro2');

        if ($is_free && $form_count >= $form_limit) {
            $note_text = esc_html__('⚠️ 上限に達しています（PRO または Enterprise で無制限）', 'smart-booking-pro2');
        } elseif ($is_pro) {
            $note_text = esc_html__('✅ PRO版利用中（無制限）', 'smart-booking-pro2');
        } elseif ($is_enterprise) {
            $note_text = esc_html__('✅ Enterprise版利用中（無制限）', 'smart-booking-pro2');
        } else {
            $note_text = esc_html__('✅ 利用可能', 'smart-booking-pro2');
        }


        // ✅ 上限数（無料プランのみ有効）
        $db_limit = (int) get_option('sbp2_free_db_limit', 3);

        // ✅ 作成済み数の取得
        $default_db_count = 1;
        $saved_data_acf = get_option('smart_booking_acf_data', []);
        $saved_data_db  = get_option('smart_booking_acf_db', []);

        if (!is_array($saved_data_acf)) $saved_data_acf = [];
        if (!is_array($saved_data_db))  $saved_data_db  = [];

        $merged_data = array_merge($saved_data_acf, $saved_data_db);
        $db_created = $default_db_count + count($merged_data);

        // ✅ 表示テキストの準備
        $max_text = $is_free
            ? sprintf(esc_html__('最大 %d 件', 'smart-booking-pro2'), $db_limit)
            : esc_html__('無制限', 'smart-booking-pro2');

        $note_text = esc_html__('✅ 利用可能', 'smart-booking-pro2');


        if ($is_free && $db_created >= $db_limit) {
            $note_text = esc_html__('※ 上限に達しています。PRO または Enterprise プランで無制限利用可', 'smart-booking-pro2');
        } elseif ($is_pro) {
            $note_text = esc_html__('✅ PRO版利用中（無制限）', 'smart-booking-pro2');
        } elseif ($is_enterprise) {
            $note_text = esc_html__('✅ Enterprise版利用中（無制限）', 'smart-booking-pro2');
        }

        // ✅ プランごとの表示内容を判定
        if ($is_pro || $is_enterprise) {
            $csv_status = esc_html__('✅ 利用可能', 'smart-booking-pro2');
            $csv_note   = $is_enterprise
                ? esc_html__('✅ Enterprise版利用中', 'smart-booking-pro2')
                : esc_html__('✅ PRO版利用中', 'smart-booking-pro2');
        } else {
            $csv_status = esc_html__('❌ 利用にはPROが必要', 'smart-booking-pro2');
            $csv_note   = esc_html__('PRO専用機能', 'smart-booking-pro2');
        }


        // ✅ 機能状態判定
        if ($is_pro || $is_enterprise) {
            $email_edit_status = esc_html__('✅ 編集・外部ファイル利用可', 'smart-booking-pro2');
            $email_note        = $is_enterprise
                ? esc_html__('✅ Enterprise版利用中（全機能解放）', 'smart-booking-pro2')
                : esc_html__('✅ PRO版利用中（外部テンプレート利用可）', 'smart-booking-pro2');
        } else {
            $email_edit_status = esc_html__('✅ 編集可 ／ ❌ 外部ファイルは利用不可', 'smart-booking-pro2');
            $email_note        = esc_html__('外部ファイルのアップロードは PRO プラン以上で解放', 'smart-booking-pro2');
        }

        if ($is_pro || $is_enterprise) {
            $reminder_edit_status = esc_html__('✅ 編集・外部ファイル利用可', 'smart-booking-pro2');
            $reminder_note        = $is_enterprise
                ? esc_html__('✅ Enterprise版利用中（全機能解放）', 'smart-booking-pro2')
                : esc_html__('✅ PRO版利用中（外部テンプレート利用可）', 'smart-booking-pro2');
        } else {
            $reminder_edit_status = esc_html__('✅ 編集可 ／ ❌ 外部ファイルは利用不可', 'smart-booking-pro2');
            $reminder_note        = esc_html__('外部ファイルのアップロードは PRO プラン以上で解放', 'smart-booking-pro2');

            $status = get_option('sbp2_subscription_status');
            $disabled = ($status !== 'active') ? 'disabled' : '';
        }


        list($donation_rate, $next_threshold) = sbp2_get_donation_rate_and_next($pro_users);
        $progress_percent = $next_threshold ? min(100, round(($pro_users / $next_threshold) * 100)) : 100;

        // 🔁 会員情報同期ボタン表示
            echo '<form method="post" style="margin-top: 20px;">';
            wp_nonce_field('sbp2_sync_subscription', 'sbp2_sync_nonce');
            echo '<input type="submit" name="sbp2_sync_now" class="button button-secondary" value="' . esc_attr__('🔄 会員情報を同期する', 'smart-booking-pro2') . '">';
            echo '</form>';

            if (isset($_POST['sbp2_sync_now']) && check_admin_referer('sbp2_sync_subscription', 'sbp2_sync_nonce')) {
                $result = sbp2_check_remote_subscription_status();
                if ($result['success']) {
                    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('✅ サブスク情報を同期しました。', 'smart-booking-pro2') . '</p></div>';
                } else {
                    echo '<div class="notice notice-error is-dismissible"><p>' .
                        esc_html__('⚠ 同期に失敗しました：', 'smart-booking-pro2') . esc_html($result['message']) .
                        '</p></div>';
                }
            }
 

        echo '<div class="wrap">';
        echo '<h1>' . esc_html__('Smart Booking PRO2 ステータス', 'smart-booking-pro2');

        $plan_type = get_option('sbp2_plan_type');

        if ($subscription_type !== 'free') {
            $label = strtoupper($subscription_type);

            if ($subscription_type === 'pro') {
                if ($plan_type === 'price_trial') {
                    $label = esc_html__('PRO（トライアル）', 'smart-booking-pro2');
                } else {
                    $label = esc_html__('PRO（月額）', 'smart-booking-pro2');
                }
            }

            if ($subscription_type === 'enterprise') {
                $label = esc_html__('Enterprise（年額）', 'smart-booking-pro2');
            }

            echo ' <span style="background:#21759b;color:#fff;padding:2px 8px;border-radius:3px;font-size:14px;">' .
                esc_html($label) . ' ' . esc_html__('アクティブ', 'smart-booking-pro2') . '</span>';
        } else {
            echo ' <span style="background:#777;color:#fff;padding:2px 8px;border-radius:3px;font-size:14px;">' .
                esc_html__('無料版', 'smart-booking-pro2') . '</span>';
        }


        echo '</h1>';


        echo '<h2>' . esc_html__('基本状態', 'smart-booking-pro2') . '</h2>';
        echo '<table class="widefat fixed striped">';
        echo '<thead><tr><th>' . esc_html__('項目', 'smart-booking-pro2') . '</th><th>' . esc_html__('状態', 'smart-booking-pro2') . '</th></tr></thead><tbody>';

        if ($is_enterprise) {
            echo '<tr><td>' . esc_html__('サブスクリプション', 'smart-booking-pro2') . '</td><td>🏢 ' . esc_html__('ENTERPRISE 利用中', 'smart-booking-pro2') . '</td></tr>';
        } elseif ($is_pro) {
            echo '<tr><td>' . esc_html__('サブスクリプション', 'smart-booking-pro2') . '</td><td>✅ ' . esc_html__('PRO 利用中', 'smart-booking-pro2') . '</td></tr>';
        } else {
            echo '<tr><td>' . esc_html__('サブスクリプション', 'smart-booking-pro2') . '</td><td>🔓 ' . esc_html__('無料プラン', 'smart-booking-pro2') . '</td></tr>';
        }

        if ($is_pro) {
            if ($pro_expiry) {
                $days_left = floor((strtotime($pro_expiry) - time()) / 86400);
                $label = ($days_left >= 0)
                    ? '（' . sprintf(esc_html__('あと %d 日', 'smart-booking-pro2'), $days_left) . '）'
                    : '（' . esc_html__('期限切れ', 'smart-booking-pro2') . '）';
                echo '<tr><td>' . esc_html__('PRO 有効期限', 'smart-booking-pro2') . '</td><td>' . esc_html($pro_expiry) . esc_html($label) . '</td></tr>';
            } else {
                echo '<tr><td>' . esc_html__('PRO 有効期限', 'smart-booking-pro2') . '</td><td>' . esc_html__('未登録', 'smart-booking-pro2') . '</td></tr>';
            }
        }


        echo '<tr><td>' . esc_html__('Contact Form 7', 'smart-booking-pro2') . '</td><td>' . ($is_cf7_active ? '✅ ' . esc_html__('有効', 'smart-booking-pro2') : '❌ ' . esc_html__('無効', 'smart-booking-pro2')) . '</td></tr>';
        echo '<tr><td>' . esc_html__('Advanced Custom Fields', 'smart-booking-pro2') . '</td><td>' . ($is_acf_active ? '✅ ' . esc_html__('有効', 'smart-booking-pro2') : '❌ ' . esc_html__('無効', 'smart-booking-pro2')) . '</td></tr>';
        echo '<tr><td>' . esc_html__('初期 CF7 フォーム', 'smart-booking-pro2') . '</td><td>' . (!empty($cf7_created) ? '✅ ' . esc_html__('作成済み', 'smart-booking-pro2') : '❌ ' . esc_html__('未作成', 'smart-booking-pro2')) . '</td></tr>';
        echo '<tr><td>' . esc_html__('Sample Reservation Page', 'smart-booking-pro2') . '</td><td>' . (!empty($sample_created) ? '✅ ' . esc_html__('作成済み', 'smart-booking-pro2') : '❌ ' . esc_html__('未作成', 'smart-booking-pro2')) . '</td></tr>';
        echo '<tr><td>' . esc_html__('ユーザー識別', 'smart-booking-pro2') . '</td><td>' . esc_html($uuid ?: __('なし', 'smart-booking-pro2')) . '</td></tr>';
        echo '</tbody></table>';


        echo '<h2 style="margin-top:40px;">' . esc_html__('使用状況と制限状態', 'smart-booking-pro2') . '</h2>';
        echo '<table class="widefat fixed striped">';
        echo '<thead><tr><th>' . esc_html__('項目', 'smart-booking-pro2') . '</th><th>' . esc_html__('現在の状態', 'smart-booking-pro2') . '</th><th>' . esc_html__('無料版の制限', 'smart-booking-pro2') . '</th><th>' . esc_html__('ステータス', 'smart-booking-pro2') . '</th></tr></thead><tbody>';
        echo '<tr>';
        echo '<td>' . esc_html__('フォーム作成数', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($form_count) . ' ' . esc_html__('件', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($max_text) . '</td>';
        echo '<td>' . esc_html($note_text) . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('予約登録数', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html(intval($reservation_count)) . ' ' . esc_html__('件', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html__('制限なし', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html__('✅ 無制限', 'smart-booking-pro2') . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('データベース作成数', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($db_created) . ' ' . esc_html__('件', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($max_text) . '</td>';
        echo '<td>' . esc_html($note_text) . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('CSV出力（予約データ）', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($csv_status) . '</td>';
        echo '<td>' . esc_html($csv_note) . '</td>';
        echo '<td>' . esc_html($csv_status) . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('CF7フォーム作成・編集', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html__('制限なし', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html__('制限なし', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html__('✅ 利用可能', 'smart-booking-pro2') . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('確認メールの編集（外部テンプレート）', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($email_edit_status) . '</td>';
        echo '<td>' . esc_html($is_pro || $is_enterprise ? __('PRO専用機能（外部ファイル）', 'smart-booking-pro2') : __('無料機能（一部制限あり）', 'smart-booking-pro2')) . '</td>';
        echo '<td>' . esc_html($email_note) . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('リマインダー編集（外部テンプレート）', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($reminder_edit_status) . '</td>';
        echo '<td>' . esc_html($is_pro || $is_enterprise ? __('PRO専用機能（外部ファイル）', 'smart-booking-pro2') : __('無料機能（一部制限あり）', 'smart-booking-pro2')) . '</td>';
        echo '<td>' . esc_html($reminder_note) . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('フォームテンプレート編集', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($is_pro || $is_enterprise ? __('✅ 利用可', 'smart-booking-pro2') : __('❌ 利用不可', 'smart-booking-pro2')) . '</td>';
        echo '<td>' . esc_html__('PRO専用機能', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html(
            $is_pro ? __('✅ PRO版利用中（機能解放）', 'smart-booking-pro2') :
            ($is_enterprise ? __('✅ Enterprise版利用中（全機能解放）', 'smart-booking-pro2') :
            __('編集には PRO 以上が必要です', 'smart-booking-pro2'))
        ) . '</td>';
        echo '</tr>';
        echo '<tr>';
        echo '<td>' . esc_html__('ページテンプレート編集', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($is_pro || $is_enterprise ? __('✅ 利用可', 'smart-booking-pro2') : __('❌ 利用不可', 'smart-booking-pro2')) . '</td>';
        echo '<td>' . esc_html__('PRO専用機能', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html(
            $is_pro ? __('✅ PRO版利用中（機能解放）', 'smart-booking-pro2') :
            ($is_enterprise ? __('✅ Enterprise版利用中（全機能解放）', 'smart-booking-pro2') :
            __('編集には PRO 以上が必要です', 'smart-booking-pro2'))
        ) . '</td>';
        echo '</tr>';


        echo '<tr>';
        echo '<td>' . esc_html__('Google / Yahoo! カレンダー機能', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($is_pro || $is_enterprise ? __('✅ 利用可', 'smart-booking-pro2') : __('❌ 利用不可', 'smart-booking-pro2')) . '</td>';
        echo '<td>' . esc_html__('PRO専用機能', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html(
            $is_pro ? __('✅ PRO版利用中（機能解放）', 'smart-booking-pro2') :
            ($is_enterprise ? __('✅ Enterprise版利用中（全機能解放）', 'smart-booking-pro2') :
            __('カレンダーは PRO 以上が必要です', 'smart-booking-pro2'))
        ) . '</td>';
        echo '</tr>';

        echo '<tr>';
        echo '<td>' . esc_html__('CSS・Form Design Builder', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html($is_enterprise ? __('✅ 利用可', 'smart-booking-pro2') : __('❌ 利用不可', 'smart-booking-pro2')) . '</td>';
        echo '<td>' . esc_html__('Enterprise 限定', 'smart-booking-pro2') . '</td>';
        echo '<td>' . esc_html(
            $is_enterprise ? __('✅ Enterprise版利用中（全機能解放）', 'smart-booking-pro2') :
            __('利用には Enterprise が必要です', 'smart-booking-pro2')
        ) . '</td>';
        echo '</tr>';

        echo '</tbody></table>';


        echo '<div style="margin-top:30px;padding:15px;border:1px solid #d0e6ff;background:#f0f8ff;">';

        // ✅ ベータ版である旨の表示（先頭に追加）
        echo '<p style="color:#c00;font-weight:bold;margin-bottom:20px;">' .
            esc_html__('現在はベータ版です。本機能はリリース時に有効になります。', 'smart-booking-pro2') .
            '</p>';

        echo '<h2>' . esc_html__('PRO版にアップグレード', 'smart-booking-pro2') . '</h2>';
        echo '<p>' . esc_html__('PRO版では、すべての機能が無制限で利用可能になります。', 'smart-booking-pro2') . '</p>';
        echo '<h2>' . esc_html__('PROプラン一覧', 'smart-booking-pro2') . '</h2>';

        echo '<ul style="margin-bottom: 20px; padding-left: 0; list-style: none;">';
        echo '<li style="display: inline-block; margin-right: 10px;"><button class="button sbp2-checkout-btn" disabled>' . esc_html__('月額 PRO版', 'smart-booking-pro2') . '</button></li>';
        echo '<li style="display: inline-block; margin-right: 10px;"><button class="button sbp2-checkout-btn" disabled>' . esc_html__('6ヵ月継続（約5%お得）', 'smart-booking-pro2') . '</button></li>';
        echo '<li style="display: inline-block; margin-right: 10px;"><button class="button sbp2-checkout-btn" disabled>' . esc_html__('1年継続（約10%お得）', 'smart-booking-pro2') . '</button></li>';
        echo '<li style="display: inline-block; margin-right: 10px;"><button class="button button-secondary sbp2-checkout-btn" disabled>' . esc_html__('14日間トライアル', 'smart-booking-pro2') . '</button></li>';
        echo '</ul>';

        echo '<hr>';
        echo '<p><button class="button button-primary" disabled>🔍 ' . esc_html__('商品の詳細を見る', 'smart-booking-pro2') . '</button></p>';

        echo '<p><strong>' . esc_html__('※トライアル終了後は、自動的に有料プラン（月額 ¥980）へ移行しますので、', 'smart-booking-pro2') . '<br>' .
            esc_html__('ご利用を停止する場合は、期間中にキャンセルをお手続きください。', 'smart-booking-pro2') . '</strong></p>';

        // ✅ Customer Portal リンクボタンも無効化
        echo '<p>';
        echo '<button id="sbp2-change-plan-button" class="button button-primary" disabled>';
        echo esc_html__('プラン変更・決済履歴・キャンセルはこちら', 'smart-booking-pro2');
        echo '</button>';
        echo '</p>';

        // ✅ フッターリンクはそのまま表示（参考情報として）
        echo '<p style="font-size: 13px; margin-top: 10px;">';
        echo '<a href="https://arce-experience.com/pricing/" target="_blank">' . esc_html__('料金プラン', 'smart-booking-pro2') . '</a> / ';
        echo '<a href="https://arce-experience.com/product/" target="_blank">' . esc_html__('商品紹介', 'smart-booking-pro2') . '</a> / ';
        echo '<a href="https://arce-experience.com/developer/" target="_blank">' . esc_html__('開発者情報', 'smart-booking-pro2') . '</a> / ';
        echo '<a href="https://arce-experience.com/terms/" target="_blank">' . esc_html__('利用規約', 'smart-booking-pro2') . '</a> / ';
        echo '<a href="https://arce-experience.com/legal/" target="_blank">' . esc_html__('特定商取引法表記', 'smart-booking-pro2') . '</a> / ';
        echo '<a href="https://arce-experience.com/refund/" target="_blank">' . esc_html__('返金ポリシー', 'smart-booking-pro2') . '</a> / ';
        echo '<a href="https://arce-experience.com/privacy-policy/" target="_blank">' . esc_html__('プライバシーポリシー', 'smart-booking-pro2') . '</a> / ';
        echo '<a href="https://arce-experience.com/cookie-policy/" target="_blank">' . esc_html__('クッキーポリシー', 'smart-booking-pro2') . '</a>';
        echo '</p>';

        echo '</div>';



        echo '<h2 style="margin-top:40px;">' . esc_html__('コミュニティ支援状況', 'smart-booking-pro2') . '</h2>';
        echo '<table class="widefat fixed striped">';
        echo '<thead><tr><th>' . esc_html__('項目', 'smart-booking-pro2') . '</th><th>' . esc_html__('状態', 'smart-booking-pro2') . '</th></tr></thead><tbody>';
        echo '<tr><td>' . esc_html__('PRO契約者数', 'smart-booking-pro2') . '</td><td>' . number_format($pro_users) . ' ' . esc_html__('件', 'smart-booking-pro2') . '</td></tr>';
        echo '<tr><td>' . esc_html__('現在の寄付率', 'smart-booking-pro2') . '</td><td>' . esc_html($donation_rate) . '%（' . esc_html__('収益の一部をオープンソース支援に還元', 'smart-booking-pro2') . '）</td></tr>';
        if ($next_threshold) {
            echo '<tr><td>' . esc_html__('次の寄付レベルまで', 'smart-booking-pro2') . '</td><td>' . sprintf(esc_html__('あと %d 件（%d 件で %d%%）', 'smart-booking-pro2'), ($next_threshold - $pro_users), $next_threshold, ($donation_rate + 1)) . '</td></tr>';
        }
        echo '</tbody></table>';

        echo '<p style="font-size:13px;margin-top:10px;">' . esc_html__('このプラグインは', 'smart-booking-pro2') . ' <a href="https://www.advancedcustomfields.com/" target="_blank">ACF</a>、<a href="https://contactform7.com/" target="_blank">CF7</a>、' . esc_html__('および', 'smart-booking-pro2') . ' <a href="https://wordpressfoundation.org/" target="_blank">WordPress Foundation</a> ' . esc_html__('などのオープンソースに支えられており、PROユーザー数に応じて開発支援のための寄付を行って参ります。', 'smart-booking-pro2') . '</p>';

        echo '<div style="background:#eaf6ff;border:1px solid #bcdffb;padding:10px;margin:20px 0;">';
        echo '<strong>' . esc_html__('寄付ルール：', 'smart-booking-pro2') . '</strong> ';
        echo esc_html__('PRO契約100件で1%、500件で2%、1000件で3%、2000件で4%、5000件で5%、以後1000件ごとに+1%、最大10%まで支援します。', 'smart-booking-pro2') . '<br>';
        echo esc_html__('エンタープライズユーザーは、紹介ページで「支援パートナー」として紹介されます。', 'smart-booking-pro2');
        echo '<div style="margin-top:10px;">' . esc_html__('進捗：', 'smart-booking-pro2') . '<div style="background:#ddd;width:100%;height:20px;border-radius:5px;overflow:hidden;">';
        echo '<div style="background:#4caf50;height:100%;width:' . esc_attr($progress_percent) . '%;"></div>';
        echo '</div><div style="font-size:13px;margin-top:5px;">' . sprintf(esc_html__('次のレベルまであと %d 件', 'smart-booking-pro2'), max(0, $next_threshold - $pro_users)) . '</div></div>';
        echo '</div>';

        if (!$is_pro && $form_count >= 2) {
            echo '<div class="notice notice-warning is-dismissible" style="margin-top:30px;">';
            echo '<p><strong>⚠️ ' . esc_html__('フォームの作成上限に達しています。', 'smart-booking-pro2') . '</strong> ' . esc_html__('これ以上のフォームを作成するには', 'smart-booking-pro2') . ' <a href="#upgrade">' . esc_html__('PRO版へのアップグレード', 'smart-booking-pro2') . '</a> ' . esc_html__('が必要です。', 'smart-booking-pro2') . '</p>';
            echo '</div>';
        }


        echo '<div style="margin-top:30px;padding:15px;border:1px solid #fcf8e3;background:#fffff8;">';
        echo '<h2>' . esc_html__('カスタマーサポート', 'smart-booking-pro2') . '</h2>';
        echo '<p>' . esc_html__('ご不明点がありましたら、下記のボタンよりお問い合わせください。', 'smart-booking-pro2') . '</p>';
        echo '<p><a href="https://arce-experience.com/contact/" class="button button-primary" target="_blank">'
            . esc_html__('サポートに問い合わせる', 'smart-booking-pro2') . '</a></p>';
        echo '</div>';

        echo '<div style="margin-top:30px;padding:15px;border:1px solid #f2dede;background:#fcf8e3;">';
        echo '<h2>' . esc_html__('サブスクリプションの解約について', 'smart-booking-pro2') . '</h2>';
        echo '<p>' . esc_html__('サブスクリプションの解約は、Stripeのカスタマーポータルからいつでも可能です。', 'smart-booking-pro2') . '</p>';
        echo '<p>' . esc_html__('解約後も、契約期間の終了日までは PRO 機能をご利用いただけます。', 'smart-booking-pro2') . '</p>';
        echo '</div>';

        echo '<div style="margin-top:30px;padding:15px;border:1px solid #ffe0e0;background:#fff8f8;">';
        echo '<h2>' . esc_html__('アンインストール時のデータ削除', 'smart-booking-pro2') . '</h2>';
        echo '<form method="post">';
        wp_nonce_field('sbp2_uninstall_data_option', 'sbp2_uninstall_data_nonce');
        $delete_on_uninstall = get_option('sbp2_delete_on_uninstall', false);
        echo '<label>';
        echo '<input type="checkbox" name="sbp2_delete_on_uninstall" value="1" '
            . checked($delete_on_uninstall, true, false) . '> ';
        echo esc_html__('プラグインのアンインストール時に、全ての設定・投稿・データベースを完全に削除する', 'smart-booking-pro2');
        echo '</label>';
        echo '<br><small style="color:#a00;">'
            . esc_html__('※この設定を有効にすると、プラグイン削除時に全てのデータが復元できない形で削除されます。', 'smart-booking-pro2')
            . '</small><br>';
        echo '<button type="submit" class="button button-secondary" style="margin-top:10px;">'
            . esc_html__('設定を保存', 'smart-booking-pro2') . '</button>';
        echo '</form>';

        if (isset($_POST['sbp2_uninstall_data_nonce']) && check_admin_referer('sbp2_uninstall_data_option', 'sbp2_uninstall_data_nonce')) {
            $enabled = isset($_POST['sbp2_delete_on_uninstall']) ? true : false;
            update_option('sbp2_delete_on_uninstall', $enabled);
            echo '<div class="notice notice-success is-dismissible"><p>'
                . esc_html__('✅ アンインストール時の削除設定を保存しました。', 'smart-booking-pro2') . '</p></div>';
        }

        echo '</div>';
        echo '<script>window.SBP2_SUBSCRIPTION_STATUS = "' . esc_js(get_option('sbp2_subscription_status')) . '";</script>';


            }
    
}

