<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// 予約データを更新
function ers_update_reservation() {
    // ✅ ノンス検証（edit_reservation_[ID] を使って生成していたと想定）
    if (
        !isset($_POST['_wpnonce'], $_POST['reservation_id']) ||
        !wp_verify_nonce($_POST['_wpnonce'], 'edit_reservation_' . intval($_POST['reservation_id']))
    ) {
        wp_die(esc_html__('不正なリクエストです。', 'smart-booking-pro2'));
    }

    $reservation_id = intval($_POST['reservation_id']);
    if (!$reservation_id) {
        wp_die(esc_html__('予約IDが無効です。', 'smart-booking-pro2'));
    }

    // ✅ POSTデータの存在確認と安全な取得
    $user_name        = isset($_POST['user_name'])        ? sanitize_text_field(wp_unslash($_POST['user_name'])) : '';
    $user_email       = isset($_POST['user_email'])       ? sanitize_email(wp_unslash($_POST['user_email'])) : '';
    $user_phone       = isset($_POST['user_phone'])       ? sanitize_text_field(wp_unslash($_POST['user_phone'])) : '';
    $reservation_date = isset($_POST['reservation_date']) ? sanitize_text_field(wp_unslash($_POST['reservation_date'])) : '';
    $reservation_time = isset($_POST['reservation_time']) ? sanitize_text_field(wp_unslash($_POST['reservation_time'])) : '';

    // ✅ 予約データを更新
    update_field('reserved-user-name', $user_name, $reservation_id);
    update_field('reserved-user-email', $user_email, $reservation_id);
    update_field('reserved-user-phoneno', $user_phone, $reservation_id);
    update_field('reserved-day', $reservation_date, $reservation_id);
    update_field('reserved-time', $reservation_time, $reservation_id);

    // ✅ リダイレクト
    wp_redirect(admin_url('admin.php?page=ers-reservation-list&message=updated'));
    exit;
}
add_action('admin_post_ers_update_reservation', 'ers_update_reservation');
