<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * CF7の初期フォーム作成  
 * Create initial Contact Form 7 form
 */
function ers_create_default_cf7_form() {
    if (!class_exists('WPCF7_ContactForm')) {
        return;
    }

    $form_title = __('Plugin initial registration event reservation form', 'smart-booking-pro2');

    $existing_forms = get_posts([
        'post_type'      => 'wpcf7_contact_form',
        'post_status'    => 'any',
        'title'          => $form_title,
        'posts_per_page' => 1,
        'fields'         => 'ids',
    ]);
    if (!empty($existing_forms)) {
        return;
    }

    $form_id = wp_insert_post([
        'post_title'  => $form_title,
        'post_status' => 'publish',
        'post_type'   => 'wpcf7_contact_form',
    ]);

    if (is_wp_error($form_id) || !$form_id) {
        return;
    }

    // 翻訳文字列は実行時に評価されるよう、事前定義せずベタ書きしています  
    // Translation strings are written inline to be evaluated at runtime without predefinition
    $form_content = '[hidden ref_eventreservation id:ref_eventreservation default:get]

<label>' . __('予約日時*', 'smart-booking-pro2') . '</label> [text reserve_daytime readonly id:id_reserve_daytime placeholder "' . esc_attr__('選択してください', 'smart-booking-pro2') . '"]

<label>' . __('氏名*', 'smart-booking-pro2') . '</label> [text reservation_name placeholder "' . esc_attr__('your name', 'smart-booking-pro2') . '"]

<label>' . __('メールアドレス*', 'smart-booking-pro2') . '</label> [email reservation_email placeholder "' . esc_attr__('address@yourdomain.com', 'smart-booking-pro2') . '"]

<label>' . __('電話番号*', 'smart-booking-pro2') . '</label> [tel reservation_phone placeholder "' . esc_attr__('09011112222', 'smart-booking-pro2') . '"]

<label>' . __('郵便番号*', 'smart-booking-pro2') . '</label> [text reservation_zip id:reservation_zip placeholder "' . esc_attr__('8100001', 'smart-booking-pro2') . '"]

<label>' . __('住所*', 'smart-booking-pro2') . '</label> [text reservation_address id:reservation_address placeholder "' . esc_attr__('郵便番号の入力補助', 'smart-booking-pro2') . '"]

<label>' . __('建物名・号室', 'smart-booking-pro2') . '</label> [text reservation_building placeholder "' . esc_attr__('〇〇マンション401号室', 'smart-booking-pro2') . '"]

<label>' . __('お問い合わせ内容', 'smart-booking-pro2') . '</label> [textarea reservation_message placeholder "' . esc_attr__('メッセージなどご入力ください', 'smart-booking-pro2') . '"]

[hidden reserved_age "0"]
[hidden reserved_gender "' . esc_attr__('未回答', 'smart-booking-pro2') . '"]
[hidden reserved_marital_status "' . esc_attr__('未回答', 'smart-booking-pro2') . '"]
[hidden reserved_income "0"]
[hidden reserved_residence "' . esc_attr__('未選択', 'smart-booking-pro2') . '"]
[hidden reserved_rent "0"]
[hidden reserved_people "1"]
[hidden reserved_course "' . esc_attr__('未選択', 'smart-booking-pro2') . '"]
[hidden reserved_car_count "0"]
[hidden reserved_hobby ""]

[submit "' . esc_html__('予約する', 'smart-booking-pro2') . '"]
';

    update_post_meta($form_id, '_form', $form_content);

    $contact_form = WPCF7_ContactForm::get_instance($form_id);
    if (!$contact_form) {
        return;
    }

    $admin_mail_template = [
        'active'             => true,
        'recipient'          => get_option('admin_email'),
        'sender'             => '[your-name] <[your-email]>',
        'subject'            => __('[イベント予約] [reservation_name] 様の予約', 'smart-booking-pro2'),
        'body'               => __("新しい予約がありました。\n\n", 'smart-booking-pro2') .
                                 __("予約日時: [reserve_daytime]\n", 'smart-booking-pro2') .
                                 __("氏名: [reservation_name]\n", 'smart-booking-pro2') .
                                 __("メール: [reservation_email]\n", 'smart-booking-pro2') .
                                 __("電話番号: [reservation_phone]\n", 'smart-booking-pro2') .
                                 __("郵便番号: [reservation_zip]\n", 'smart-booking-pro2') .
                                 __("住所: [reservation_address]\n", 'smart-booking-pro2') .
                                 __("建物名・号室: [reservation_building]\n", 'smart-booking-pro2') .
                                 __("問い合わせ内容: [reservation_message]\n\n", 'smart-booking-pro2') .
                                 __("対応をお願いします。", 'smart-booking-pro2'),
        'additional_headers' => "Reply-To: [reservation_email]",
        'attachments'        => '',
        'use_html'           => false,
    ];

    $contact_form->set_properties([
        'form' => $form_content,
        'mail' => $admin_mail_template,
    ]);

    $contact_form->save();

    $shortcode = '[contact-form-7 id="' . $form_id . '" title="' . esc_attr($form_title) . '"]';
    update_option('ers_default_cf7_shortcode', $shortcode);
}

add_action('init', function () {
    if (get_option('ers_needs_initial_cf7_form')) {
        if (class_exists('WPCF7_ContactForm')) {
            ers_create_default_cf7_form();
            delete_option('ers_needs_initial_cf7_form');
        }
    }
});
