<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}


function smart_booking_menu() {

    add_menu_page(
        __('Smart Booking PRO2 - DB管理', 'smart-booking-pro2'), // ページタイトル
        __('Smart Booking DB', 'smart-booking-pro2'), // メニュータイトル
        'manage_options', // 権限
        'smart_booking_db', // メニューのスラッグ
        'smart_booking_db_page', // 関数を指定
        'dashicons-admin-generic', // アイコン
        2 // メニューの位置（最上部にする）
    );
    

    // サブメニュー「Edit Type & Fields」を追加
    add_submenu_page(
        'smart_booking_db',            // 親メニュー
        __('保存先確認と編集', 'smart-booking-pro2'), // ページタイトル
        __('保存先確認と編集', 'smart-booking-pro2'),    // メニュータイトル
        'manage_options',              // 権限
        'smart_booking_edit_types',    // メニューのスラッグ
        'smart_booking_edit_types_page' // 関数を指定
    );
    
}
add_action('admin_menu', 'smart_booking_menu');


// 保存済みデータリストメニュー（関数：admin-database.php）  
// Saved data list menu (function: admin-database.php)
function smart_booking_add_saved_list_submenu() {
    add_submenu_page(
        'smart_booking_db',         // ✅ 親メニュー
        __('保存済データリスト', 'smart-booking-pro2'), // ✅ ページタイトル
        __('保存済データリスト', 'smart-booking-pro2'), // ✅ メニュータイトル
        'manage_options',           // ✅ 権限
        'smart_booking_saved_list', // ✅ メニューのスラッグ
        'smart_booking_saved_list_page' // ✅ 実行関数
    );
}
add_action('admin_menu', 'smart_booking_add_saved_list_submenu');

// Create CF7：CF7フォームの自動作成（関数：admin-database.php）  
// Create CF7: Automatic creation of CF7 forms (function: admin-database.php)
function smart_booking_add_create_cf7_submenu() {
    add_submenu_page(
        'smart_booking_db',         // ✅ 親メニュー（Smart Booking DB）
        __('CF7フォーム作成', 'smart-booking-pro2'), // ✅ ページタイトル
        __('CF7フォーム作成', 'smart-booking-pro2'), // ✅ メニュータイトル
        'manage_options',           // ✅ 権限
        'smart_booking_create_cf7', // ✅ メニューのスラッグ
        'smart_booking_create_cf7_page' // ✅ 実行関数
    );
}
add_action('admin_menu', 'smart_booking_add_create_cf7_submenu');

// CF7 フォーム編集メニュー（関数：admin-database.php）  
// CF7 form edit menu (function: admin-database.php)
function smart_booking_add_cf7_management_submenu() {
    add_submenu_page(
        'smart_booking_db',        // ✅ 親メニュー（Smart Booking DB）
        __('CF7フォーム編集', 'smart-booking-pro2'), // ✅ ページタイトル
        __('CF7フォーム編集', 'smart-booking-pro2'), // ✅ メニュータイトル
        'manage_options',          // ✅ 権限
        'smart_booking_cf7_management', // ✅ メニューのスラッグ
        'smart_booking_cf7_management_page' // ✅ 実行関数
    );
}
add_action('admin_menu', 'smart_booking_add_cf7_management_submenu');


// CF7確認メール作成メニュー（関数：admin-database.php）  
// CF7 confirmation email creation menu (function: admin-database.php)
add_action('admin_menu', function () {
    add_submenu_page(
        'smart_booking_db',
        __('CF7確認メール作成', 'smart-booking-pro2'), // ✅ ページタイトル
        __('CF7確認メール作成', 'smart-booking-pro2'), // ✅ メニュータイトル
        'manage_options',
        'smart_booking_cf7_to_confirm',
        'render_cf7_to_confirm_page'
    );
});

add_action('admin_menu', function(){
        add_submenu_page(
        'smart_booking_db',
        __('確認メール編集', 'smart-booking-pro2'),
        __('確認メール編集', 'smart-booking-pro2'),
        'manage_options',
        'ers-confirmation-email-editor',
        'ers_confirmation_email_editor_page'
    );
});

add_action('admin_menu', function(){
    add_submenu_page(
        'smart_booking_db',
        __('リマインダー編集', 'smart-booking-pro2'),
        __('リマインダー編集', 'smart-booking-pro2'),
        'manage_options',
        'ers-remainder-editor',
        'ers_remainder_editor_page'
    );
});

add_action('admin_menu', function(){
    add_submenu_page(
        'smart_booking_db', // 親メニューのスラッグ
        __('Thanksページ編集', 'smart-booking-pro2'), // ページタイトル
        __('Thanksページ編集', 'smart-booking-pro2'), // メニュータイトル
        'manage_options', // 権限
        'ers-thanks-page-editor', // スラッグ
        'ers_thanks_page_editor_page' // コールバック関数
    );
});




/**
 * Fires before the administration menu loads in the admin.
 *
 * @param string $context Empty context.
 */
function action_admin_menu($context) : void {
}

// PRO以上のユーザーに限定してメニュー追加  
// Add menu restricted to PRO and above users
add_action('admin_menu', function () {

    // 🔓🔒 PRO 表示切り替え
    $is_pro = sbp2_is_pro_user();
    $is_enterprise = sbp2_is_enterprise_user();
    $has_pro_access = $is_pro || $is_enterprise;
    $lock_icon = $has_pro_access ? '🔓' : '🔒PRO';

    // ✅ フォームtmp編集
    add_submenu_page(
        'smart_booking_db',
        __('フォームtmp編集', 'smart-booking-pro2'),
        __('フォームtmp編集', 'smart-booking-pro2') . ' ' . $lock_icon,
        'manage_options',
        'ers-form-template-editor',
        $has_pro_access ? 'ers_form_template_editor_page' : 'sbp2_restricted_feature_page'
    );

    // ✅ ページtmp編集
    add_submenu_page(
        'smart_booking_db',
        __('ページtmp編集', 'smart-booking-pro2'),
        __('ページtmp編集', 'smart-booking-pro2') . ' ' . $lock_icon,
        'manage_options',
        'ers-template-editor',
        $has_pro_access ? 'ers_template_editor_page' : 'sbp2_restricted_feature_page'
    );

    // ✅ フォームCSSデザイン編集（PRO以上）
    add_submenu_page(
        'smart_booking_db',
        __('Edit Form CSS', 'smart-booking-pro2'),
        __('Edit Form CSS', 'smart-booking-pro2') . ' ' . $lock_icon,
        'manage_options',
        'ers-formdesign-editor',
        $has_pro_access ? 'ers_formdesign_editor_page' : 'sbp2_restricted_feature_page'
    );
});



// フォームビルダーメニュー（Enterprise専用）  
// Form builder menu (Enterprise only)
function ers_add_formbuilder_menu() {
    $title = __('Form Design Builder', 'smart-booking-pro2');
    $menu_title = $title . (sbp2_is_enterprise_user() ? ' 🔓' : ' 🔒Enterprise');

    add_submenu_page(
        'smart_booking_db',
        $title,
        $menu_title,
        'manage_options',
        'ers-formbuilder-editor',
        sbp2_is_enterprise_user()
            ? 'ers_formbuilder_editor_page'
            : function () {
                sbp2_restricted_feature_page('enterprise');
            }
    );
}
add_action('admin_menu', 'ers_add_formbuilder_menu');





// ステータス画面の関数を読み込む  
// Load functions for the status screen
require_once plugin_dir_path(__FILE__) . 'admin-status-page.php';

add_action('admin_menu', function () {
    add_submenu_page(
        'smart_booking_db',
        __('Status', 'smart-booking-pro2'), // ← 翻訳対応
        __('Status', 'smart-booking-pro2'),
        'manage_options',
        'smart_booking_status',
        'sbp2_render_status_page'
    );
});



// イベント予約（ユーザーが予約ページとして使う）  
// Event reservation (used by users as the reservation page)
function ers_create_event_post_type() {
    $args = array(
        'label'  => __('予約・オリジナルフォーム作成', 'smart-booking-pro2'),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => false,
        'supports' => array('title', 'custom-fields'),
        'has_archive' => true,
        'rewrite' => array('slug' => 'event-reservation'),
        'show_in_rest' => false,
        'labels' => array(
            'name'               => __('予約・オリジナルフォーム作成', 'smart-booking-pro2'),
            'singular_name'      => __('フォーム', 'smart-booking-pro2'),
            'add_new'            => __('新規フォーム追加', 'smart-booking-pro2'),
            'add_new_item'       => __('フォームを追加', 'smart-booking-pro2'),
            'edit_item'          => __('フォームを編集', 'smart-booking-pro2'),
            'new_item'           => __('新しいフォーム', 'smart-booking-pro2'),
            'view_item'          => __('フォームを表示', 'smart-booking-pro2'),
            'search_items'       => __('フォームを検索', 'smart-booking-pro2'),
            'not_found'          => __('フォームが見つかりませんでした', 'smart-booking-pro2'),
            'not_found_in_trash' => __('ゴミ箱にフォームはありません', 'smart-booking-pro2'),
            'all_items'          => __('フォーム一覧', 'smart-booking-pro2'),
            'archives'           => __('フォームアーカイブ', 'smart-booking-pro2'),
        ),
    );
    register_post_type('event-reservation', $args);
}
add_action('init', 'ers_create_event_post_type');


function ers_add_event_submenu() {
    global $submenu;

    $parent_slug = 'smart_booking_db'; // ✅ 親メニュー
    $new_menu = array(
        __('予約・フォーム作成', 'smart-booking-pro2'), // ✅ メニュータイトル
        'manage_options', // ✅ 権限
        'edit.php?post_type=event-reservation', // ✅ カスタム投稿タイプの管理画面へ直接遷移
    );

    // もし $submenu が存在しなければ初期化
    if (!isset($submenu[$parent_slug])) {
        $submenu[$parent_slug] = array();
    }

    // 既存のサブメニューを取得
    $current_submenu = $submenu[$parent_slug];

    // 6番目（インデックス5）の位置に挿入
    array_splice($current_submenu, 2, 0, array($new_menu));

    // 再登録
    $submenu[$parent_slug] = $current_submenu;
}
add_action('admin_menu', 'ers_add_event_submenu', 20); // ✅ 優先度は適度に調整




// 予約済み日時（予約データを保存するカスタム投稿）  
// Reserved date and time (custom post type storing reservation data)
function ers_create_reserved_post_type() {
    $args = [
        'label'                 => __('予約済み日時', 'smart-booking-pro2'),
        'labels' => [
            'name'               => __('予約済み日時', 'smart-booking-pro2'),
            'singular_name'      => __('予約日時', 'smart-booking-pro2'),
            'add_new'            => __('新規予約を追加', 'smart-booking-pro2'),
            'add_new_item'       => __('新しい予約を追加', 'smart-booking-pro2'),
            'edit_item'          => __('予約を編集', 'smart-booking-pro2'),
            'new_item'           => __('新しい予約', 'smart-booking-pro2'),
            'view_item'          => __('予約を表示', 'smart-booking-pro2'),
            'search_items'       => __('予約を検索', 'smart-booking-pro2'),
            'not_found'          => __('予約が見つかりませんでした', 'smart-booking-pro2'),
            'not_found_in_trash' => __('ゴミ箱に予約はありません', 'smart-booking-pro2'),
            'all_items'          => __('予約一覧', 'smart-booking-pro2'),
            'archives'           => __('予約アーカイブ', 'smart-booking-pro2'),
        ],
        'public'                => false,
        'publicly_queryable'    => false,
        'exclude_from_search'   => true,
        'show_ui'               => true,
        'show_in_menu'          => 'ers-settings',
        'show_in_rest'          => false,
        'rewrite'               => false,
        'has_archive'           => false,
        'show_in_nav_menus'     => false,
        'supports'              => ['title'],
        'capability_type'       => 'post',
        'map_meta_cap'          => true,
    ];
    register_post_type('reserved-daytime', $args);
}
add_action('init', 'ers_create_reserved_post_type');


add_filter('rest_endpoints', function ($endpoints) {
    if (isset($endpoints['/wp/v2/reserved-daytime'])) {
        unset($endpoints['/wp/v2/reserved-daytime']);
    }
    return $endpoints;
});

add_action('pre_get_posts', function ($query) {
    if (is_admin() || !$query->is_main_query()) return;

    if ($query->get('post_type') === 'reserved-daytime') {
        // クエリがこの投稿タイプを対象としていたら、何も取得しないように変更
        $query->set('post_type', 'none');
    }
});



add_action('admin_init', function () {
    if (
        is_admin() &&
        isset($_GET['post_type']) &&
        $_GET['post_type'] === 'event-reservation' &&
        !sbp2_can_create_new_form()
    ) {
        if (strpos($_SERVER['REQUEST_URI'], 'post-new.php') !== false) {
            wp_die(esc_html__('無料版ではこれ以上フォームを作成できません。有料プランにアップグレードしてください。', 'smart-booking-pro2'));
        }
    }
});

add_filter('wp_insert_post_data', function ($data, $postarr) {
    if (
        $data['post_type'] === 'event-reservation' &&
        $data['post_status'] === 'auto-draft' &&
        !sbp2_can_create_new_form()
    ) {
        wp_die(esc_html__('無料版ではこれ以上フォームを作成できません。有料プランにアップグレードしてください。', 'smart-booking-pro2'));
    }
    return $data;
}, 10, 2);

add_filter('post_row_actions', 'sbp2_disable_add_new_for_free_users', 10, 2);
function sbp2_disable_add_new_for_free_users($actions, $post) {
    if ($post->post_type === 'event-reservation' && !sbp2_can_create_new_form()) {
        unset($actions['clone']); // 例：Yoast Duplicate Post プラグイン対策
    }
    return $actions;
}


add_action('admin_head', function () {
    global $typenow;

    if ($typenow !== 'event-reservation') return;

    $can_create = sbp2_can_create_new_form();
    $icon = $can_create ? '🔓' : '🔒';

    // 翻訳済みアラートメッセージを用意
    $alert_message = esc_js(__('無料版ではこれ以上フォームを作成できません。有料プランにアップグレードしてください。', 'smart-booking-pro2'));

    // JavaScript内に埋め込むクリックイベント用コード
    $js_alert_code = $can_create ? '' : "btn.addEventListener('click', function(e) {
        e.preventDefault();
        alert('{$alert_message}');
    });";

    echo <<<HTML
<script>
document.addEventListener('DOMContentLoaded', function() {
    const btn = document.querySelector('.page-title-action');
    if (!btn) return;

    // 既存の絵文字があれば削除（重複防止）
    btn.textContent = btn.textContent.replace(/^([🔓🔒])\\s*/, '');

    // 新しくアイコンを追加
    btn.textContent = '{$icon} ' + btn.textContent;

    // 有料制限時のクリックブロック
    {$js_alert_code}
});
</script>
HTML;
});




// カスタム投稿タイプ 'event-reservation' の専用テンプレートを適用  
// Apply custom template for the 'event-reservation' custom post type
function ers_load_event_reservation_template($template) {
  if (is_singular('event-reservation')) {
      $custom_template = plugin_dir_path(__FILE__) . '../templates/singles/single-event-reservation.php';
      if (file_exists($custom_template)) {
          return $custom_template;
      }
  }
  return $template;
}
add_filter('single_template', 'ers_load_event_reservation_template');


function ers_load_custom_single_template($template) {
  if (is_singular('event-reservation')) {
      $post_id = get_queried_object_id();
      $selected_template = get_field('select-single-template', $post_id);

      if ($selected_template) {
          $custom_template = plugin_dir_path(__FILE__) . '../templates/singles/' . $selected_template;
          if (file_exists($custom_template)) {
              return $custom_template;
          }
      }
  }
  return $template;
}
add_filter('single_template', 'ers_load_custom_single_template');

