<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
function ers_reservation_template_shortcode() {
    $post_id = get_queried_object_id();

    if ( empty( $post_id ) ) {

        sbp2_write_log( sprintf(

            esc_html__( '[ERROR] 投稿IDが取得できませんでした。', 'smart-booking-pro2' )
        ) );

        return '<p>' . esc_html__( '投稿が見つかりません。', 'smart-booking-pro2' ) . '</p>';
    }

    $cf7_form_id = get_post_meta( $post_id, 'designation-contactform7', true );
    if ( empty( $cf7_form_id ) ) {
        $cf7_form_id = '1234';
    }

    $calendar_display    = get_field( 'calendar-display', $post_id ) ? 1 : 0;
    $selected_template   = get_post_meta( $post_id, 'form-template-file', true );


    // `templates/forms/` ディレクトリのパスを取得
    // Get the path to the `templates/forms/` directory
    $template_dir = plugin_dir_path(dirname(__FILE__)) . 'templates/forms/';
    
    // `$selected_template` が空ならデフォルトのテンプレートを使用  
    // Use the default template if `$selected_template` is empty
    if (empty($selected_template)) {
        sbp2_write_log(esc_html__('【WARNING】テンプレートが未設定のため、デフォルトHTMLを使用します。', 'smart-booking-pro2'));

        $custom_template = '<!-- 予約システムのデフォルトHTML -->
            <div class="reservation-container modern-style" style="' . ($calendar_display ? 'display: flex;' : 'display: none;') . '">
                <div class="calendar-container">
                    <label>' . esc_html__('予約日：default', 'smart-booking-pro2') . '</label>
                    <div id="datepicker"></div>
                </div>
                <div class="time-container">
                    <label>' . esc_html__('時間帯', 'smart-booking-pro2') . '</label>
                    <select id="reservation_time" name="reservation_time" size="5">
                        <option value="">' . esc_html__('日付を選択してください。', 'smart-booking-pro2') . '</option>
                    </select>
                </div>
            </div>
            <div class="reservation-form">
                [contact-form-7 id="{CF7_ID}"]
            </div>';
    } else {
        $template_file = $template_dir . $selected_template;

        if (file_exists($template_file)) {
            sbp2_write_log(esc_html__('【INFO】テンプレートを正常に読み込みました: ', 'smart-booking-pro2') . $template_file);
            $custom_template = file_get_contents($template_file);
        } else {
            sbp2_write_log(esc_html__('【ERROR】指定されたテンプレートが見つかりません: ', 'smart-booking-pro2') . $template_file);
            $custom_template = '<!-- 予約システムのデフォルトHTML -->
                <div class="reservation-container modern-style" style="' . ($calendar_display ? 'display: flex;' : 'display: none;') . '">
                    <div class="calendar-container">
                        <label>' . esc_html__('予約日：default', 'smart-booking-pro2') . '</label>
                        <div id="datepicker"></div>
                    </div>
                    <div class="time-container">
                        <label>' . esc_html__('時間帯', 'smart-booking-pro2') . '</label>
                        <select id="reservation_time" name="reservation_time" size="5">
                            <option value="">' . esc_html__('日付を選択してください。', 'smart-booking-pro2') . '</option>
                        </select>
                    </div>
                </div>
                <div class="reservation-form">
                    [contact-form-7 id="{CF7_ID}"]
                </div>';
        }
    }


    // `{CF7_ID}` をフォームIDに置換  
    // Replace `{CF7_ID}` with the form ID
    $custom_template = str_replace('{CF7_ID}', esc_attr($cf7_form_id), $custom_template ?? '');
    // `{CALENDAR_DISPLAY}` を `display: none;` に置換  
    // Replace `{CALENDAR_DISPLAY}` with `display: none;`
    $custom_template = str_replace('{CALENDAR_DISPLAY}', ($calendar_display ? 'display: flex;' : 'display: none;'), $custom_template);

  // **do_shortcode を適用**  
  // **Apply do_shortcode**
  $output = do_shortcode($custom_template);

  return $output;
}

// ショートコード登録  
// Register shortcode
if (!is_admin()) {
    add_shortcode('ers_reservation_template', 'ers_reservation_template_shortcode');
}

function ers_smart_booking_formtemplate_shortcode() {
    $post_id = get_queried_object_id();

    if (empty($post_id)) {
        return '<p>' . esc_html__('投稿が見つかりません。', 'smart-booking-pro2') . '</p>';
    }

    $cf7_form_id = get_post_meta($post_id, 'designation-contactform7', true) ?: '1234';
    $calendar_display = get_field('calendar-display', $post_id) ? 'display: flex;' : 'display: none;';

    // ✅ 使用するロケールを取得（例：ja, en）  
    // ✅ Get the locale to use (e.g., ja, en)
    $locale = determine_locale(); // WordPress 5.0 以降推奨
    $lang_code = substr($locale, 0, 2); // 例: ja_JP → ja

    // ✅ ロケール別のテンプレートパス  
    // ✅ Template path by locale
    $base_path = plugin_dir_path(dirname(__FILE__)) . 'templates/forms/';
    $template_filename = "form-template-default-{$lang_code}.txt";
    $template_path = $base_path . $template_filename;

    // ✅ ファイルがない場合は、デフォルトの日本語テンプレートにフォールバック  
    // ✅ Fallback to the default Japanese template if the file is not found
    if (!file_exists($template_path)) {
        $template_path = $base_path . 'form-template-default-ja.txt';
        if (!file_exists($template_path)) {
            return '<p>' . esc_html__('テンプレートが見つかりません。', 'smart-booking-pro2') . '</p>';
        }
    }

    $template = file_get_contents($template_path) ?? '';

    $replacements = array(
        '{PAGE_TITLE}' => esc_html(get_the_title($post_id)),
        '{CF7_ID}' => esc_attr($cf7_form_id),
        '{ARTICLE_STYLE}' => esc_attr(get_field('style_article', $post_id) ?? ''),
        '{CONTAINER_STYLE}' => esc_attr(get_field('style_container', $post_id) ?? ''),
        '{TITLE_STYLE}' => esc_attr(get_field('style_title', $post_id) ?? ''),
        '{RESERVATION_CONTAINER_STYLE}' => esc_attr(get_field('style_reservation_container', $post_id) ?? ''),
        '{CALENDAR_CONTAINER_STYLE}' => esc_attr(get_field('style_calendar_container', $post_id) ?? ''),
        '{CALENDAR_LABEL_STYLE}' => esc_attr(get_field('style_calendar_label', $post_id) ?? ''),
        '{DATEPICKER_STYLE}' => esc_attr(get_field('style_datepicker', $post_id) ?? ''),
        '{TIME_CONTAINER_STYLE}' => esc_attr(get_field('style_time_container', $post_id) ?? ''),
        '{TIME_LABEL_STYLE}' => esc_attr(get_field('style_time_label', $post_id) ?? ''),
        '{TIME_SELECT_STYLE}' => esc_attr(get_field('style_time_select', $post_id) ?? ''),
        '{FORM_CONTAINER_STYLE}' => esc_attr(get_field('style_form_container', $post_id) ?? ''),
        '{CALENDAR_DISPLAY}' => $calendar_display,
    );

    foreach ($replacements as $placeholder => $value) {
        $template = str_replace($placeholder, $value ?: '', $template);
    }

    return do_shortcode($template);
}

add_shortcode('ers_smart_booking_formtemplate', 'ers_smart_booking_formtemplate_shortcode');


/**
 * wp_head に Google Fonts を出力  
 * Output Google Fonts in wp_head
 */
function ers_enqueue_google_font() {
    $font = get_option('ers_selected_google_font');
    if ($font) {
        $url_font = str_replace(' ', '+', $font);
        wp_enqueue_style(
            'ers-google-font',
            'https://fonts.googleapis.com/css2?family=' . esc_attr($url_font) . '&display=swap',
            [],
            null
        );
    }
}
add_action('wp_enqueue_scripts', 'ers_enqueue_google_font');



