<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * サンプル予約投稿を作成  
 * Create a sample reservation post
 */
function ers_create_sample_event_reservation() {
    $existing_posts = get_posts([
        'post_type'      => 'event-reservation',
        'post_status'    => 'any',
        'posts_per_page' => 1,
    ]);

    if (!empty($existing_posts)) {
        return;
    }

    $post_id = wp_insert_post([
        'post_title'   => __('Sample Reservation Page', 'smart-booking-pro2'),
        'post_content' => __('The reservation form will be displayed on this page.', 'smart-booking-pro2'),
        'post_status'  => 'draft',
        'post_type'    => 'event-reservation',
        'post_name'    => 'sample-reservation',
    ]);

    if ($post_id && !is_wp_error($post_id)) {
        update_post_meta($post_id, 'event-days-start', date('Y-m-d'));
        update_post_meta($post_id, 'event-days-end', date('Y-m-d', strtotime('+30 days')));
        update_post_meta($post_id, 'start-time', '09:00');
        update_post_meta($post_id, 'end-time', '18:00');
        update_post_meta($post_id, 'interval-time', 30);
        update_post_meta($post_id, 'max-day-reserved', 10);
        update_post_meta($post_id, 'max-time-reserved', 3);
    }
}

add_action('init', function () {
    if (get_option('ers_needs_initial_sample_post')) {
        if (post_type_exists('event-reservation')) {
            ers_create_sample_event_reservation();
            flush_rewrite_rules();
            delete_option('ers_needs_initial_sample_post');
        }
    }
});

function sbp2_create_thanks_page() {
    $slug = 'sample-thanks';

    $existing_page = get_page_by_path($slug, OBJECT, 'page');

    if (!$existing_page) {
        $page_id = wp_insert_post([
            'post_title'     => __('Sample Thanks', 'smart-booking-pro2'),
            'post_name'      => $slug,
            'post_status'    => 'publish',
            'post_type'      => 'page',
            'post_content'   => '',
            'comment_status' => 'closed',
        ]);

        if ($page_id && !is_wp_error($page_id)) {
            update_post_meta($page_id, '_wp_page_template', 'sbp2/page-thanks.php');
        }
    }
}

function sbp2_register_page_template($templates) {
    $templates['sbp2/page-thanks.php'] = __('Thanks Page (SBP2)', 'smart-booking-pro2');
    return $templates;
}

function sbp2_load_custom_page_template($template) {
    if (is_page()) {
        $current_template = get_post_meta(get_queried_object_id(), '_wp_page_template', true);
        if ($current_template === 'sbp2/page-thanks.php') {
            $plugin_template = plugin_dir_path(__FILE__, 2) . 'templates/thanks/page-thanks.php';
            if (file_exists($plugin_template)) {
                return $plugin_template;
            }
        }
    }
    return $template;
}
