<?php

if (!defined('ABSPATH')) {
    exit;
}

if (!function_exists('sbp2_write_log')) {
    function sbp2_write_log($message) {
        $datetime = date_i18n('Y-m-d H:i:s');
        $date_str = date('Y-m-d');
        $formatted = "[{$datetime}] [SBP2] {$message}\n";
        $max_size = 1048576; // 1MB

        $plugin_log_dir = plugin_dir_path(__FILE__) . 'logs';
        $plugin_log_file = "{$plugin_log_dir}/sbp2-{$date_str}.log";

        if (!file_exists($plugin_log_dir)) {
            @mkdir($plugin_log_dir, 0755, true);
        }

        $write_success = false;

        if (is_writable($plugin_log_dir) || (!file_exists($plugin_log_file) && is_writable(dirname($plugin_log_file)))) {
            if (file_exists($plugin_log_file) && filesize($plugin_log_file) > $max_size) {
                $backup = "{$plugin_log_dir}/sbp2-{$date_str}-" . date('His') . '.bak';
                @rename($plugin_log_file, $backup);
                file_put_contents(
                    $plugin_log_file,
                    sprintf("=== %s: %s ===\n", esc_html__('Log rotated', 'smart-booking-pro2'), $date_str),
                    FILE_APPEND | LOCK_EX
                );
            }

            $write_success = (bool) @file_put_contents($plugin_log_file, $formatted, FILE_APPEND | LOCK_EX);
        }

        // fallback: wp_upload_dir へ保存
        if (!$write_success) {
            $upload_dir = wp_upload_dir();
            if (!empty($upload_dir['basedir']) && is_dir($upload_dir['basedir'])) {
                $fallback_dir = trailingslashit($upload_dir['basedir']) . 'smart-booking-pro2/logs';
                $fallback_file = "{$fallback_dir}/sbp2-{$date_str}.log";

                if (!file_exists($fallback_dir)) {
                    @wp_mkdir_p($fallback_dir);
                }

                if (file_exists($fallback_file) && filesize($fallback_file) > $max_size) {
                    $backup = "{$fallback_dir}/sbp2-{$date_str}-" . date('His') . '.bak';
                    @rename($fallback_file, $backup);
                    file_put_contents(
                        $fallback_file,
                        sprintf("=== %s: %s ===\n", esc_html__('Log rotated', 'smart-booking-pro2'), $date_str),
                        FILE_APPEND | LOCK_EX
                    );
                }

                @file_put_contents($fallback_file, $formatted, FILE_APPEND | LOCK_EX);
            }
        }
    }
}
