<?php
if (!defined('ABSPATH')) {
    exit;
}
// 権限の付与  
// Grant permissions

/**
 * カスタム権限を追加（初回インストールまたはバージョン更新時に実行）  
 * Add custom capabilities (executed on initial install or version update)
 */
function ers_add_custom_capabilities() {
    $admin = get_role('administrator');
    if ($admin) {
        $admin->add_cap('smart_booking_pro');
        $admin->add_cap('smart_booking_template_edit');
        $admin->add_cap('smart_booking_line_connect');
        $admin->add_cap('smart_booking_form_css');
        $admin->add_cap('smart_booking_restricted_manage');
    }

    $editor = get_role('editor');
    if ($editor) {
        $editor->add_cap('smart_booking_manage_forms');
        $editor->add_cap('smart_booking_manage_emails');
    }

    $author = get_role('author');
    if ($author) {
        $author->add_cap('smart_booking_create_form');
        $author->add_cap('smart_booking_edit_own_data');
    }

   // 🔠 国際化対応の権限ラベルを登録（オプション。管理画面等で使用する場合）  
    // 🔠 Register translatable capability labels (optional, used in admin screens, etc.)
    $labels = [
        'smart_booking_pro'               => __('Use PRO version features', 'smart-booking-pro2'),
        'smart_booking_template_edit'     => __('Edit email templates', 'smart-booking-pro2'),
        'smart_booking_line_connect'      => __('Connect with LINE account', 'smart-booking-pro2'),
        'smart_booking_form_css'          => __('Customize form design (CSS)', 'smart-booking-pro2'),
        'smart_booking_restricted_manage' => __('Access restricted settings', 'smart-booking-pro2'),
        'smart_booking_manage_forms'      => __('Manage forms', 'smart-booking-pro2'),
        'smart_booking_manage_emails'     => __('Manage email templates', 'smart-booking-pro2'),
        'smart_booking_create_form'       => __('Create own form', 'smart-booking-pro2'),
        'smart_booking_edit_own_data'     => __('Edit own submitted data', 'smart-booking-pro2'),
    ];
    update_option('sbp2_capability_labels', $labels);
}

/**
* カスタム権限を削除（アンインストール時など）  
* Remove custom capabilities (e.g., during uninstallation)
 */
function ers_remove_custom_capabilities() {
    $roles = ['administrator', 'editor', 'author'];
    $caps = [
        'smart_booking_pro',
        'smart_booking_template_edit',
        'smart_booking_line_connect',
        'smart_booking_form_css',
        'smart_booking_restricted_manage',
        'smart_booking_manage_forms',
        'smart_booking_manage_emails',
        'smart_booking_create_form',
        'smart_booking_edit_own_data',
    ];

    foreach ($roles as $role_name) {
        $role = get_role($role_name);
        if ($role) {
            foreach ($caps as $cap) {
                $role->remove_cap($cap);
            }
        }
    }

    delete_option('sbp2_capability_labels');
}
