<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// リマインダー送信処理  
// Reminder sending process
function ers_send_reminders() {
    $current_time = current_time('timestamp');

    $args = [
        'post_type'      => 'reserved-daytime',
        'post_status'    => 'any',
        'posts_per_page' => -1,
        'meta_query'     => [
            'relation' => 'AND',
            [
                'key'     => 'reminder_enabled',
                'value'   => '1',
                'compare' => '='
            ],
            [
                'key'     => 'reminder_sent',
                'compare' => 'NOT EXISTS'
            ]
        ]
    ];

    $reservations = get_posts($args);

    foreach ($reservations as $reservation) {
        $post_id           = $reservation->ID;
        $user_email        = get_field('reserved-user-email', $post_id);
        $event_name        = get_field('event-name', $post_id);
        $reserved_day      = get_field('reserved-day', $post_id);
        $reserved_time     = get_field('reserved-time', $post_id);
        $reminder_time     = get_field('reminder_time', $post_id) ?: 60;
        $reminder_template = get_field('reminder_template', $post_id) ?: 'reminder-reservation-default.txt'; // ← ✅ typo修正

        $reservation_datetime = strtotime("$reserved_day $reserved_time");
        $reminder_timestamp   = $reservation_datetime - ($reminder_time * 60);

        if ($current_time < $reminder_timestamp) {
            continue;
        }

        $template_path = plugin_dir_path(__FILE__) . '../templates/reminders/' . $reminder_template;
        if (!file_exists($template_path)) {
            continue;
        }

        $email_body = file_get_contents($template_path);
        $email_body = mb_convert_encoding($email_body, 'UTF-8', mb_detect_encoding($email_body, 'UTF-8, SJIS, EUC-JP, JIS, ASCII', true));

        // 件名（テンプレートに Subject: 行があれば優先）  
        // Subject (prioritize the "Subject:" line in the template if present)
        $subject = sprintf(__('【リマインダー】%s のご予約について', 'smart-booking-pro2'), $event_name);
        if (preg_match('/^Subject:\s*(.+)/m', $email_body, $matches)) {
            $subject = trim($matches[1]);
            $email_body = preg_replace('/^Subject:\s*(.+)\n?/m', '', $email_body);
        }

        // プレースホルダー抽出と置換  
        // Extract and replace placeholders
        preg_match_all('/\{[ ]*([a-zA-Z0-9_\-]+)[ ]*\}/', $email_body . $subject, $matches);
        $all_keys = array_unique($matches[1]);

        $placeholders = [];
        foreach ($all_keys as $key) {
            $acf_key = str_replace('_', '-', $key);
            $value   = get_field($acf_key, $post_id);
            if (is_array($value)) {
                $value = implode(', ', $value);
            }
            $value = $value ?: '';
            $placeholders["{{$key}}"]    = $value;
            $placeholders["{ $key }"]    = $value;
        }

        $email_body = str_replace(array_keys($placeholders), array_values($placeholders), $email_body ?? '');
        $subject    = str_replace(array_keys($placeholders), array_values($placeholders), $subject ?? '');

        // Content-Type 設定  
        // Set Content-Type
        $content_type = (strpos($reminder_template, '.html') !== false) ? 'text/html' : 'text/plain';
        $headers = ['Content-Type: ' . $content_type . '; charset=UTF-8'];

        // メール送信 & 送信済みフラグ  
        // Send email & set sent flag
        if (wp_mail($user_email, $subject, $email_body, $headers)) {
            update_field('reminder_sent', 1, $post_id);
        }
    }
}
