(function($) {
  // ✅ フォールバック辞書を取得  
// ✅ Retrieve fallback dictionary
  const fallback = window['sbp2_i18n_fallback_admin_post_editor'] || {};

  // ✅ ハイブリッド翻訳関数：__() → fallback の順に参照  
// ✅ Hybrid translation function: Refer to __() then fallback
  function T__(text) {
    if (typeof wp !== 'undefined' && typeof wp.i18n?.__ === 'function') {
      const result = wp.i18n.__(text, 'smart-booking-pro2'); // ✅ 正しい呼び出し
      if (result !== text) return result;
    }
    return fallback[text]?.[1] || text;
  }

document.addEventListener('DOMContentLoaded', function () {
    // 「公開」ボタンを非表示  
// Hide the "Publish" button
    const publishButton = document.querySelector('#publish');
    if (publishButton) {
        publishButton.style.display = 'none';
    }

    // 「下書きとして保存」ボタンのラベルを「保存」に変更  
// Change label of "Save as Draft" button to "Save"
    const saveDraftButton = document.querySelector('#save-post');
    if (saveDraftButton) {
        saveDraftButton.value = T__('保存'); // 国際化対応
    }

    // ✅ 「ステータス / 公開範囲 / 日時」 のセクションを非表示  
// ✅ Hide the "Status / Visibility / Date" section
    const miscPubSections = document.querySelectorAll('#misc-publishing-actions .misc-pub-section');
    miscPubSections.forEach(el => {
        el.style.display = 'none';
    });

    // ✅ 「編集」リンク全般を非表示（念のため）  
// ✅ Hide all "Edit" links (just in case)
    const editLinks = document.querySelectorAll('.edit-timestamp, .edit-visibility, .edit-status');
    editLinks.forEach(el => {
        el.style.display = 'none';
    });
});

})(jQuery);