(function($) {
  // ✅ フォールバック辞書を取得  
// ✅ Retrieve fallback dictionary
  const fallback = window['sbp2_i18n_fallback_script_admin'] || {};

  // ✅ ハイブリッド翻訳関数：__() → fallback の順に参照  
// ✅ Hybrid translation function: Refer to __() then fallback
  function T__(text) {
    if (typeof wp !== 'undefined' && typeof wp.i18n?.__ === 'function') {
      const result = wp.i18n.__(text, 'smart-booking-pro2'); // ✅ 正しい呼び出し
      if (result !== text) return result;
    }
    return fallback[text]?.[1] || text;
  }



document.addEventListener("DOMContentLoaded", function () {
    const cf7FormSelect = document.getElementById("cf7-form-select");
    const displayButton = document.querySelector("button[name='convert_cf7_to_db']");
    const postTypeInput = document.querySelector("#cf7-form-select-container input[name='post_type_name']");
    const groupNameInput = document.querySelector("#cf7-form-select-container input[name='acf_group_name']");
    const fieldContainer = document.getElementById("cf7-acf-fields");

    if (!cf7FormSelect || !displayButton) {
        console.error(T__('CF7フォームの選択または表示ボタンが見つかりません。'));
        return;
    }

    displayButton.addEventListener("click", function (event) {
        event.preventDefault(); // フォーム送信を防ぐ
        console.log("表示ボタンがクリックされました！");

        const formId = cf7FormSelect.value;
        if (!formId) {
            alert(T__('フォームを選択してください。'));
            return;
        }

        jQuery.ajax({
            url: smart_booking_vars.ajaxurl, // WordPressのAJAX URL
            type: "POST",
            data: {
                action: "smart_booking_cf7_to_acf",
                form_id: formId,
                nonce: smart_booking_vars.nonce, // セキュリティ用
            },
            beforeSend: function () {
                console.log("AJAXリクエストを送信中...");
            },
            success: function (response) {
                console.log("AJAXレスポンス:", response);
                if (response.success) {
                    alert(T__('データ取得成功！'));

                    // 📌 **投稿タイプ名とACFグループ名をセット**
                    const timestamp = new Date().getTime().toString().slice(-6);
                    if (postTypeInput) {
                        postTypeInput.value = "s" + timestamp;
                    }
                    if (groupNameInput) {
                        groupNameInput.value = "g" + timestamp;
                    }

                    // **既存の一覧をクリア**
                    fieldContainer.innerHTML = "";

                    // タイトル
                    const title = document.createElement("h3");
                    title.textContent = T__('取得したフィールド一覧');
                    fieldContainer.appendChild(title);

                    // フィールドタイプのオプションリスト
                    const fieldTypeOptions = `
                    <option value="text">${T__('文字（text）')}</option>
                    <option value="number">${T__('数字（number）')}</option>
                    <option value="textarea">${T__('文章（textarea）')}</option>
                    <option value="email">${T__('メール（email）')}</option>
                    <option value="date_picker">${T__('日付（date_picker, y-m-d）')}</option>
                    <option value="time_picker">${T__('時間（time_picker, H:i）')}</option>
                    <option value="true_false">${T__('真偽（true_false）')}</option>
                    `;

                    response.data.fields.forEach(field => {
                        fieldContainer.appendChild(createFieldElement(field.name, field.type, fieldTypeOptions));
                    });

                    if (!document.getElementById("add-field-2")) {
                        const addFieldButton = document.createElement("button");
                        addFieldButton.id = "add-field-2";
                        addFieldButton.textContent = T__('＋ フィールド追加');
                        addFieldButton.style = "display: block; width: fit-content; margin: 20px 0; background: #5bc0de; color: #fff; border: none; padding: 10px 15px; border-radius: 4px; cursor: pointer;";
                        fieldContainer.appendChild(addFieldButton);

                        addFieldButton.addEventListener("click", function () {
                            const newField = createFieldElement("", "text", fieldTypeOptions);
                            fieldContainer.insertBefore(newField, addFieldButton); // 📌 **追加ボタンの前に挿入**
                        });
                    }

                    if (!document.getElementById("db-create-button")) {
                        const dbCreateButton = document.createElement("input");
                        dbCreateButton.type = "submit";
                        dbCreateButton.name = "db-create-button";
                        dbCreateButton.id = "db-create-button";
                        dbCreateButton.value = T__('DB作成');
                        dbCreateButton.style = "background: #5cb85c; color: #fff; border: none; padding: 10px 15px; border-radius: 4px; cursor: pointer;";
                        fieldContainer.appendChild(dbCreateButton);
                    }


                } else {
                    alert(T__('エラー: ') + response.data.message);
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAXエラー:", error);
                alert(T__('リクエストに失敗しました。'));
            },
        });
    });

    // 📌 **新しいフィールドを作成する関数**  
    // 📌 **Function to create new fields**
    function createFieldElement(name, type, fieldTypeOptions) {
        const fieldDiv = document.createElement("div");
        fieldDiv.classList.add("acf-field-2");
        fieldDiv.style.display = "flex";
        fieldDiv.style.gap = "10px";
        fieldDiv.style.alignItems = "center";
        fieldDiv.style.marginBottom = "10px";

        fieldDiv.innerHTML = `
            <input type="text" name="acf_field_name[]" value="${name}" required style="flex: 2; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
            <select name="acf_field_type[]" style="flex: 1; padding: 8px; border: 1px solid #ccc; border-radius: 4px;">
                ${fieldTypeOptions.replace(`value="${type}"`, `value="${type}" selected`)}
            </select>
            <button type="button" class="remove-field" style="background: #d9534f; color: #fff; border: none; padding: 8px 12px; border-radius: 4px; cursor: pointer;">${T__('削除')}</button>
        `;

        fieldDiv.querySelector(".remove-field").addEventListener("click", function () {
            fieldDiv.remove();
        });

        return fieldDiv;
    }
    
});


document.addEventListener("DOMContentLoaded", function () {
    console.log("📌 Create CF7 - ACF フィールド取得スクリプトが読み込まれました");

    const fetchButton = document.getElementById("fetch-acf-fields");
    const postTypeSelect = document.getElementById("post-type-select");
    const cf7FieldsContainer = document.getElementById("cf7-fields-container");
    const cf7FormContainer = document.getElementById("cf7-form-container");

    if (!fetchButton || !postTypeSelect || !cf7FieldsContainer) {
        console.warn("⚠️ 必要な要素が見つかりません（Create CF7）。スクリプトを終了します。");
        return;
    }

    fetchButton.addEventListener("click", function () {
        const postType = postTypeSelect.value;
        if (!postType) {
            alert(T__('投稿タイプを選択してください。'));
            return;
        }

        jQuery.ajax({
            url: smart_booking_vars.ajaxurl,
            type: "POST",
            data: {
                action: "smart_booking_get_acf_fields",
                post_type: postType,
                nonce: smart_booking_vars.nonce,
            },
            beforeSend: function () {
                cf7FieldsContainer.innerHTML = `<p>${T__('データ取得中...')}</p>`;
                console.log("📤 ACF フィールド取得リクエスト送信:", { postType });
            },
            success: function (response) {
                console.log("📥 ACF フィールド取得レスポンス:", response);
                if (response.success) {
                    cf7FieldsContainer.innerHTML = ""; // ✅ まずクリアする
                    cf7FormContainer.style.display = "block"; // ✅ UI を表示

                    const excludedFields = [
                        "event-id", "event-name", "reserved-auto-accept", "confirmation-email-enabled", 
                        "confirmation_template", "reminder_enabled", "reminder_time", "reminder_template"
                    ];

                    response.data.fields.forEach(field => {
                        if (excludedFields.includes(field.name)) return; // ✅ 指定されたフィールドはスキップ

                        const fieldDiv = document.createElement("div");
                        fieldDiv.classList.add("cf7-field");
                        fieldDiv.style.display = "flex";
                        fieldDiv.style.gap = "10px";
                        fieldDiv.style.marginBottom = "10px";
                        fieldDiv.style.alignItems = "center"; // ✅ 縦のズレを防ぐ

                        // ✅ すべての要素の幅を統一
                        const unifiedWidth = "width: 150px; flex-shrink: 0;";

                        fieldDiv.innerHTML = `
                            <input type="text" name="acf_field_label[]" value="${field.label}" style="${unifiedWidth}">
                            <input type="checkbox" name="required_field[]"> ${T__('必')}
                            <input type="checkbox" name="hidden_field[]"> ${T__('隠')}
                            <select name="acf_field_type[]" style="${unifiedWidth}">
                                <option value="${field.type}" selected>${field.type}</option>
                            </select>
                            <input type="text" name="acf_field_name[]" value="${field.name}" readonly style="${unifiedWidth}">
                            <input type="text" name="class_name[]" placeholder="${T__('クラス名')}" style="${unifiedWidth}">
                            <input type="text" name="id_name[]" placeholder="${T__('ID名')}" style="${unifiedWidth}">
                            ${field.type === "text" || field.type === "email" || field.type === "number" ? `<input type="text" name="placeholder[]" placeholder="${T__('プレースホルダー')}" style="${unifiedWidth}">` : ''}
                            ${field.type === "checkbox" || field.type === "radio" || field.type === "select" ? `<input type="text" name="options[]" placeholder="${T__('選択項目（カンマ区切り）')}" style="${unifiedWidth}">` : ''}
                            <input type="text" name="default_value[]" placeholder="${T__('初期値')}" style="${unifiedWidth}">
                        `;

                        cf7FieldsContainer.appendChild(fieldDiv);
                    });
                } else {
                    cf7FieldsContainer.innerHTML = `<p>${T__('データが見つかりません。')}</p>`;
                }
            },
            error: function (xhr, status, error) {
                console.error("❌ ACF フィールド取得エラー:", xhr.responseText);
                cf7FieldsContainer.innerHTML = `<p>${T__('エラーが発生しました。')}</p>`;
            },
        });
    });
});





// フィールド追加処理  
// Field addition process
document.addEventListener("DOMContentLoaded", function () {
    const addFieldButton = document.getElementById("add-cf7-field");
    const cf7FieldsContainer = document.getElementById("cf7-fields-container");

    if (!addFieldButton || !cf7FieldsContainer) {
        console.warn(T__('⚠️ フィールド追加ボタン または フィールドコンテナが見つかりません。'));
        return;
    }

    addFieldButton.addEventListener("click", function () {
        console.log(T__('➕ フィールド追加ボタンが押されました！'));

        // 📌 **新しいフィールド行を作成**
        const fieldRow = document.createElement("div");
        fieldRow.style.display = "grid";
        fieldRow.style.gridTemplateColumns = "repeat(12, 1fr)";
        fieldRow.style.gap = "10px";
        fieldRow.style.marginBottom = "10px";

        fieldRow.innerHTML = `
            <div><input type="text" name="acf_field_label[]" placeholder="${T__('ラベル名（任意）')}"></div>
            <div style="display: flex; align-items: center;">
                <input type="checkbox" name="required_field[]" title="${T__('必須')}" id="required-${Date.now()}">
                <label for="required-${Date.now()}" style="margin-left: 5px;">${T__('必')}</label>
            </div>
            <div style="display: flex; align-items: center;">
                <input type="checkbox" name="hidden_field[]" title="${T__('隠しフィールド')}" id="hidden-${Date.now()}">
                <label for="hidden-${Date.now()}" style="margin-left: 5px;">${T__('隠')}</label>
            </div>
            <div>
                <select name="acf_field_type[]" class="acf-field-type" title="${T__('フィールドタイプ')}">
                    <option value="" selected>${T__('フィールドタイプを選択')}</option>
                    <option value="text">${T__('テキスト')}</option>
                    <option value="textarea">${T__('テキストエリア')}</option>
                    <option value="email">${T__('メール')}</option>
                    <option value="tel">${T__('電話')}</option>
                    <option value="number">${T__('数字')}</option>
                    <option value="date">${T__('日付')}</option>
                    <option value="checkbox">${T__('チェックボックス')}</option>
                    <option value="radio">${T__('ラジオボタン')}</option>
                    <option value="select">${T__('セレクトボックス')}</option>
                </select>
            </div>
            <div><input type="text" name="acf_field_name[]" placeholder="${T__('フィールド名（必須）')}" required></div>
            <div><input type="text" name="class_name[]" placeholder="${T__('クラス名（オプション）')}"></div>
            <div><input type="text" name="id_name[]" placeholder="${T__('ID名（オプション）')}"></div>
            <div><input type="text" name="options[]" placeholder="${T__('選択肢（カンマ区切り）')}" disabled></div>
            <div><input type="text" name="placeholder[]" placeholder="${T__('プレースホルダー')}" disabled></div>
            <div><input type="text" name="default_value[]" placeholder="${T__('初期値')}" disabled></div>
            <div><input type="checkbox" name="wrap_with_label[]" title="${T__('選択項目をラベルで囲う')}"></div>
            <div><button type="button" class="remove-field">${T__('🗑')}</button></div>
        `;

    

        // 📌 **フィールドタイプ変更時の挙動**  
        // 📌 **Behavior when field type is changed**
        const fieldTypeSelect = fieldRow.querySelector(".acf-field-type");
        fieldTypeSelect.addEventListener("change", function () {
            updateFieldControls(fieldRow, fieldTypeSelect.value);
        });


        fieldRow.querySelector(".remove-field").addEventListener("click", function () {
            console.log(T__('🗑 フィールドが削除されました！'));
            fieldRow.remove();
        });

        // 📌 **コンテナに追加**  
        // 📌 **Add to container**
        cf7FieldsContainer.appendChild(fieldRow);
    });

    // 📌 **フィールドタイプに応じたコントロールの更新**  
    // 📌 **Update controls based on field type**
    function updateFieldControls(fieldRow, fieldType) {
        const optionsInput = fieldRow.querySelector("input[name='options[]']");
        const placeholderInput = fieldRow.querySelector("input[name='placeholder[]']");
        const defaultValueInput = fieldRow.querySelector("input[name='default_value[]']");
        const wrapWithLabelInput = fieldRow.querySelector("input[name='wrap_with_label[]']"); // ✅ 追加

        if (["checkbox", "radio", "select"].includes(fieldType)) {
            optionsInput.disabled = false;
            placeholderInput.disabled = true;
            defaultValueInput.disabled = true;
        } else if (["text", "textarea", "email", "tel", "number", "date"].includes(fieldType)) {
            optionsInput.disabled = true;
            placeholderInput.disabled = false;
            defaultValueInput.disabled = false;
        } else {
            optionsInput.disabled = true;
            placeholderInput.disabled = true;
            defaultValueInput.disabled = true;
        }

        // ✅ **ラジオボタン・チェックボックスの時だけ wrap_with_label を有効**  
        // ✅ **Enable wrap_with_label only for radio buttons and checkboxes**
        if (["radio", "checkbox"].includes(fieldType)) {
            wrapWithLabelInput.disabled = false;
        } else {
            wrapWithLabelInput.disabled = true;
            wrapWithLabelInput.checked = false; // ✅ 他のフィールドに変更された時にチェックを外す
        }
    }

});

document.addEventListener("DOMContentLoaded", function () {
    const cf7CreateButton = document.getElementById("cf7-create-button");

    if (!cf7CreateButton) {
        console.warn("⚠️ CF7作成ボタンが見つかりません。");
        return;
    }

    cf7CreateButton.addEventListener("click", function () {
        console.log("📤 CF7フォーム作成ボタンが押されました！");

        // 📌 **フォームの基本設定を取得**
        const formName = document.getElementById("cf7-form-name")?.value.trim();
        const adminEmail = document.getElementById("cf7-admin-email")?.value.trim();
        const fromEmail = document.getElementById("cf7-from-email")?.value.trim();
        const emailSubject = document.getElementById("cf7-email-subject")?.value.trim();
        const additionalHeaders = document.getElementById("cf7-additional-headers")?.value.trim();
        
        // ✅ **管理者メールの冒頭文と締めの文章を取得**
        const adminMailIntro = document.getElementById("cf7-admin-mail-intro")?.value.trim();
        const adminMailClosing = document.getElementById("cf7-admin-mail-closing")?.value.trim();

        if (!formName) {
            alert(T__('⚠️ フォーム名を入力してください！'));
            return;
        }

        // 📌 **フィールドデータを収集**  
        // 📌 **Collect field data**
        const fields = [];
        document.querySelectorAll("#cf7-fields-container div").forEach(fieldRow => {
            const fieldInput = fieldRow.querySelector("input[name='acf_field_name[]']");
            if (!fieldInput) return; // ⚠️ 要素が存在しない場合はスキップ
            
            const fieldName = fieldInput.value.trim();
            if (!fieldName) return; // ⚠️ フィールド名が未入力の行は無視

            
            const fieldTypeElement = fieldRow.querySelector("select[name='acf_field_type[]']");
            const fieldType = fieldTypeElement ? fieldTypeElement.options[fieldTypeElement.selectedIndex].value.trim() : "";


            if (!fieldType) {
                console.warn(`⚠️ スキップ: フィールドタイプが未選択のフィールド`);
                return;
            }

            fields.push({
                label: fieldRow.querySelector("input[name='acf_field_label[]']")?.value.trim() || "",
                required: fieldRow.querySelector("input[name='required_field[]']")?.checked || false,
                hidden: fieldRow.querySelector("input[name='hidden_field[]']")?.checked || false,
                type: fieldType, // ✅ ここが修正ポイント
                name: fieldName,
                className: fieldRow.querySelector("input[name='class_name[]']")?.value.trim() || "",
                idName: fieldRow.querySelector("input[name='id_name[]']")?.value.trim() || "",
                placeholder: fieldRow.querySelector("input[name='placeholder[]']")?.value.trim() || "",
                options: fieldRow.querySelector("input[name='options[]']")?.value.trim() || "",
                defaultValue: fieldRow.querySelector("input[name='default_value[]']")?.value.trim() || "",
                wraplabel: fieldRow.querySelector("input[name='wrap_with_label[]']")?.checked || false,
            });
        });

        if (fields.length === 0) {
            alert(T__('⚠️ 少なくとも1つのフィールドを追加してください！'));
            return;
        }

        jQuery.ajax({
            url: smart_booking_vars.ajaxurl,
            type: "POST",
            data: {
                action: "smart_booking_create_cf7_form",
                nonce: smart_booking_vars.nonce,
                form_name: formName,
                admin_email: adminEmail,
                from_email: fromEmail,
                email_subject: emailSubject,
                additional_headers: additionalHeaders,
                admin_mail_intro: adminMailIntro, // ✅ 追加
                admin_mail_closing: adminMailClosing, // ✅ 追加
                fields: fields,
            },
            beforeSend: function () {
                console.log("📤 CF7 フォーム作成リクエスト送信...");
            },
            success: function (response) {
                console.log("📥 CF7 フォーム作成レスポンス:", response);
                if (response.success) {
                    alert( T__( '✅ CF7フォーム「') + formName + T__('」を作成しました！') );
                    location.reload();
                } else {
                    alert(T__('⚠️ エラー: ') + response.data.message);
                }
            },
            error: function (xhr) {
                console.error("❌ CF7作成エラー:", xhr.responseText);
                alert(T__('⚠️ リクエストに失敗しました。'));
            },
        });
    });
});

document.addEventListener("DOMContentLoaded", function () {
    const deleteForms = document.querySelectorAll(".delete-post-type-form");
  
    deleteForms.forEach(form => {
      form.addEventListener("submit", function (e) {
        const postType = form.dataset.postType;
        const confirmMessage = T__('本当に削除しますか？') + '\n' + postType + T__(' に関連するすべてのデータが削除されます。');
        if (!confirm(confirmMessage)) {
          e.preventDefault(); // キャンセル時は送信しない
        }
      });
    });
  });
  

  window._originalConfirm = window.confirm;
  window._confirmOnce = false;
  
  window.confirm = function(message) {
      if (window._confirmOnce) return true; // 2回目以降はスルー
      window._confirmOnce = true;
  
      const result = window._originalConfirm(message);
      if (!result) {
          window._confirmOnce = false; // キャンセルされたらリセット
      }
      return result;
  };
  

})(jQuery);