<?php
function sbp2_enqueue_i18n_fallback($js_name = 'script-admin') {
    $locale = determine_locale(); // ex: 'ja', 'en_US'
    $dict_file = "i18n-fallback_{$js_name}_{$locale}.js";

    // ✅ __DIR__ はこのファイル自身が入ってる「languages/fallback/」
    $dict_path = __DIR__ . '/' . $dict_file;
    $dict_url  = plugin_dir_url(dirname(__DIR__)) . 'languages/fallback/' . $dict_file;

    if (file_exists($dict_path)) {
        wp_enqueue_script(
            "sbp2-i18n-fallback-{$js_name}",
            $dict_url,
            [],
            filemtime($dict_path),
            true
        );
    }
}
