<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// ACFからカスタムヘッダー・フッターの設定を取得
$custom_header = get_field('designation-header-name', get_the_ID()) ?? '';
$custom_footer = get_field('designation-footer-name', get_the_ID()) ?? '';

$custom_header_path = $custom_header ? get_stylesheet_directory() . "/header-{$custom_header}.php" : '';
$custom_footer_path = $custom_footer ? get_stylesheet_directory() . "/footer-{$custom_footer}.php" : '';

// ヘッダーを適用
if ($custom_header && file_exists($custom_header_path)) {
    get_header($custom_header);
} else {
    get_header();
}

?>


<!--***********************************************************************************************************************-->

<!--Start 実際のフォーム表示個所：formのテンプレートが反映される-->
<?php
        if (have_posts()) :
            while (have_posts()) : the_post();
                echo do_shortcode('[ers_smart_booking_formtemplate]');
            endwhile;
        endif;
?>
<!--END 実際のフォーム表示個所-->

<!--***********************************************************************************************************************-->

<!-- フッターを適用 -->
<?php
if ($custom_footer && file_exists($custom_footer_path)) {
    get_footer($custom_footer);
} else {
    get_footer();
}
?>

