<?php
/* Template Name: Thanks Page */
if (!defined('ABSPATH')) exit;

// ✅ GETパラメータの取得（ヘッダー/フッター名）  
// ✅ Used for display control only, no persistence or sensitive action
$custom_header = sanitize_text_field(wp_unslash($_GET['header'] ?? ''));
$custom_footer = sanitize_text_field(wp_unslash($_GET['footer'] ?? ''));

$custom_header_path = $custom_header ? get_stylesheet_directory() . "/header-{$custom_header}.php" : '';
$custom_footer_path = $custom_footer ? get_stylesheet_directory() . "/footer-{$custom_footer}.php" : '';

if ($custom_header && file_exists($custom_header_path)) {
    get_header($custom_header);
} else {
    get_header();
}
?>

<style>
.thanks-page {
  display: flex;
  justify-content: center;
  align-items: center;
  min-height: 50vh;
  text-align: center;
  flex-direction: column;
  padding: 40px 20px;
  background-color:#fcfcfc;
}

.thanks-page h1 {
  font-size: 2.5rem;
  margin-bottom: 1rem;
}

.thanks-page p {
  font-size: 1.2rem;
  margin-bottom: 2rem;
}

.thanks-page a {
  display: inline-block;
  padding: 12px 24px;
  background-color: #21759b;
  color: #fff;
  text-decoration: none;
  border-radius: 5px;
  font-weight: bold;
}

.thanks-page a:hover {
  background-color: #1d6b8f;
}

.fv-thanks {
  width: 100%;
  max-height: 600px;
  object-fit: cover;
}
</style>

<!-- 🔽 ファーストビュー画像 -->
<?php
$plugin_img_url = plugin_dir_url(dirname(dirname(__FILE__))) . 'assets/img/fv-thanks.png';
?>
<img src="<?php echo esc_url($plugin_img_url); ?>" alt="Thanks Visual" class="fv-thanks" />


<!-- 🔽 Thanksエリア -->
<main class="thanks-page">
    <div class="container">
        <h1>予約完了</h1>
        <p>ご予約いただきありがとうございます！</p>
        <a href="<?php echo home_url(); ?>">トップページへ戻る</a>

        <!-- ✅ カレンダーリンク表示エリア（main内に移動） -->
        <div id="calendar-link" class="calendar-buttons-container"></div>
    </div>
</main>

<!-- 🔽 英語版（コメントアウト） -->
<!--
<main class="thanks-page">
    <div class="container">
        <h1>Reservation Completed</h1>
        <p>Thank you for your reservation!</p>
        <a href="<?php echo home_url(); ?>">Back to Top Page</a>
        <div id="calendar-link" class="calendar-buttons-container"></div>
    </div>
</main>
-->

<div id="calendar-link"></div>

<?php
if ($custom_footer && file_exists($custom_footer_path)) {
    get_footer($custom_footer);
} else {
    get_footer();
}
?>
