<?php
$input_po  = 'languages/smart-booking-pro2-en_US.po';
$output_po = 'languages/smart-booking-pro2-js-en_US.po';

$lines = file($input_po);
$out = [];
$entry = [];
$references = [];
$inside_block = false;

foreach ($lines as $line) {
    // コメント行（参照）
    if (preg_match('/^#: (.+)$/', $line, $matches)) {
        $references[] = $matches[1];
        $inside_block = true;
        $entry[] = $line;
        continue;
    }

    if ($inside_block && (preg_match('/^(msgid|msgstr|msgctxt|#)/', $line) || trim($line) === '')) {
        $entry[] = $line;
    }

    // 空行が来たら1ブロック終了
    if (trim($line) === '') {
        if (!empty($references)) {
            $js_only = true;
            foreach (explode(' ', implode(' ', $references)) as $ref) {
                if (strpos($ref, 'js/') === false && strpos($ref, 'assets/js/') === false) {
                    $js_only = false;
                    break;
                }
            }
            if ($js_only) {
                $out = array_merge($out, $entry);
            }
        }

        // 初期化
        $entry = [];
        $references = [];
        $inside_block = false;
    }
}

// 最後のブロックも処理
if (!empty($entry) && !empty($references)) {
    $js_only = true;
    foreach (explode(' ', implode(' ', $references)) as $ref) {
        if (strpos($ref, 'js/') === false && strpos($ref, 'assets/js/') === false) {
            $js_only = false;
            break;
        }
    }
    if ($js_only) {
        $out = array_merge($out, $entry);
    }
}

file_put_contents($output_po, implode('', $out));
echo "✅ JS専用 .po ファイルを生成しました: {$output_po}\n";
