<?php
// ✅ 対象のJSファイル名をここに記述
$jsFile = 'script-admin.js'; // 例：同じフォルダにあるJSファイル名
$fallbackFile = 'i18n-fallback.js';

// ✅ ファイル存在チェック
if (!file_exists($jsFile)) {
    exit("Error: JavaScript file '{$jsFile}' not found.\n");
}

$jsContent = file_get_contents($jsFile);

// ✅ __("〜") パターンから翻訳対象文字列を抽出
preg_match_all('/__\(\s*[\'"](.+?)[\'"]\s*,/', $jsContent, $matches);

$uniqueKeys = array_unique($matches[1]);
sort($uniqueKeys);

// ✅ 辞書のJS形式を構築
$dictionaryLines = [];
$dictionaryLines[] = "window.sbp2_i18n_fallback = {";

foreach ($uniqueKeys as $i => $text) {
    $escapedKey = addslashes($text);
    $dictionaryLines[] = "  \"{$escapedKey}\": [\"\", \"\"]," . ($i === array_key_last($uniqueKeys) ? '' : '');
}

$dictionaryLines[] = "};";

// ✅ 書き出し
$result = implode("\n", $dictionaryLines);
file_put_contents($fallbackFile, $result);

echo "✅ 翻訳辞書ファイル '{$fallbackFile}' を作成しました。\n";
