<?php
/**
 * .poファイルから、指定JSに登場する翻訳だけを抽出し、
 * WordPress用 JavaScript 翻訳JSON（i18n用）を生成するスクリプト
 */

$po_file       = __DIR__ . '/smart-booking-pro2-en_US.po'; // 🔄 必要に応じてファイル名変更
$target_js     = 'formbuilder.js';                            // 🔄 対象JSファイル名
$textdomain    = 'smart-booking-pro2';
$locale        = 'en_US';

$output_dir    = __DIR__;
$output_md5    = md5($target_js); // ✅ 拡張子込みでハッシュ
$output_file   = "{$textdomain}-{$locale}-{$output_md5}.json";

$translations = [];

$lines = file($po_file);
if (!$lines) {
    die("❌ .poファイルが読み込めませんでした: {$po_file}\n");
}

$include = false;
$msgid = null;
$msgstr = null;

foreach ($lines as $line) {
    $line = trim($line);

    if (strpos($line, '#:') === 0 && strpos($line, $target_js) !== false) {
        $include = true;
        $msgid = null;
        $msgstr = null;
        continue;
    }

    if (strpos($line, '#:') === 0) {
        $include = false;
        continue;
    }

    if ($include) {
        if (strpos($line, 'msgid "') === 0) {
            $msgid = stripcslashes(trim(substr($line, 7), '"'));
        } elseif (strpos($line, 'msgstr "') === 0) {
            $msgstr = stripcslashes(trim(substr($line, 8), '"'));
        }

        if ($msgid !== null && $msgstr !== null) {
            $translations[$msgid] = ['', $msgstr];
            $include = false;
        }
    }
}

if (empty($translations)) {
    die("⚠️ 条件に合う翻訳データが見つかりませんでした。\n");
}

$output_json = [
    'locale_data' => [
        'messages' => array_merge(
            ['' => [
                'domain' => $textdomain,
                'lang'   => $locale
            ]],
            $translations
        )
    ]
];

file_put_contents($output_dir . '/' . $output_file, json_encode($output_json, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
echo "✅ JSONファイル生成成功: {$output_file}\n";
