<?php
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}


// ✅ チェックオプションの確認（削除しない設定なら終了）
// ✅ Check the option (exit if the "do not delete" setting is enabled)
$delete_on_uninstall = get_option('sbp2_delete_on_uninstall', false);
if ($delete_on_uninstall) {

// ✅ event-reservation の全投稿を削除
// ✅ Delete all posts of type 'event-reservation'
$posts = get_posts([
    'post_type'   => 'event-reservation',
    'post_status' => 'any',
    'numberposts' => -1,
    'fields'      => 'ids',
]);
foreach ($posts as $post_id) {
    wp_delete_post($post_id, true);
}

// ✅ reserved_daytime の全投稿を削除（←これをここに追加）
// ✅ Delete all posts of type 'reserved_daytime' (← Add this here)
$reserved_posts = get_posts([
    'post_type'   => 'reserved-daytime',
    'post_status' => 'any',
    'numberposts' => -1,
    'fields'      => 'ids',
]);
foreach ($reserved_posts as $post_id) {
    wp_delete_post($post_id, true);
}

// ✅ smart_booking_acf_data の投稿タイプ削除
// ✅ Delete posts of the custom post type 'smart_booking_acf_data'
$registered_types = get_option('smart_booking_acf_data', []);
if (is_array($registered_types)) {
    foreach ($registered_types as $type) {
        if (!empty($type['post_type'])) {
            $dynamic_posts = get_posts([
                'post_type'   => $type['post_type'],
                'post_status' => 'any',
                'numberposts' => -1,
                'fields'      => 'ids',
            ]);
            foreach ($dynamic_posts as $post_id) {
                wp_delete_post($post_id, true);
            }
        }
    }
    delete_option('smart_booking_acf_data');
}

// ✅ smart_booking_acf_db の投稿タイプ削除  
// ✅ Delete posts of the custom post type 'smart_booking_acf_db'
$dynamic_dbs = get_option('smart_booking_acf_db', []);
if (is_array($dynamic_dbs)) {
    foreach ($dynamic_dbs as $db) {
        if (!empty($db['post_type'])) {
            $custom_posts = get_posts([
                'post_type'   => $db['post_type'],
                'post_status' => 'any',
                'numberposts' => -1,
                'fields'      => 'ids',
            ]);
            foreach ($custom_posts as $post_id) {
                wp_delete_post($post_id, true);
            }
        }
    }
    delete_option('smart_booking_acf_db');
}

}

// ✅ オプション削除  
// ✅ Delete options
$option_keys = [
    'sbp2_install_id',
    'sbp2_install_meta',
    'sbp2_pro_expiry_date',
    'sbp2_next_payment_date',
    'sbp2_used_coupon',
    'sbp2_jwt_secret',
    'sbp2_plugin_status',
    'sbp2_subscription_status',
    'sbp2_stripe_customer_id',
    'sbp2_stripe_email',
    'sbp2_last_sync_at',
    'sbp2_subscription_limit_day',
    'sbp2_plan_type',
    'sbp2_subscription_payment_status',
    'sbp2_free_db_limit',
    'sbp2_free_form_limit',
    'sbp2_active_plugin_count',
    'sbp2_active_pro_count',
];
foreach ($option_keys as $key) {
    delete_option($key);
}

// ✅ 一時情報削除  
// ✅ Delete transient data
delete_transient('sbp2_install_error_reason');
